# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918

from .drg_attachment_network_update_details import DrgAttachmentNetworkUpdateDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class InternetDrgAttachmentNetworkUpdateDetails(DrgAttachmentNetworkUpdateDetails):
    """
    Update details for an Internet attachment for a DRG.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new InternetDrgAttachmentNetworkUpdateDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.vn_monitoring.models.InternetDrgAttachmentNetworkUpdateDetails.type` attribute
        of this class is ``INTERNET`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this InternetDrgAttachmentNetworkUpdateDetails.
            Allowed values for this property are: "VCN", "VIRTUAL_CIRCUIT", "LOOPBACK", "INTERNET"
        :type type: str

        :param byoip_range_ids:
            The value to assign to the byoip_range_ids property of this InternetDrgAttachmentNetworkUpdateDetails.
        :type byoip_range_ids: list[str]

        """
        self.swagger_types = {
            'type': 'str',
            'byoip_range_ids': 'list[str]'
        }
        self.attribute_map = {
            'type': 'type',
            'byoip_range_ids': 'byoipRangeIds'
        }
        self._type = None
        self._byoip_range_ids = None
        self._type = 'INTERNET'

    @property
    def byoip_range_ids(self):
        """
        Gets the byoip_range_ids of this InternetDrgAttachmentNetworkUpdateDetails.
        The list of BYOIP Range OCIDs accessible to the internet via this DRG.


        :return: The byoip_range_ids of this InternetDrgAttachmentNetworkUpdateDetails.
        :rtype: list[str]
        """
        return self._byoip_range_ids

    @byoip_range_ids.setter
    def byoip_range_ids(self, byoip_range_ids):
        """
        Sets the byoip_range_ids of this InternetDrgAttachmentNetworkUpdateDetails.
        The list of BYOIP Range OCIDs accessible to the internet via this DRG.


        :param byoip_range_ids: The byoip_range_ids of this InternetDrgAttachmentNetworkUpdateDetails.
        :type: list[str]
        """
        self._byoip_range_ids = byoip_range_ids

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
