# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ProcessSetSpecificationDetails(object):
    """
    Details of a single regular expression specification in a Process Set.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ProcessSetSpecificationDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param label:
            The value to assign to the label property of this ProcessSetSpecificationDetails.
        :type label: str

        :param process_command:
            The value to assign to the process_command property of this ProcessSetSpecificationDetails.
        :type process_command: str

        :param process_user:
            The value to assign to the process_user property of this ProcessSetSpecificationDetails.
        :type process_user: str

        :param process_line_regex_pattern:
            The value to assign to the process_line_regex_pattern property of this ProcessSetSpecificationDetails.
        :type process_line_regex_pattern: str

        """
        self.swagger_types = {
            'label': 'str',
            'process_command': 'str',
            'process_user': 'str',
            'process_line_regex_pattern': 'str'
        }
        self.attribute_map = {
            'label': 'label',
            'process_command': 'processCommand',
            'process_user': 'processUser',
            'process_line_regex_pattern': 'processLineRegexPattern'
        }
        self._label = None
        self._process_command = None
        self._process_user = None
        self._process_line_regex_pattern = None

    @property
    def label(self):
        """
        Gets the label of this ProcessSetSpecificationDetails.
        Optional label used to identify a single filter.


        :return: The label of this ProcessSetSpecificationDetails.
        :rtype: str
        """
        return self._label

    @label.setter
    def label(self, label):
        """
        Sets the label of this ProcessSetSpecificationDetails.
        Optional label used to identify a single filter.


        :param label: The label of this ProcessSetSpecificationDetails.
        :type: str
        """
        self._label = label

    @property
    def process_command(self):
        """
        Gets the process_command of this ProcessSetSpecificationDetails.
        String literal used for exact matching on process name.


        :return: The process_command of this ProcessSetSpecificationDetails.
        :rtype: str
        """
        return self._process_command

    @process_command.setter
    def process_command(self, process_command):
        """
        Sets the process_command of this ProcessSetSpecificationDetails.
        String literal used for exact matching on process name.


        :param process_command: The process_command of this ProcessSetSpecificationDetails.
        :type: str
        """
        self._process_command = process_command

    @property
    def process_user(self):
        """
        Gets the process_user of this ProcessSetSpecificationDetails.
        String literal used for exact matching on process user.


        :return: The process_user of this ProcessSetSpecificationDetails.
        :rtype: str
        """
        return self._process_user

    @process_user.setter
    def process_user(self, process_user):
        """
        Sets the process_user of this ProcessSetSpecificationDetails.
        String literal used for exact matching on process user.


        :param process_user: The process_user of this ProcessSetSpecificationDetails.
        :type: str
        """
        self._process_user = process_user

    @property
    def process_line_regex_pattern(self):
        """
        Gets the process_line_regex_pattern of this ProcessSetSpecificationDetails.
        Regex pattern matching on process arguments.


        :return: The process_line_regex_pattern of this ProcessSetSpecificationDetails.
        :rtype: str
        """
        return self._process_line_regex_pattern

    @process_line_regex_pattern.setter
    def process_line_regex_pattern(self, process_line_regex_pattern):
        """
        Sets the process_line_regex_pattern of this ProcessSetSpecificationDetails.
        Regex pattern matching on process arguments.


        :param process_line_regex_pattern: The process_line_regex_pattern of this ProcessSetSpecificationDetails.
        :type: str
        """
        self._process_line_regex_pattern = process_line_regex_pattern

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
