# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210330


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DynamicGroupDetails(object):
    """
    Dynamic Group object
    """

    #: A constant which can be used with the stack_monitoring_assignment property of a DynamicGroupDetails.
    #: This constant has a value of "MANAGEMENT_AGENTS"
    STACK_MONITORING_ASSIGNMENT_MANAGEMENT_AGENTS = "MANAGEMENT_AGENTS"

    #: A constant which can be used with the stack_monitoring_assignment property of a DynamicGroupDetails.
    #: This constant has a value of "MONITORED_INSTANCES"
    STACK_MONITORING_ASSIGNMENT_MONITORED_INSTANCES = "MONITORED_INSTANCES"

    def __init__(self, **kwargs):
        """
        Initializes a new DynamicGroupDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this DynamicGroupDetails.
        :type name: str

        :param domain:
            The value to assign to the domain property of this DynamicGroupDetails.
        :type domain: str

        :param stack_monitoring_assignment:
            The value to assign to the stack_monitoring_assignment property of this DynamicGroupDetails.
            Allowed values for this property are: "MANAGEMENT_AGENTS", "MONITORED_INSTANCES", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type stack_monitoring_assignment: str

        """
        self.swagger_types = {
            'name': 'str',
            'domain': 'str',
            'stack_monitoring_assignment': 'str'
        }
        self.attribute_map = {
            'name': 'name',
            'domain': 'domain',
            'stack_monitoring_assignment': 'stackMonitoringAssignment'
        }
        self._name = None
        self._domain = None
        self._stack_monitoring_assignment = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this DynamicGroupDetails.
        Name of dynamic Group


        :return: The name of this DynamicGroupDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DynamicGroupDetails.
        Name of dynamic Group


        :param name: The name of this DynamicGroupDetails.
        :type: str
        """
        self._name = name

    @property
    def domain(self):
        """
        Gets the domain of this DynamicGroupDetails.
        Identity domain name


        :return: The domain of this DynamicGroupDetails.
        :rtype: str
        """
        return self._domain

    @domain.setter
    def domain(self, domain):
        """
        Sets the domain of this DynamicGroupDetails.
        Identity domain name


        :param domain: The domain of this DynamicGroupDetails.
        :type: str
        """
        self._domain = domain

    @property
    def stack_monitoring_assignment(self):
        """
        **[Required]** Gets the stack_monitoring_assignment of this DynamicGroupDetails.
        Assignment of dynamic group in context of Stack Monitoring service. It describes the purpose of dynamic groups in Stack Monitoring.

        Allowed values for this property are: "MANAGEMENT_AGENTS", "MONITORED_INSTANCES", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The stack_monitoring_assignment of this DynamicGroupDetails.
        :rtype: str
        """
        return self._stack_monitoring_assignment

    @stack_monitoring_assignment.setter
    def stack_monitoring_assignment(self, stack_monitoring_assignment):
        """
        Sets the stack_monitoring_assignment of this DynamicGroupDetails.
        Assignment of dynamic group in context of Stack Monitoring service. It describes the purpose of dynamic groups in Stack Monitoring.


        :param stack_monitoring_assignment: The stack_monitoring_assignment of this DynamicGroupDetails.
        :type: str
        """
        allowed_values = ["MANAGEMENT_AGENTS", "MONITORED_INSTANCES"]
        if not value_allowed_none_or_none_sentinel(stack_monitoring_assignment, allowed_values):
            stack_monitoring_assignment = 'UNKNOWN_ENUM_VALUE'
        self._stack_monitoring_assignment = stack_monitoring_assignment

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
