# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20241031


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateTenancyAttachmentDetails(object):
    """
    The data to update a TenancyAttachment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateTenancyAttachmentDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param description:
            The value to assign to the description property of this UpdateTenancyAttachmentDetails.
        :type description: str

        """
        self.swagger_types = {
            'description': 'str'
        }
        self.attribute_map = {
            'description': 'description'
        }
        self._description = None

    @property
    def description(self):
        """
        **[Required]** Gets the description of this UpdateTenancyAttachmentDetails.
        A description of the tenancy.


        :return: The description of this UpdateTenancyAttachmentDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateTenancyAttachmentDetails.
        A description of the tenancy.


        :param description: The description of this UpdateTenancyAttachmentDetails.
        :type: str
        """
        self._description = description

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
