# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class WorkRequest(object):
    """
    A description of workrequest status
    """

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "ENABLE_DATABASE_INSIGHT"
    OPERATION_TYPE_ENABLE_DATABASE_INSIGHT = "ENABLE_DATABASE_INSIGHT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DISABLE_DATABASE_INSIGHT"
    OPERATION_TYPE_DISABLE_DATABASE_INSIGHT = "DISABLE_DATABASE_INSIGHT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "UPDATE_DATABASE_INSIGHT"
    OPERATION_TYPE_UPDATE_DATABASE_INSIGHT = "UPDATE_DATABASE_INSIGHT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CREATE_DATABASE_INSIGHT"
    OPERATION_TYPE_CREATE_DATABASE_INSIGHT = "CREATE_DATABASE_INSIGHT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "MOVE_DATABASE_INSIGHT"
    OPERATION_TYPE_MOVE_DATABASE_INSIGHT = "MOVE_DATABASE_INSIGHT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DELETE_DATABASE_INSIGHT"
    OPERATION_TYPE_DELETE_DATABASE_INSIGHT = "DELETE_DATABASE_INSIGHT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CREATE_ENTERPRISE_MANAGER_BRIDGE"
    OPERATION_TYPE_CREATE_ENTERPRISE_MANAGER_BRIDGE = "CREATE_ENTERPRISE_MANAGER_BRIDGE"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "UDPATE_ENTERPRISE_MANAGER_BRIDGE"
    OPERATION_TYPE_UDPATE_ENTERPRISE_MANAGER_BRIDGE = "UDPATE_ENTERPRISE_MANAGER_BRIDGE"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "MOVE_ENTERPRISE_MANAGER_BRIDGE"
    OPERATION_TYPE_MOVE_ENTERPRISE_MANAGER_BRIDGE = "MOVE_ENTERPRISE_MANAGER_BRIDGE"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DELETE_ENTERPRISE_MANAGER_BRIDGE"
    OPERATION_TYPE_DELETE_ENTERPRISE_MANAGER_BRIDGE = "DELETE_ENTERPRISE_MANAGER_BRIDGE"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "ENABLE_HOST_INSIGHT"
    OPERATION_TYPE_ENABLE_HOST_INSIGHT = "ENABLE_HOST_INSIGHT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DISABLE_HOST_INSIGHT"
    OPERATION_TYPE_DISABLE_HOST_INSIGHT = "DISABLE_HOST_INSIGHT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "UPDATE_HOST_INSIGHT"
    OPERATION_TYPE_UPDATE_HOST_INSIGHT = "UPDATE_HOST_INSIGHT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CREATE_HOST_INSIGHT"
    OPERATION_TYPE_CREATE_HOST_INSIGHT = "CREATE_HOST_INSIGHT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "MOVE_HOST_INSIGHT"
    OPERATION_TYPE_MOVE_HOST_INSIGHT = "MOVE_HOST_INSIGHT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DELETE_HOST_INSIGHT"
    OPERATION_TYPE_DELETE_HOST_INSIGHT = "DELETE_HOST_INSIGHT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CREATE_EXADATA_INSIGHT"
    OPERATION_TYPE_CREATE_EXADATA_INSIGHT = "CREATE_EXADATA_INSIGHT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "ENABLE_EXADATA_INSIGHT"
    OPERATION_TYPE_ENABLE_EXADATA_INSIGHT = "ENABLE_EXADATA_INSIGHT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DISABLE_EXADATA_INSIGHT"
    OPERATION_TYPE_DISABLE_EXADATA_INSIGHT = "DISABLE_EXADATA_INSIGHT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "UPDATE_EXADATA_INSIGHT"
    OPERATION_TYPE_UPDATE_EXADATA_INSIGHT = "UPDATE_EXADATA_INSIGHT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "MOVE_EXADATA_INSIGHT"
    OPERATION_TYPE_MOVE_EXADATA_INSIGHT = "MOVE_EXADATA_INSIGHT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DELETE_EXADATA_INSIGHT"
    OPERATION_TYPE_DELETE_EXADATA_INSIGHT = "DELETE_EXADATA_INSIGHT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "ADD_EXADATA_INSIGHT_MEMBERS"
    OPERATION_TYPE_ADD_EXADATA_INSIGHT_MEMBERS = "ADD_EXADATA_INSIGHT_MEMBERS"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "EXADATA_AUTO_SYNC"
    OPERATION_TYPE_EXADATA_AUTO_SYNC = "EXADATA_AUTO_SYNC"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "UPDATE_OPSI_WAREHOUSE"
    OPERATION_TYPE_UPDATE_OPSI_WAREHOUSE = "UPDATE_OPSI_WAREHOUSE"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CREATE_OPSI_WAREHOUSE"
    OPERATION_TYPE_CREATE_OPSI_WAREHOUSE = "CREATE_OPSI_WAREHOUSE"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "MOVE_OPSI_WAREHOUSE"
    OPERATION_TYPE_MOVE_OPSI_WAREHOUSE = "MOVE_OPSI_WAREHOUSE"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DELETE_OPSI_WAREHOUSE"
    OPERATION_TYPE_DELETE_OPSI_WAREHOUSE = "DELETE_OPSI_WAREHOUSE"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "ROTATE_OPSI_WAREHOUSE_WALLET"
    OPERATION_TYPE_ROTATE_OPSI_WAREHOUSE_WALLET = "ROTATE_OPSI_WAREHOUSE_WALLET"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "UPDATE_OPSI_WAREHOUSE_USER"
    OPERATION_TYPE_UPDATE_OPSI_WAREHOUSE_USER = "UPDATE_OPSI_WAREHOUSE_USER"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CREATE_OPSI_WAREHOUSE_USER"
    OPERATION_TYPE_CREATE_OPSI_WAREHOUSE_USER = "CREATE_OPSI_WAREHOUSE_USER"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "MOVE_OPSI_WAREHOUSE_USER"
    OPERATION_TYPE_MOVE_OPSI_WAREHOUSE_USER = "MOVE_OPSI_WAREHOUSE_USER"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DELETE_OPSI_WAREHOUSE_USER"
    OPERATION_TYPE_DELETE_OPSI_WAREHOUSE_USER = "DELETE_OPSI_WAREHOUSE_USER"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "UPDATE_AWRHUB"
    OPERATION_TYPE_UPDATE_AWRHUB = "UPDATE_AWRHUB"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CREATE_AWRHUB"
    OPERATION_TYPE_CREATE_AWRHUB = "CREATE_AWRHUB"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "MOVE_AWRHUB"
    OPERATION_TYPE_MOVE_AWRHUB = "MOVE_AWRHUB"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DELETE_AWRHUB"
    OPERATION_TYPE_DELETE_AWRHUB = "DELETE_AWRHUB"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "UPDATE_PRIVATE_ENDPOINT"
    OPERATION_TYPE_UPDATE_PRIVATE_ENDPOINT = "UPDATE_PRIVATE_ENDPOINT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CREATE_PRIVATE_ENDPOINT"
    OPERATION_TYPE_CREATE_PRIVATE_ENDPOINT = "CREATE_PRIVATE_ENDPOINT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "MOVE_PRIVATE_ENDPOINT"
    OPERATION_TYPE_MOVE_PRIVATE_ENDPOINT = "MOVE_PRIVATE_ENDPOINT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DELETE_PRIVATE_ENDPOINT"
    OPERATION_TYPE_DELETE_PRIVATE_ENDPOINT = "DELETE_PRIVATE_ENDPOINT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CHANGE_PE_COMANAGED_DATABASE_INSIGHT_DETAILS"
    OPERATION_TYPE_CHANGE_PE_COMANAGED_DATABASE_INSIGHT_DETAILS = "CHANGE_PE_COMANAGED_DATABASE_INSIGHT_DETAILS"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "UPDATE_OPSI_CONFIGURATION"
    OPERATION_TYPE_UPDATE_OPSI_CONFIGURATION = "UPDATE_OPSI_CONFIGURATION"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CREATE_OPSI_CONFIGURATION"
    OPERATION_TYPE_CREATE_OPSI_CONFIGURATION = "CREATE_OPSI_CONFIGURATION"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "MOVE_OPSI_CONFIGURATION"
    OPERATION_TYPE_MOVE_OPSI_CONFIGURATION = "MOVE_OPSI_CONFIGURATION"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DELETE_OPSI_CONFIGURATION"
    OPERATION_TYPE_DELETE_OPSI_CONFIGURATION = "DELETE_OPSI_CONFIGURATION"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "ENABLE_ADB_ADVANCED_FEATURES"
    OPERATION_TYPE_ENABLE_ADB_ADVANCED_FEATURES = "ENABLE_ADB_ADVANCED_FEATURES"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DISABLE_ADB_ADVANCED_FEATURES"
    OPERATION_TYPE_DISABLE_ADB_ADVANCED_FEATURES = "DISABLE_ADB_ADVANCED_FEATURES"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "UPDATE_ADB_ADVANCED_FEATURES"
    OPERATION_TYPE_UPDATE_ADB_ADVANCED_FEATURES = "UPDATE_ADB_ADVANCED_FEATURES"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CREATE_NEWS_REPORT"
    OPERATION_TYPE_CREATE_NEWS_REPORT = "CREATE_NEWS_REPORT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "ENABLE_NEWS_REPORT"
    OPERATION_TYPE_ENABLE_NEWS_REPORT = "ENABLE_NEWS_REPORT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DISABLE_NEWS_REPORT"
    OPERATION_TYPE_DISABLE_NEWS_REPORT = "DISABLE_NEWS_REPORT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "UPDATE_NEWS_REPORT"
    OPERATION_TYPE_UPDATE_NEWS_REPORT = "UPDATE_NEWS_REPORT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "MOVE_NEWS_REPORT"
    OPERATION_TYPE_MOVE_NEWS_REPORT = "MOVE_NEWS_REPORT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DELETE_NEWS_REPORT"
    OPERATION_TYPE_DELETE_NEWS_REPORT = "DELETE_NEWS_REPORT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CREATE_AWRHUB_SOURCE"
    OPERATION_TYPE_CREATE_AWRHUB_SOURCE = "CREATE_AWRHUB_SOURCE"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DELETE_AWRHUB_SOURCE"
    OPERATION_TYPE_DELETE_AWRHUB_SOURCE = "DELETE_AWRHUB_SOURCE"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "UPDATE_AWRHUB_SOURCE"
    OPERATION_TYPE_UPDATE_AWRHUB_SOURCE = "UPDATE_AWRHUB_SOURCE"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "MOVE_AWRHUB_SOURCE"
    OPERATION_TYPE_MOVE_AWRHUB_SOURCE = "MOVE_AWRHUB_SOURCE"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "ENABLE_AWRHUB_SOURCE"
    OPERATION_TYPE_ENABLE_AWRHUB_SOURCE = "ENABLE_AWRHUB_SOURCE"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DISABLE_AWRHUB_SOURCE"
    OPERATION_TYPE_DISABLE_AWRHUB_SOURCE = "DISABLE_AWRHUB_SOURCE"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CHANGE_MACS_MANAGED_CLOUD_DATABASE_INSIGHT_CONNECTION_DETAILS"
    OPERATION_TYPE_CHANGE_MACS_MANAGED_CLOUD_DATABASE_INSIGHT_CONNECTION_DETAILS = "CHANGE_MACS_MANAGED_CLOUD_DATABASE_INSIGHT_CONNECTION_DETAILS"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "TEST_MACS_MANAGED_CLOUD_DATABASE_INSIGHT_CONNECTION_DETAILS"
    OPERATION_TYPE_TEST_MACS_MANAGED_CLOUD_DATABASE_INSIGHT_CONNECTION_DETAILS = "TEST_MACS_MANAGED_CLOUD_DATABASE_INSIGHT_CONNECTION_DETAILS"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CHANGE_EXTERNAL_MYSQL_DATABASE_INSIGHT_CONNECTION_DETAILS"
    OPERATION_TYPE_CHANGE_EXTERNAL_MYSQL_DATABASE_INSIGHT_CONNECTION_DETAILS = "CHANGE_EXTERNAL_MYSQL_DATABASE_INSIGHT_CONNECTION_DETAILS"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CHANGE_MACS_MANAGED_ADB_CONNECTION_DETAILS"
    OPERATION_TYPE_CHANGE_MACS_MANAGED_ADB_CONNECTION_DETAILS = "CHANGE_MACS_MANAGED_ADB_CONNECTION_DETAILS"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "TEST_MACS_MANAGED_ADB_CONNECTION_DETAILS"
    OPERATION_TYPE_TEST_MACS_MANAGED_ADB_CONNECTION_DETAILS = "TEST_MACS_MANAGED_ADB_CONNECTION_DETAILS"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "SYNCHRONIZE_AUTONOMOUS_DATABASE_TO_EXADATA"
    OPERATION_TYPE_SYNCHRONIZE_AUTONOMOUS_DATABASE_TO_EXADATA = "SYNCHRONIZE_AUTONOMOUS_DATABASE_TO_EXADATA"

    #: A constant which can be used with the status property of a WorkRequest.
    #: This constant has a value of "ACCEPTED"
    STATUS_ACCEPTED = "ACCEPTED"

    #: A constant which can be used with the status property of a WorkRequest.
    #: This constant has a value of "IN_PROGRESS"
    STATUS_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the status property of a WorkRequest.
    #: This constant has a value of "WAITING"
    STATUS_WAITING = "WAITING"

    #: A constant which can be used with the status property of a WorkRequest.
    #: This constant has a value of "FAILED"
    STATUS_FAILED = "FAILED"

    #: A constant which can be used with the status property of a WorkRequest.
    #: This constant has a value of "SUCCEEDED"
    STATUS_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the status property of a WorkRequest.
    #: This constant has a value of "CANCELING"
    STATUS_CANCELING = "CANCELING"

    #: A constant which can be used with the status property of a WorkRequest.
    #: This constant has a value of "CANCELED"
    STATUS_CANCELED = "CANCELED"

    def __init__(self, **kwargs):
        """
        Initializes a new WorkRequest object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param operation_type:
            The value to assign to the operation_type property of this WorkRequest.
            Allowed values for this property are: "ENABLE_DATABASE_INSIGHT", "DISABLE_DATABASE_INSIGHT", "UPDATE_DATABASE_INSIGHT", "CREATE_DATABASE_INSIGHT", "MOVE_DATABASE_INSIGHT", "DELETE_DATABASE_INSIGHT", "CREATE_ENTERPRISE_MANAGER_BRIDGE", "UDPATE_ENTERPRISE_MANAGER_BRIDGE", "MOVE_ENTERPRISE_MANAGER_BRIDGE", "DELETE_ENTERPRISE_MANAGER_BRIDGE", "ENABLE_HOST_INSIGHT", "DISABLE_HOST_INSIGHT", "UPDATE_HOST_INSIGHT", "CREATE_HOST_INSIGHT", "MOVE_HOST_INSIGHT", "DELETE_HOST_INSIGHT", "CREATE_EXADATA_INSIGHT", "ENABLE_EXADATA_INSIGHT", "DISABLE_EXADATA_INSIGHT", "UPDATE_EXADATA_INSIGHT", "MOVE_EXADATA_INSIGHT", "DELETE_EXADATA_INSIGHT", "ADD_EXADATA_INSIGHT_MEMBERS", "EXADATA_AUTO_SYNC", "UPDATE_OPSI_WAREHOUSE", "CREATE_OPSI_WAREHOUSE", "MOVE_OPSI_WAREHOUSE", "DELETE_OPSI_WAREHOUSE", "ROTATE_OPSI_WAREHOUSE_WALLET", "UPDATE_OPSI_WAREHOUSE_USER", "CREATE_OPSI_WAREHOUSE_USER", "MOVE_OPSI_WAREHOUSE_USER", "DELETE_OPSI_WAREHOUSE_USER", "UPDATE_AWRHUB", "CREATE_AWRHUB", "MOVE_AWRHUB", "DELETE_AWRHUB", "UPDATE_PRIVATE_ENDPOINT", "CREATE_PRIVATE_ENDPOINT", "MOVE_PRIVATE_ENDPOINT", "DELETE_PRIVATE_ENDPOINT", "CHANGE_PE_COMANAGED_DATABASE_INSIGHT_DETAILS", "UPDATE_OPSI_CONFIGURATION", "CREATE_OPSI_CONFIGURATION", "MOVE_OPSI_CONFIGURATION", "DELETE_OPSI_CONFIGURATION", "ENABLE_ADB_ADVANCED_FEATURES", "DISABLE_ADB_ADVANCED_FEATURES", "UPDATE_ADB_ADVANCED_FEATURES", "CREATE_NEWS_REPORT", "ENABLE_NEWS_REPORT", "DISABLE_NEWS_REPORT", "UPDATE_NEWS_REPORT", "MOVE_NEWS_REPORT", "DELETE_NEWS_REPORT", "CREATE_AWRHUB_SOURCE", "DELETE_AWRHUB_SOURCE", "UPDATE_AWRHUB_SOURCE", "MOVE_AWRHUB_SOURCE", "ENABLE_AWRHUB_SOURCE", "DISABLE_AWRHUB_SOURCE", "CHANGE_MACS_MANAGED_CLOUD_DATABASE_INSIGHT_CONNECTION_DETAILS", "TEST_MACS_MANAGED_CLOUD_DATABASE_INSIGHT_CONNECTION_DETAILS", "CHANGE_EXTERNAL_MYSQL_DATABASE_INSIGHT_CONNECTION_DETAILS", "CHANGE_MACS_MANAGED_ADB_CONNECTION_DETAILS", "TEST_MACS_MANAGED_ADB_CONNECTION_DETAILS", "SYNCHRONIZE_AUTONOMOUS_DATABASE_TO_EXADATA", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type operation_type: str

        :param status:
            The value to assign to the status property of this WorkRequest.
            Allowed values for this property are: "ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param id:
            The value to assign to the id property of this WorkRequest.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this WorkRequest.
        :type compartment_id: str

        :param resources:
            The value to assign to the resources property of this WorkRequest.
        :type resources: list[oci.opsi.models.WorkRequestResource]

        :param percent_complete:
            The value to assign to the percent_complete property of this WorkRequest.
        :type percent_complete: float

        :param time_accepted:
            The value to assign to the time_accepted property of this WorkRequest.
        :type time_accepted: datetime

        :param time_started:
            The value to assign to the time_started property of this WorkRequest.
        :type time_started: datetime

        :param time_finished:
            The value to assign to the time_finished property of this WorkRequest.
        :type time_finished: datetime

        """
        self.swagger_types = {
            'operation_type': 'str',
            'status': 'str',
            'id': 'str',
            'compartment_id': 'str',
            'resources': 'list[WorkRequestResource]',
            'percent_complete': 'float',
            'time_accepted': 'datetime',
            'time_started': 'datetime',
            'time_finished': 'datetime'
        }
        self.attribute_map = {
            'operation_type': 'operationType',
            'status': 'status',
            'id': 'id',
            'compartment_id': 'compartmentId',
            'resources': 'resources',
            'percent_complete': 'percentComplete',
            'time_accepted': 'timeAccepted',
            'time_started': 'timeStarted',
            'time_finished': 'timeFinished'
        }
        self._operation_type = None
        self._status = None
        self._id = None
        self._compartment_id = None
        self._resources = None
        self._percent_complete = None
        self._time_accepted = None
        self._time_started = None
        self._time_finished = None

    @property
    def operation_type(self):
        """
        **[Required]** Gets the operation_type of this WorkRequest.
        Type of the work request

        Allowed values for this property are: "ENABLE_DATABASE_INSIGHT", "DISABLE_DATABASE_INSIGHT", "UPDATE_DATABASE_INSIGHT", "CREATE_DATABASE_INSIGHT", "MOVE_DATABASE_INSIGHT", "DELETE_DATABASE_INSIGHT", "CREATE_ENTERPRISE_MANAGER_BRIDGE", "UDPATE_ENTERPRISE_MANAGER_BRIDGE", "MOVE_ENTERPRISE_MANAGER_BRIDGE", "DELETE_ENTERPRISE_MANAGER_BRIDGE", "ENABLE_HOST_INSIGHT", "DISABLE_HOST_INSIGHT", "UPDATE_HOST_INSIGHT", "CREATE_HOST_INSIGHT", "MOVE_HOST_INSIGHT", "DELETE_HOST_INSIGHT", "CREATE_EXADATA_INSIGHT", "ENABLE_EXADATA_INSIGHT", "DISABLE_EXADATA_INSIGHT", "UPDATE_EXADATA_INSIGHT", "MOVE_EXADATA_INSIGHT", "DELETE_EXADATA_INSIGHT", "ADD_EXADATA_INSIGHT_MEMBERS", "EXADATA_AUTO_SYNC", "UPDATE_OPSI_WAREHOUSE", "CREATE_OPSI_WAREHOUSE", "MOVE_OPSI_WAREHOUSE", "DELETE_OPSI_WAREHOUSE", "ROTATE_OPSI_WAREHOUSE_WALLET", "UPDATE_OPSI_WAREHOUSE_USER", "CREATE_OPSI_WAREHOUSE_USER", "MOVE_OPSI_WAREHOUSE_USER", "DELETE_OPSI_WAREHOUSE_USER", "UPDATE_AWRHUB", "CREATE_AWRHUB", "MOVE_AWRHUB", "DELETE_AWRHUB", "UPDATE_PRIVATE_ENDPOINT", "CREATE_PRIVATE_ENDPOINT", "MOVE_PRIVATE_ENDPOINT", "DELETE_PRIVATE_ENDPOINT", "CHANGE_PE_COMANAGED_DATABASE_INSIGHT_DETAILS", "UPDATE_OPSI_CONFIGURATION", "CREATE_OPSI_CONFIGURATION", "MOVE_OPSI_CONFIGURATION", "DELETE_OPSI_CONFIGURATION", "ENABLE_ADB_ADVANCED_FEATURES", "DISABLE_ADB_ADVANCED_FEATURES", "UPDATE_ADB_ADVANCED_FEATURES", "CREATE_NEWS_REPORT", "ENABLE_NEWS_REPORT", "DISABLE_NEWS_REPORT", "UPDATE_NEWS_REPORT", "MOVE_NEWS_REPORT", "DELETE_NEWS_REPORT", "CREATE_AWRHUB_SOURCE", "DELETE_AWRHUB_SOURCE", "UPDATE_AWRHUB_SOURCE", "MOVE_AWRHUB_SOURCE", "ENABLE_AWRHUB_SOURCE", "DISABLE_AWRHUB_SOURCE", "CHANGE_MACS_MANAGED_CLOUD_DATABASE_INSIGHT_CONNECTION_DETAILS", "TEST_MACS_MANAGED_CLOUD_DATABASE_INSIGHT_CONNECTION_DETAILS", "CHANGE_EXTERNAL_MYSQL_DATABASE_INSIGHT_CONNECTION_DETAILS", "CHANGE_MACS_MANAGED_ADB_CONNECTION_DETAILS", "TEST_MACS_MANAGED_ADB_CONNECTION_DETAILS", "SYNCHRONIZE_AUTONOMOUS_DATABASE_TO_EXADATA", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The operation_type of this WorkRequest.
        :rtype: str
        """
        return self._operation_type

    @operation_type.setter
    def operation_type(self, operation_type):
        """
        Sets the operation_type of this WorkRequest.
        Type of the work request


        :param operation_type: The operation_type of this WorkRequest.
        :type: str
        """
        allowed_values = ["ENABLE_DATABASE_INSIGHT", "DISABLE_DATABASE_INSIGHT", "UPDATE_DATABASE_INSIGHT", "CREATE_DATABASE_INSIGHT", "MOVE_DATABASE_INSIGHT", "DELETE_DATABASE_INSIGHT", "CREATE_ENTERPRISE_MANAGER_BRIDGE", "UDPATE_ENTERPRISE_MANAGER_BRIDGE", "MOVE_ENTERPRISE_MANAGER_BRIDGE", "DELETE_ENTERPRISE_MANAGER_BRIDGE", "ENABLE_HOST_INSIGHT", "DISABLE_HOST_INSIGHT", "UPDATE_HOST_INSIGHT", "CREATE_HOST_INSIGHT", "MOVE_HOST_INSIGHT", "DELETE_HOST_INSIGHT", "CREATE_EXADATA_INSIGHT", "ENABLE_EXADATA_INSIGHT", "DISABLE_EXADATA_INSIGHT", "UPDATE_EXADATA_INSIGHT", "MOVE_EXADATA_INSIGHT", "DELETE_EXADATA_INSIGHT", "ADD_EXADATA_INSIGHT_MEMBERS", "EXADATA_AUTO_SYNC", "UPDATE_OPSI_WAREHOUSE", "CREATE_OPSI_WAREHOUSE", "MOVE_OPSI_WAREHOUSE", "DELETE_OPSI_WAREHOUSE", "ROTATE_OPSI_WAREHOUSE_WALLET", "UPDATE_OPSI_WAREHOUSE_USER", "CREATE_OPSI_WAREHOUSE_USER", "MOVE_OPSI_WAREHOUSE_USER", "DELETE_OPSI_WAREHOUSE_USER", "UPDATE_AWRHUB", "CREATE_AWRHUB", "MOVE_AWRHUB", "DELETE_AWRHUB", "UPDATE_PRIVATE_ENDPOINT", "CREATE_PRIVATE_ENDPOINT", "MOVE_PRIVATE_ENDPOINT", "DELETE_PRIVATE_ENDPOINT", "CHANGE_PE_COMANAGED_DATABASE_INSIGHT_DETAILS", "UPDATE_OPSI_CONFIGURATION", "CREATE_OPSI_CONFIGURATION", "MOVE_OPSI_CONFIGURATION", "DELETE_OPSI_CONFIGURATION", "ENABLE_ADB_ADVANCED_FEATURES", "DISABLE_ADB_ADVANCED_FEATURES", "UPDATE_ADB_ADVANCED_FEATURES", "CREATE_NEWS_REPORT", "ENABLE_NEWS_REPORT", "DISABLE_NEWS_REPORT", "UPDATE_NEWS_REPORT", "MOVE_NEWS_REPORT", "DELETE_NEWS_REPORT", "CREATE_AWRHUB_SOURCE", "DELETE_AWRHUB_SOURCE", "UPDATE_AWRHUB_SOURCE", "MOVE_AWRHUB_SOURCE", "ENABLE_AWRHUB_SOURCE", "DISABLE_AWRHUB_SOURCE", "CHANGE_MACS_MANAGED_CLOUD_DATABASE_INSIGHT_CONNECTION_DETAILS", "TEST_MACS_MANAGED_CLOUD_DATABASE_INSIGHT_CONNECTION_DETAILS", "CHANGE_EXTERNAL_MYSQL_DATABASE_INSIGHT_CONNECTION_DETAILS", "CHANGE_MACS_MANAGED_ADB_CONNECTION_DETAILS", "TEST_MACS_MANAGED_ADB_CONNECTION_DETAILS", "SYNCHRONIZE_AUTONOMOUS_DATABASE_TO_EXADATA"]
        if not value_allowed_none_or_none_sentinel(operation_type, allowed_values):
            operation_type = 'UNKNOWN_ENUM_VALUE'
        self._operation_type = operation_type

    @property
    def status(self):
        """
        **[Required]** Gets the status of this WorkRequest.
        Status of current work request.

        Allowed values for this property are: "ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this WorkRequest.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this WorkRequest.
        Status of current work request.


        :param status: The status of this WorkRequest.
        :type: str
        """
        allowed_values = ["ACCEPTED", "IN_PROGRESS", "WAITING", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def id(self):
        """
        **[Required]** Gets the id of this WorkRequest.
        The id of the work request.


        :return: The id of this WorkRequest.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this WorkRequest.
        The id of the work request.


        :param id: The id of this WorkRequest.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this WorkRequest.
        The ocid of the compartment that contains the work request. Work requests should be scoped to
        the same compartment as the resource the work request affects. If the work request affects multiple resources,
        and those resources are not in the same compartment, it is up to the service team to pick the primary
        resource whose compartment should be used


        :return: The compartment_id of this WorkRequest.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this WorkRequest.
        The ocid of the compartment that contains the work request. Work requests should be scoped to
        the same compartment as the resource the work request affects. If the work request affects multiple resources,
        and those resources are not in the same compartment, it is up to the service team to pick the primary
        resource whose compartment should be used


        :param compartment_id: The compartment_id of this WorkRequest.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resources(self):
        """
        **[Required]** Gets the resources of this WorkRequest.
        The resources affected by this work request.


        :return: The resources of this WorkRequest.
        :rtype: list[oci.opsi.models.WorkRequestResource]
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """
        Sets the resources of this WorkRequest.
        The resources affected by this work request.


        :param resources: The resources of this WorkRequest.
        :type: list[oci.opsi.models.WorkRequestResource]
        """
        self._resources = resources

    @property
    def percent_complete(self):
        """
        **[Required]** Gets the percent_complete of this WorkRequest.
        Percentage of the request completed.


        :return: The percent_complete of this WorkRequest.
        :rtype: float
        """
        return self._percent_complete

    @percent_complete.setter
    def percent_complete(self, percent_complete):
        """
        Sets the percent_complete of this WorkRequest.
        Percentage of the request completed.


        :param percent_complete: The percent_complete of this WorkRequest.
        :type: float
        """
        self._percent_complete = percent_complete

    @property
    def time_accepted(self):
        """
        **[Required]** Gets the time_accepted of this WorkRequest.
        The date and time the request was created, as described in
        `RFC 3339`__, section 14.29.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_accepted of this WorkRequest.
        :rtype: datetime
        """
        return self._time_accepted

    @time_accepted.setter
    def time_accepted(self, time_accepted):
        """
        Sets the time_accepted of this WorkRequest.
        The date and time the request was created, as described in
        `RFC 3339`__, section 14.29.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_accepted: The time_accepted of this WorkRequest.
        :type: datetime
        """
        self._time_accepted = time_accepted

    @property
    def time_started(self):
        """
        Gets the time_started of this WorkRequest.
        The date and time the request was started, as described in `RFC 3339`__,
        section 14.29.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_started of this WorkRequest.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this WorkRequest.
        The date and time the request was started, as described in `RFC 3339`__,
        section 14.29.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_started: The time_started of this WorkRequest.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_finished(self):
        """
        Gets the time_finished of this WorkRequest.
        The date and time the object was finished, as described in `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_finished of this WorkRequest.
        :rtype: datetime
        """
        return self._time_finished

    @time_finished.setter
    def time_finished(self, time_finished):
        """
        Sets the time_finished of this WorkRequest.
        The date and time the object was finished, as described in `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_finished: The time_finished of this WorkRequest.
        :type: datetime
        """
        self._time_finished = time_finished

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
