# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20170115


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateLoadBalancerDetails(object):
    """
    Configuration details to update a load balancer.

    **Warning:** Oracle recommends that you avoid using any confidential information when you supply string values using the API.
    """

    #: A constant which can be used with the ip_mode property of a UpdateLoadBalancerDetails.
    #: This constant has a value of "IPV4"
    IP_MODE_IPV4 = "IPV4"

    #: A constant which can be used with the ip_mode property of a UpdateLoadBalancerDetails.
    #: This constant has a value of "IPV6"
    IP_MODE_IPV6 = "IPV6"

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateLoadBalancerDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateLoadBalancerDetails.
        :type display_name: str

        :param ip_mode:
            The value to assign to the ip_mode property of this UpdateLoadBalancerDetails.
            Allowed values for this property are: "IPV4", "IPV6"
        :type ip_mode: str

        :param ipv6_subnet_cidr:
            The value to assign to the ipv6_subnet_cidr property of this UpdateLoadBalancerDetails.
        :type ipv6_subnet_cidr: str

        :param reserved_ips:
            The value to assign to the reserved_ips property of this UpdateLoadBalancerDetails.
        :type reserved_ips: list[oci.load_balancer.models.ReservedIP]

        :param is_delete_protection_enabled:
            The value to assign to the is_delete_protection_enabled property of this UpdateLoadBalancerDetails.
        :type is_delete_protection_enabled: bool

        :param is_request_id_enabled:
            The value to assign to the is_request_id_enabled property of this UpdateLoadBalancerDetails.
        :type is_request_id_enabled: bool

        :param request_id_header:
            The value to assign to the request_id_header property of this UpdateLoadBalancerDetails.
        :type request_id_header: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateLoadBalancerDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateLoadBalancerDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param security_attributes:
            The value to assign to the security_attributes property of this UpdateLoadBalancerDetails.
        :type security_attributes: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'ip_mode': 'str',
            'ipv6_subnet_cidr': 'str',
            'reserved_ips': 'list[ReservedIP]',
            'is_delete_protection_enabled': 'bool',
            'is_request_id_enabled': 'bool',
            'request_id_header': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'security_attributes': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'ip_mode': 'ipMode',
            'ipv6_subnet_cidr': 'ipv6SubnetCidr',
            'reserved_ips': 'reservedIps',
            'is_delete_protection_enabled': 'isDeleteProtectionEnabled',
            'is_request_id_enabled': 'isRequestIdEnabled',
            'request_id_header': 'requestIdHeader',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'security_attributes': 'securityAttributes'
        }
        self._display_name = None
        self._ip_mode = None
        self._ipv6_subnet_cidr = None
        self._reserved_ips = None
        self._is_delete_protection_enabled = None
        self._is_request_id_enabled = None
        self._request_id_header = None
        self._freeform_tags = None
        self._defined_tags = None
        self._security_attributes = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateLoadBalancerDetails.
        The user-friendly display name for the load balancer. It does not have to be unique, and it is changeable.
        Avoid entering confidential information.

        Example: `example_load_balancer`


        :return: The display_name of this UpdateLoadBalancerDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateLoadBalancerDetails.
        The user-friendly display name for the load balancer. It does not have to be unique, and it is changeable.
        Avoid entering confidential information.

        Example: `example_load_balancer`


        :param display_name: The display_name of this UpdateLoadBalancerDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def ip_mode(self):
        """
        Gets the ip_mode of this UpdateLoadBalancerDetails.
        Whether the load balancer has an IPv4 or IPv6 IP address.

          If \"IPV4\", the service assigns an IPv4 address and the load balancer supports IPv4 traffic.

          If \"IPV6\", the service assigns an IPv6 address and the load balancer supports IPv6 traffic.

          Example: \"ipMode\":\"IPV6\"

        Allowed values for this property are: "IPV4", "IPV6"


        :return: The ip_mode of this UpdateLoadBalancerDetails.
        :rtype: str
        """
        return self._ip_mode

    @ip_mode.setter
    def ip_mode(self, ip_mode):
        """
        Sets the ip_mode of this UpdateLoadBalancerDetails.
        Whether the load balancer has an IPv4 or IPv6 IP address.

          If \"IPV4\", the service assigns an IPv4 address and the load balancer supports IPv4 traffic.

          If \"IPV6\", the service assigns an IPv6 address and the load balancer supports IPv6 traffic.

          Example: \"ipMode\":\"IPV6\"


        :param ip_mode: The ip_mode of this UpdateLoadBalancerDetails.
        :type: str
        """
        allowed_values = ["IPV4", "IPV6"]
        if not value_allowed_none_or_none_sentinel(ip_mode, allowed_values):
            raise ValueError(
                f"Invalid value for `ip_mode`, must be None or one of {allowed_values}"
            )
        self._ip_mode = ip_mode

    @property
    def ipv6_subnet_cidr(self):
        """
        Gets the ipv6_subnet_cidr of this UpdateLoadBalancerDetails.
        Used to disambiguate which subnet prefix should be used to create an IPv6 LB.

        Example: \"2002::1234:abcd:ffff:c0a8:101/64\"


        :return: The ipv6_subnet_cidr of this UpdateLoadBalancerDetails.
        :rtype: str
        """
        return self._ipv6_subnet_cidr

    @ipv6_subnet_cidr.setter
    def ipv6_subnet_cidr(self, ipv6_subnet_cidr):
        """
        Sets the ipv6_subnet_cidr of this UpdateLoadBalancerDetails.
        Used to disambiguate which subnet prefix should be used to create an IPv6 LB.

        Example: \"2002::1234:abcd:ffff:c0a8:101/64\"


        :param ipv6_subnet_cidr: The ipv6_subnet_cidr of this UpdateLoadBalancerDetails.
        :type: str
        """
        self._ipv6_subnet_cidr = ipv6_subnet_cidr

    @property
    def reserved_ips(self):
        """
        Gets the reserved_ips of this UpdateLoadBalancerDetails.
        An array of reserved Ips.


        :return: The reserved_ips of this UpdateLoadBalancerDetails.
        :rtype: list[oci.load_balancer.models.ReservedIP]
        """
        return self._reserved_ips

    @reserved_ips.setter
    def reserved_ips(self, reserved_ips):
        """
        Sets the reserved_ips of this UpdateLoadBalancerDetails.
        An array of reserved Ips.


        :param reserved_ips: The reserved_ips of this UpdateLoadBalancerDetails.
        :type: list[oci.load_balancer.models.ReservedIP]
        """
        self._reserved_ips = reserved_ips

    @property
    def is_delete_protection_enabled(self):
        """
        Gets the is_delete_protection_enabled of this UpdateLoadBalancerDetails.
        Whether or not the load balancer has delete protection enabled.

        If \"true\", the loadbalancer will be protected against deletion if configured to accept traffic.

        If \"false\", the loadbalancer will not be protected against deletion.

        If null or unset, the value for delete protection will not be changed.

        Example: `true`


        :return: The is_delete_protection_enabled of this UpdateLoadBalancerDetails.
        :rtype: bool
        """
        return self._is_delete_protection_enabled

    @is_delete_protection_enabled.setter
    def is_delete_protection_enabled(self, is_delete_protection_enabled):
        """
        Sets the is_delete_protection_enabled of this UpdateLoadBalancerDetails.
        Whether or not the load balancer has delete protection enabled.

        If \"true\", the loadbalancer will be protected against deletion if configured to accept traffic.

        If \"false\", the loadbalancer will not be protected against deletion.

        If null or unset, the value for delete protection will not be changed.

        Example: `true`


        :param is_delete_protection_enabled: The is_delete_protection_enabled of this UpdateLoadBalancerDetails.
        :type: bool
        """
        self._is_delete_protection_enabled = is_delete_protection_enabled

    @property
    def is_request_id_enabled(self):
        """
        Gets the is_request_id_enabled of this UpdateLoadBalancerDetails.
        Whether or not the load balancer has the Request Id feature enabled for HTTP listeners.

        If \"true\", the load balancer will attach a unique request id header to every request
        passed through from the load balancer to load balancer backends. This same request id
        header also will be added to the response the lb received from the backend handling
        the request before the load balancer returns the response to the requestor. The name
        of the unique request id header is set the by value of requestIdHeader.

        If \"false\", the loadbalancer not add this unique request id header to either the request
        passed through to the load balancer backends nor to the reponse returned to the user.

        New load balancers have the Request Id feature enabled unless isRequestIdEnabled is set to False.

        Example: `true`


        :return: The is_request_id_enabled of this UpdateLoadBalancerDetails.
        :rtype: bool
        """
        return self._is_request_id_enabled

    @is_request_id_enabled.setter
    def is_request_id_enabled(self, is_request_id_enabled):
        """
        Sets the is_request_id_enabled of this UpdateLoadBalancerDetails.
        Whether or not the load balancer has the Request Id feature enabled for HTTP listeners.

        If \"true\", the load balancer will attach a unique request id header to every request
        passed through from the load balancer to load balancer backends. This same request id
        header also will be added to the response the lb received from the backend handling
        the request before the load balancer returns the response to the requestor. The name
        of the unique request id header is set the by value of requestIdHeader.

        If \"false\", the loadbalancer not add this unique request id header to either the request
        passed through to the load balancer backends nor to the reponse returned to the user.

        New load balancers have the Request Id feature enabled unless isRequestIdEnabled is set to False.

        Example: `true`


        :param is_request_id_enabled: The is_request_id_enabled of this UpdateLoadBalancerDetails.
        :type: bool
        """
        self._is_request_id_enabled = is_request_id_enabled

    @property
    def request_id_header(self):
        """
        Gets the request_id_header of this UpdateLoadBalancerDetails.
        If isRequestIdEnabled is true then this field contains the name of the header field
        that contains the unique request id that is attached to every request from
        the load balancer to the load balancer backends and to every response from the load
        balancer.

        If a request to the load balancer already contains a header with same name as specified
        in requestIdHeader then the load balancer will not change the value of that field.

        If isRequestIdEnabled is false then this field is ignored.

        **Notes:**
        * Unless the header name is \"\" it must start with \"X-\" prefix.
        * Setting the header name to \"\" will set it to the default: X-Request-Id.


        :return: The request_id_header of this UpdateLoadBalancerDetails.
        :rtype: str
        """
        return self._request_id_header

    @request_id_header.setter
    def request_id_header(self, request_id_header):
        """
        Sets the request_id_header of this UpdateLoadBalancerDetails.
        If isRequestIdEnabled is true then this field contains the name of the header field
        that contains the unique request id that is attached to every request from
        the load balancer to the load balancer backends and to every response from the load
        balancer.

        If a request to the load balancer already contains a header with same name as specified
        in requestIdHeader then the load balancer will not change the value of that field.

        If isRequestIdEnabled is false then this field is ignored.

        **Notes:**
        * Unless the header name is \"\" it must start with \"X-\" prefix.
        * Setting the header name to \"\" will set it to the default: X-Request-Id.


        :param request_id_header: The request_id_header of this UpdateLoadBalancerDetails.
        :type: str
        """
        self._request_id_header = request_id_header

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateLoadBalancerDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateLoadBalancerDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateLoadBalancerDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateLoadBalancerDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateLoadBalancerDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateLoadBalancerDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateLoadBalancerDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateLoadBalancerDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def security_attributes(self):
        """
        Gets the security_attributes of this UpdateLoadBalancerDetails.
        Extended Defined tags for ZPR for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"Oracle-ZPR\": {\"MaxEgressCount\": {\"value\":\"42\",\"mode\":\"audit\", \"usagetype\" : \"zpr\"}}}`


        :return: The security_attributes of this UpdateLoadBalancerDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._security_attributes

    @security_attributes.setter
    def security_attributes(self, security_attributes):
        """
        Sets the security_attributes of this UpdateLoadBalancerDetails.
        Extended Defined tags for ZPR for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"Oracle-ZPR\": {\"MaxEgressCount\": {\"value\":\"42\",\"mode\":\"audit\", \"usagetype\" : \"zpr\"}}}`


        :param security_attributes: The security_attributes of this UpdateLoadBalancerDetails.
        :type: dict(str, dict(str, object))
        """
        self._security_attributes = security_attributes

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
