# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ImportedModelSummary(object):
    """
    Summary of the importedModel.
    """

    #: A constant which can be used with the capabilities property of a ImportedModelSummary.
    #: This constant has a value of "TEXT_TO_TEXT"
    CAPABILITIES_TEXT_TO_TEXT = "TEXT_TO_TEXT"

    #: A constant which can be used with the capabilities property of a ImportedModelSummary.
    #: This constant has a value of "IMAGE_TEXT_TO_TEXT"
    CAPABILITIES_IMAGE_TEXT_TO_TEXT = "IMAGE_TEXT_TO_TEXT"

    #: A constant which can be used with the capabilities property of a ImportedModelSummary.
    #: This constant has a value of "EMBEDDING"
    CAPABILITIES_EMBEDDING = "EMBEDDING"

    #: A constant which can be used with the capabilities property of a ImportedModelSummary.
    #: This constant has a value of "RERANK"
    CAPABILITIES_RERANK = "RERANK"

    def __init__(self, **kwargs):
        """
        Initializes a new ImportedModelSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ImportedModelSummary.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this ImportedModelSummary.
        :type display_name: str

        :param description:
            The value to assign to the description property of this ImportedModelSummary.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ImportedModelSummary.
        :type compartment_id: str

        :param capabilities:
            The value to assign to the capabilities property of this ImportedModelSummary.
            Allowed values for items in this list are: "TEXT_TO_TEXT", "IMAGE_TEXT_TO_TEXT", "EMBEDDING", "RERANK", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type capabilities: list[str]

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ImportedModelSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this ImportedModelSummary.
        :type lifecycle_details: str

        :param vendor:
            The value to assign to the vendor property of this ImportedModelSummary.
        :type vendor: str

        :param version:
            The value to assign to the version property of this ImportedModelSummary.
        :type version: str

        :param data_source:
            The value to assign to the data_source property of this ImportedModelSummary.
        :type data_source: oci.generative_ai.models.ModelDataSource

        :param time_created:
            The value to assign to the time_created property of this ImportedModelSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ImportedModelSummary.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ImportedModelSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ImportedModelSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ImportedModelSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'capabilities': 'list[str]',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'vendor': 'str',
            'version': 'str',
            'data_source': 'ModelDataSource',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'capabilities': 'capabilities',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'vendor': 'vendor',
            'version': 'version',
            'data_source': 'dataSource',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._display_name = None
        self._description = None
        self._compartment_id = None
        self._capabilities = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._vendor = None
        self._version = None
        self._data_source = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ImportedModelSummary.
        An OCID that uniquely identifies an imported model.


        :return: The id of this ImportedModelSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ImportedModelSummary.
        An OCID that uniquely identifies an imported model.


        :param id: The id of this ImportedModelSummary.
        :type: str
        """
        self._id = id

    @property
    def display_name(self):
        """
        Gets the display_name of this ImportedModelSummary.
        A user-friendly name of the imported model.


        :return: The display_name of this ImportedModelSummary.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this ImportedModelSummary.
        A user-friendly name of the imported model.


        :param display_name: The display_name of this ImportedModelSummary.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this ImportedModelSummary.
        An optional description of the imported model.


        :return: The description of this ImportedModelSummary.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ImportedModelSummary.
        An optional description of the imported model.


        :param description: The description of this ImportedModelSummary.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ImportedModelSummary.
        The compartment OCID from which the model is imported.


        :return: The compartment_id of this ImportedModelSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ImportedModelSummary.
        The compartment OCID from which the model is imported.


        :param compartment_id: The compartment_id of this ImportedModelSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def capabilities(self):
        """
        Gets the capabilities of this ImportedModelSummary.
        Specifies the intended use or supported capabilities of the imported model.

        Allowed values for items in this list are: "TEXT_TO_TEXT", "IMAGE_TEXT_TO_TEXT", "EMBEDDING", "RERANK", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The capabilities of this ImportedModelSummary.
        :rtype: list[str]
        """
        return self._capabilities

    @capabilities.setter
    def capabilities(self, capabilities):
        """
        Sets the capabilities of this ImportedModelSummary.
        Specifies the intended use or supported capabilities of the imported model.


        :param capabilities: The capabilities of this ImportedModelSummary.
        :type: list[str]
        """
        allowed_values = ["TEXT_TO_TEXT", "IMAGE_TEXT_TO_TEXT", "EMBEDDING", "RERANK"]
        if capabilities:
            capabilities[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in capabilities]
        self._capabilities = capabilities

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ImportedModelSummary.
        The lifecycle state of the imported model.

        Allowed values are:
        - ACTIVE
        - CREATING
        - UPDATING
        - DELETING
        - DELETED
        - FAILED


        :return: The lifecycle_state of this ImportedModelSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ImportedModelSummary.
        The lifecycle state of the imported model.

        Allowed values are:
        - ACTIVE
        - CREATING
        - UPDATING
        - DELETING
        - DELETED
        - FAILED


        :param lifecycle_state: The lifecycle_state of this ImportedModelSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this ImportedModelSummary.
        Additional information about the current state of the imported model, providing more detailed and actionable context.


        :return: The lifecycle_details of this ImportedModelSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this ImportedModelSummary.
        Additional information about the current state of the imported model, providing more detailed and actionable context.


        :param lifecycle_details: The lifecycle_details of this ImportedModelSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def vendor(self):
        """
        Gets the vendor of this ImportedModelSummary.
        The provider of the imported model.


        :return: The vendor of this ImportedModelSummary.
        :rtype: str
        """
        return self._vendor

    @vendor.setter
    def vendor(self, vendor):
        """
        Sets the vendor of this ImportedModelSummary.
        The provider of the imported model.


        :param vendor: The vendor of this ImportedModelSummary.
        :type: str
        """
        self._vendor = vendor

    @property
    def version(self):
        """
        Gets the version of this ImportedModelSummary.
        The version of the imported model.


        :return: The version of this ImportedModelSummary.
        :rtype: str
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this ImportedModelSummary.
        The version of the imported model.


        :param version: The version of this ImportedModelSummary.
        :type: str
        """
        self._version = version

    @property
    def data_source(self):
        """
        **[Required]** Gets the data_source of this ImportedModelSummary.

        :return: The data_source of this ImportedModelSummary.
        :rtype: oci.generative_ai.models.ModelDataSource
        """
        return self._data_source

    @data_source.setter
    def data_source(self, data_source):
        """
        Sets the data_source of this ImportedModelSummary.

        :param data_source: The data_source of this ImportedModelSummary.
        :type: oci.generative_ai.models.ModelDataSource
        """
        self._data_source = data_source

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ImportedModelSummary.
        The date and time that the imported model was created in the format of an RFC3339 datetime string.


        :return: The time_created of this ImportedModelSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ImportedModelSummary.
        The date and time that the imported model was created in the format of an RFC3339 datetime string.


        :param time_created: The time_created of this ImportedModelSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this ImportedModelSummary.
        The date and time that the imported model was updated in the format of an RFC3339 datetime string.


        :return: The time_updated of this ImportedModelSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ImportedModelSummary.
        The date and time that the imported model was updated in the format of an RFC3339 datetime string.


        :param time_updated: The time_updated of this ImportedModelSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ImportedModelSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ImportedModelSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ImportedModelSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ImportedModelSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ImportedModelSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ImportedModelSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ImportedModelSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ImportedModelSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ImportedModelSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ImportedModelSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ImportedModelSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ImportedModelSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
