# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220528

from .fsu_cycle import FsuCycle
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpgradeFsuCycle(FsuCycle):
    """
    Upgrade Exadata Fleet Update Cycle resource details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpgradeFsuCycle object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_software_update.models.UpgradeFsuCycle.type` attribute
        of this class is ``UPGRADE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this UpgradeFsuCycle.
        :type id: str

        :param display_name:
            The value to assign to the display_name property of this UpgradeFsuCycle.
        :type display_name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this UpgradeFsuCycle.
        :type compartment_id: str

        :param type:
            The value to assign to the type property of this UpgradeFsuCycle.
            Allowed values for this property are: "PATCH", "UPGRADE"
        :type type: str

        :param fsu_collection_id:
            The value to assign to the fsu_collection_id property of this UpgradeFsuCycle.
        :type fsu_collection_id: str

        :param collection_type:
            The value to assign to the collection_type property of this UpgradeFsuCycle.
            Allowed values for this property are: "DB", "GI", "GUEST_OS", "EXADB_STACK"
        :type collection_type: str

        :param executing_fsu_action_id:
            The value to assign to the executing_fsu_action_id property of this UpgradeFsuCycle.
        :type executing_fsu_action_id: str

        :param next_action_to_execute:
            The value to assign to the next_action_to_execute property of this UpgradeFsuCycle.
        :type next_action_to_execute: list[oci.fleet_software_update.models.NextActionToExecuteDetails]

        :param last_completed_action_id:
            The value to assign to the last_completed_action_id property of this UpgradeFsuCycle.
        :type last_completed_action_id: str

        :param rollback_cycle_state:
            The value to assign to the rollback_cycle_state property of this UpgradeFsuCycle.
            Allowed values for this property are: "ABLE_TO_EXECUTE", "IN_PROGRESS", "FAILED", "NEEDS_ATTENTION", "SUCCEEDED"
        :type rollback_cycle_state: str

        :param last_completed_action:
            The value to assign to the last_completed_action property of this UpgradeFsuCycle.
            Allowed values for this property are: "STAGE", "PRECHECK_STAGE", "PRECHECK_APPLY", "APPLY", "ROLLBACK_AND_REMOVE_TARGET", "CLEANUP", "ROLLBACK_MAINTENANCE_CYCLE"
        :type last_completed_action: str

        :param goal_version_details:
            The value to assign to the goal_version_details property of this UpgradeFsuCycle.
        :type goal_version_details: oci.fleet_software_update.models.FsuGoalVersionDetails

        :param batching_strategy:
            The value to assign to the batching_strategy property of this UpgradeFsuCycle.
        :type batching_strategy: oci.fleet_software_update.models.BatchingStrategyDetails

        :param stage_action_schedule:
            The value to assign to the stage_action_schedule property of this UpgradeFsuCycle.
        :type stage_action_schedule: oci.fleet_software_update.models.ScheduleDetails

        :param apply_action_schedule:
            The value to assign to the apply_action_schedule property of this UpgradeFsuCycle.
        :type apply_action_schedule: oci.fleet_software_update.models.ScheduleDetails

        :param diagnostics_collection:
            The value to assign to the diagnostics_collection property of this UpgradeFsuCycle.
        :type diagnostics_collection: oci.fleet_software_update.models.DiagnosticsCollectionDetails

        :param time_created:
            The value to assign to the time_created property of this UpgradeFsuCycle.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this UpgradeFsuCycle.
        :type time_updated: datetime

        :param time_finished:
            The value to assign to the time_finished property of this UpgradeFsuCycle.
        :type time_finished: datetime

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this UpgradeFsuCycle.
            Allowed values for this property are: "CREATING", "ACTIVE", "UPDATING", "IN_PROGRESS", "FAILED", "NEEDS_ATTENTION", "SUCCEEDED", "DELETING", "DELETED"
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this UpgradeFsuCycle.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpgradeFsuCycle.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpgradeFsuCycle.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this UpgradeFsuCycle.
        :type system_tags: dict(str, dict(str, object))

        :param upgrade_details:
            The value to assign to the upgrade_details property of this UpgradeFsuCycle.
        :type upgrade_details: oci.fleet_software_update.models.UpgradeDetails

        """
        self.swagger_types = {
            'id': 'str',
            'display_name': 'str',
            'compartment_id': 'str',
            'type': 'str',
            'fsu_collection_id': 'str',
            'collection_type': 'str',
            'executing_fsu_action_id': 'str',
            'next_action_to_execute': 'list[NextActionToExecuteDetails]',
            'last_completed_action_id': 'str',
            'rollback_cycle_state': 'str',
            'last_completed_action': 'str',
            'goal_version_details': 'FsuGoalVersionDetails',
            'batching_strategy': 'BatchingStrategyDetails',
            'stage_action_schedule': 'ScheduleDetails',
            'apply_action_schedule': 'ScheduleDetails',
            'diagnostics_collection': 'DiagnosticsCollectionDetails',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'time_finished': 'datetime',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'upgrade_details': 'UpgradeDetails'
        }
        self.attribute_map = {
            'id': 'id',
            'display_name': 'displayName',
            'compartment_id': 'compartmentId',
            'type': 'type',
            'fsu_collection_id': 'fsuCollectionId',
            'collection_type': 'collectionType',
            'executing_fsu_action_id': 'executingFsuActionId',
            'next_action_to_execute': 'nextActionToExecute',
            'last_completed_action_id': 'lastCompletedActionId',
            'rollback_cycle_state': 'rollbackCycleState',
            'last_completed_action': 'lastCompletedAction',
            'goal_version_details': 'goalVersionDetails',
            'batching_strategy': 'batchingStrategy',
            'stage_action_schedule': 'stageActionSchedule',
            'apply_action_schedule': 'applyActionSchedule',
            'diagnostics_collection': 'diagnosticsCollection',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'time_finished': 'timeFinished',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'upgrade_details': 'upgradeDetails'
        }
        self._id = None
        self._display_name = None
        self._compartment_id = None
        self._type = None
        self._fsu_collection_id = None
        self._collection_type = None
        self._executing_fsu_action_id = None
        self._next_action_to_execute = None
        self._last_completed_action_id = None
        self._rollback_cycle_state = None
        self._last_completed_action = None
        self._goal_version_details = None
        self._batching_strategy = None
        self._stage_action_schedule = None
        self._apply_action_schedule = None
        self._diagnostics_collection = None
        self._time_created = None
        self._time_updated = None
        self._time_finished = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._upgrade_details = None
        self._type = 'UPGRADE'

    @property
    def upgrade_details(self):
        """
        Gets the upgrade_details of this UpgradeFsuCycle.

        :return: The upgrade_details of this UpgradeFsuCycle.
        :rtype: oci.fleet_software_update.models.UpgradeDetails
        """
        return self._upgrade_details

    @upgrade_details.setter
    def upgrade_details(self, upgrade_details):
        """
        Sets the upgrade_details of this UpgradeFsuCycle.

        :param upgrade_details: The upgrade_details of this UpgradeFsuCycle.
        :type: oci.fleet_software_update.models.UpgradeDetails
        """
        self._upgrade_details = upgrade_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
