# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SubnetVariableDependsOn(object):
    """
    Depends on object for Subnet Variables.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SubnetVariableDependsOn object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vcn_id:
            The value to assign to the vcn_id property of this SubnetVariableDependsOn.
        :type vcn_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this SubnetVariableDependsOn.
        :type compartment_id: str

        :param hide_public_subnet:
            The value to assign to the hide_public_subnet property of this SubnetVariableDependsOn.
        :type hide_public_subnet: str

        :param hide_private_subnet:
            The value to assign to the hide_private_subnet property of this SubnetVariableDependsOn.
        :type hide_private_subnet: str

        :param hide_regional_subnet:
            The value to assign to the hide_regional_subnet property of this SubnetVariableDependsOn.
        :type hide_regional_subnet: str

        :param hide_ad_subnet:
            The value to assign to the hide_ad_subnet property of this SubnetVariableDependsOn.
        :type hide_ad_subnet: str

        """
        self.swagger_types = {
            'vcn_id': 'str',
            'compartment_id': 'str',
            'hide_public_subnet': 'str',
            'hide_private_subnet': 'str',
            'hide_regional_subnet': 'str',
            'hide_ad_subnet': 'str'
        }
        self.attribute_map = {
            'vcn_id': 'vcnId',
            'compartment_id': 'compartmentId',
            'hide_public_subnet': 'hidePublicSubnet',
            'hide_private_subnet': 'hidePrivateSubnet',
            'hide_regional_subnet': 'hideRegionalSubnet',
            'hide_ad_subnet': 'hideAdSubnet'
        }
        self._vcn_id = None
        self._compartment_id = None
        self._hide_public_subnet = None
        self._hide_private_subnet = None
        self._hide_regional_subnet = None
        self._hide_ad_subnet = None

    @property
    def vcn_id(self):
        """
        **[Required]** Gets the vcn_id of this SubnetVariableDependsOn.
        OCID of the VCN.


        :return: The vcn_id of this SubnetVariableDependsOn.
        :rtype: str
        """
        return self._vcn_id

    @vcn_id.setter
    def vcn_id(self, vcn_id):
        """
        Sets the vcn_id of this SubnetVariableDependsOn.
        OCID of the VCN.


        :param vcn_id: The vcn_id of this SubnetVariableDependsOn.
        :type: str
        """
        self._vcn_id = vcn_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this SubnetVariableDependsOn.
        OCID of the compartment.


        :return: The compartment_id of this SubnetVariableDependsOn.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this SubnetVariableDependsOn.
        OCID of the compartment.


        :param compartment_id: The compartment_id of this SubnetVariableDependsOn.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def hide_public_subnet(self):
        """
        Gets the hide_public_subnet of this SubnetVariableDependsOn.
        If present, hides public subnets.


        :return: The hide_public_subnet of this SubnetVariableDependsOn.
        :rtype: str
        """
        return self._hide_public_subnet

    @hide_public_subnet.setter
    def hide_public_subnet(self, hide_public_subnet):
        """
        Sets the hide_public_subnet of this SubnetVariableDependsOn.
        If present, hides public subnets.


        :param hide_public_subnet: The hide_public_subnet of this SubnetVariableDependsOn.
        :type: str
        """
        self._hide_public_subnet = hide_public_subnet

    @property
    def hide_private_subnet(self):
        """
        Gets the hide_private_subnet of this SubnetVariableDependsOn.
        If present, hides private subnets.


        :return: The hide_private_subnet of this SubnetVariableDependsOn.
        :rtype: str
        """
        return self._hide_private_subnet

    @hide_private_subnet.setter
    def hide_private_subnet(self, hide_private_subnet):
        """
        Sets the hide_private_subnet of this SubnetVariableDependsOn.
        If present, hides private subnets.


        :param hide_private_subnet: The hide_private_subnet of this SubnetVariableDependsOn.
        :type: str
        """
        self._hide_private_subnet = hide_private_subnet

    @property
    def hide_regional_subnet(self):
        """
        Gets the hide_regional_subnet of this SubnetVariableDependsOn.
        If present, hides regional subnets.


        :return: The hide_regional_subnet of this SubnetVariableDependsOn.
        :rtype: str
        """
        return self._hide_regional_subnet

    @hide_regional_subnet.setter
    def hide_regional_subnet(self, hide_regional_subnet):
        """
        Sets the hide_regional_subnet of this SubnetVariableDependsOn.
        If present, hides regional subnets.


        :param hide_regional_subnet: The hide_regional_subnet of this SubnetVariableDependsOn.
        :type: str
        """
        self._hide_regional_subnet = hide_regional_subnet

    @property
    def hide_ad_subnet(self):
        """
        Gets the hide_ad_subnet of this SubnetVariableDependsOn.
        If present, hides AD subnet.


        :return: The hide_ad_subnet of this SubnetVariableDependsOn.
        :rtype: str
        """
        return self._hide_ad_subnet

    @hide_ad_subnet.setter
    def hide_ad_subnet(self, hide_ad_subnet):
        """
        Sets the hide_ad_subnet of this SubnetVariableDependsOn.
        If present, hides AD subnet.


        :param hide_ad_subnet: The hide_ad_subnet of this SubnetVariableDependsOn.
        :type: str
        """
        self._hide_ad_subnet = hide_ad_subnet

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
