# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComplianceReportProduct(object):
    """
    Details of the Product.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ComplianceReportProduct object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param product_name:
            The value to assign to the product_name property of this ComplianceReportProduct.
        :type product_name: str

        :param targets:
            The value to assign to the targets property of this ComplianceReportProduct.
        :type targets: list[oci.fleet_apps_management.models.ComplianceReportTarget]

        """
        self.swagger_types = {
            'product_name': 'str',
            'targets': 'list[ComplianceReportTarget]'
        }
        self.attribute_map = {
            'product_name': 'productName',
            'targets': 'targets'
        }
        self._product_name = None
        self._targets = None

    @property
    def product_name(self):
        """
        **[Required]** Gets the product_name of this ComplianceReportProduct.
        Product Name.


        :return: The product_name of this ComplianceReportProduct.
        :rtype: str
        """
        return self._product_name

    @product_name.setter
    def product_name(self, product_name):
        """
        Sets the product_name of this ComplianceReportProduct.
        Product Name.


        :param product_name: The product_name of this ComplianceReportProduct.
        :type: str
        """
        self._product_name = product_name

    @property
    def targets(self):
        """
        Gets the targets of this ComplianceReportProduct.
        Managed Targets associated with the Product.


        :return: The targets of this ComplianceReportProduct.
        :rtype: list[oci.fleet_apps_management.models.ComplianceReportTarget]
        """
        return self._targets

    @targets.setter
    def targets(self, targets):
        """
        Sets the targets of this ComplianceReportProduct.
        Managed Targets associated with the Product.


        :param targets: The targets of this ComplianceReportProduct.
        :type: list[oci.fleet_apps_management.models.ComplianceReportTarget]
        """
        self._targets = targets

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
