# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250830


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EndpointAdditional(object):
    """
    Details of provisioned endpoint.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new EndpointAdditional object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param endpoint_name:
            The value to assign to the endpoint_name property of this EndpointAdditional.
        :type endpoint_name: str

        :param endpoint_id:
            The value to assign to the endpoint_id property of this EndpointAdditional.
        :type endpoint_id: str

        """
        self.swagger_types = {
            'endpoint_name': 'str',
            'endpoint_id': 'str'
        }
        self.attribute_map = {
            'endpoint_name': 'endpointName',
            'endpoint_id': 'endpointId'
        }
        self._endpoint_name = None
        self._endpoint_id = None

    @property
    def endpoint_name(self):
        """
        Gets the endpoint_name of this EndpointAdditional.
        Identifier for each endpoint.


        :return: The endpoint_name of this EndpointAdditional.
        :rtype: str
        """
        return self._endpoint_name

    @endpoint_name.setter
    def endpoint_name(self, endpoint_name):
        """
        Sets the endpoint_name of this EndpointAdditional.
        Identifier for each endpoint.


        :param endpoint_name: The endpoint_name of this EndpointAdditional.
        :type: str
        """
        self._endpoint_name = endpoint_name

    @property
    def endpoint_id(self):
        """
        Gets the endpoint_id of this EndpointAdditional.
        OCID of the endpoint.


        :return: The endpoint_id of this EndpointAdditional.
        :rtype: str
        """
        return self._endpoint_id

    @endpoint_id.setter
    def endpoint_id(self, endpoint_id):
        """
        Sets the endpoint_id of this EndpointAdditional.
        OCID of the endpoint.


        :param endpoint_id: The endpoint_id of this EndpointAdditional.
        :type: str
        """
        self._endpoint_id = endpoint_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
