# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class EnableExternalDatabaseManagementDetails(object):
    """
    Detail to enable or disable database management.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new EnableExternalDatabaseManagementDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param connector_id:
            The value to assign to the connector_id property of this EnableExternalDatabaseManagementDetails.
        :type connector_id: str

        """
        self.swagger_types = {
            'connector_id': 'str'
        }
        self.attribute_map = {
            'connector_id': 'connectorId'
        }
        self._connector_id = None

    @property
    def connector_id(self):
        """
        **[Required]** Gets the connector_id of this EnableExternalDatabaseManagementDetails.
        OCID of External MySQL Database connector.


        :return: The connector_id of this EnableExternalDatabaseManagementDetails.
        :rtype: str
        """
        return self._connector_id

    @connector_id.setter
    def connector_id(self, connector_id):
        """
        Sets the connector_id of this EnableExternalDatabaseManagementDetails.
        OCID of External MySQL Database connector.


        :param connector_id: The connector_id of this EnableExternalDatabaseManagementDetails.
        :type: str
        """
        self._connector_id = connector_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
