# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateSecurityPolicyConfigDetails(object):
    """
    The details to update the security policy configuration.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateSecurityPolicyConfigDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateSecurityPolicyConfigDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateSecurityPolicyConfigDetails.
        :type description: str

        :param firewall_config:
            The value to assign to the firewall_config property of this UpdateSecurityPolicyConfigDetails.
        :type firewall_config: oci.data_safe.models.FirewallConfigDetails

        :param unified_audit_policy_config:
            The value to assign to the unified_audit_policy_config property of this UpdateSecurityPolicyConfigDetails.
        :type unified_audit_policy_config: oci.data_safe.models.UnifiedAuditPolicyConfigDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateSecurityPolicyConfigDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateSecurityPolicyConfigDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'firewall_config': 'FirewallConfigDetails',
            'unified_audit_policy_config': 'UnifiedAuditPolicyConfigDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'firewall_config': 'firewallConfig',
            'unified_audit_policy_config': 'unifiedAuditPolicyConfig',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._description = None
        self._firewall_config = None
        self._unified_audit_policy_config = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateSecurityPolicyConfigDetails.
        The display name of the security policy configuration. The name does not have to be unique, and it is changeable.


        :return: The display_name of this UpdateSecurityPolicyConfigDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateSecurityPolicyConfigDetails.
        The display name of the security policy configuration. The name does not have to be unique, and it is changeable.


        :param display_name: The display_name of this UpdateSecurityPolicyConfigDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdateSecurityPolicyConfigDetails.
        The description of the security policy configuration.


        :return: The description of this UpdateSecurityPolicyConfigDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateSecurityPolicyConfigDetails.
        The description of the security policy configuration.


        :param description: The description of this UpdateSecurityPolicyConfigDetails.
        :type: str
        """
        self._description = description

    @property
    def firewall_config(self):
        """
        Gets the firewall_config of this UpdateSecurityPolicyConfigDetails.

        :return: The firewall_config of this UpdateSecurityPolicyConfigDetails.
        :rtype: oci.data_safe.models.FirewallConfigDetails
        """
        return self._firewall_config

    @firewall_config.setter
    def firewall_config(self, firewall_config):
        """
        Sets the firewall_config of this UpdateSecurityPolicyConfigDetails.

        :param firewall_config: The firewall_config of this UpdateSecurityPolicyConfigDetails.
        :type: oci.data_safe.models.FirewallConfigDetails
        """
        self._firewall_config = firewall_config

    @property
    def unified_audit_policy_config(self):
        """
        Gets the unified_audit_policy_config of this UpdateSecurityPolicyConfigDetails.

        :return: The unified_audit_policy_config of this UpdateSecurityPolicyConfigDetails.
        :rtype: oci.data_safe.models.UnifiedAuditPolicyConfigDetails
        """
        return self._unified_audit_policy_config

    @unified_audit_policy_config.setter
    def unified_audit_policy_config(self, unified_audit_policy_config):
        """
        Sets the unified_audit_policy_config of this UpdateSecurityPolicyConfigDetails.

        :param unified_audit_policy_config: The unified_audit_policy_config of this UpdateSecurityPolicyConfigDetails.
        :type: oci.data_safe.models.UnifiedAuditPolicyConfigDetails
        """
        self._unified_audit_policy_config = unified_audit_policy_config

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateSecurityPolicyConfigDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateSecurityPolicyConfigDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateSecurityPolicyConfigDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateSecurityPolicyConfigDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateSecurityPolicyConfigDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateSecurityPolicyConfigDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateSecurityPolicyConfigDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateSecurityPolicyConfigDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
