# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UnifiedAuditPolicy(object):
    """
    Resource represents a single unified audit policy on the target database.
    """

    #: A constant which can be used with the lifecycle_state property of a UnifiedAuditPolicy.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a UnifiedAuditPolicy.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a UnifiedAuditPolicy.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a UnifiedAuditPolicy.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    #: A constant which can be used with the lifecycle_state property of a UnifiedAuditPolicy.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    #: A constant which can be used with the lifecycle_state property of a UnifiedAuditPolicy.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a UnifiedAuditPolicy.
    #: This constant has a value of "NEEDS_ATTENTION"
    LIFECYCLE_STATE_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the lifecycle_state property of a UnifiedAuditPolicy.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the status property of a UnifiedAuditPolicy.
    #: This constant has a value of "ENABLED"
    STATUS_ENABLED = "ENABLED"

    #: A constant which can be used with the status property of a UnifiedAuditPolicy.
    #: This constant has a value of "DISABLED"
    STATUS_DISABLED = "DISABLED"

    #: A constant which can be used with the enabled_entities property of a UnifiedAuditPolicy.
    #: This constant has a value of "ALL_USERS"
    ENABLED_ENTITIES_ALL_USERS = "ALL_USERS"

    #: A constant which can be used with the enabled_entities property of a UnifiedAuditPolicy.
    #: This constant has a value of "INCLUDE_USERS"
    ENABLED_ENTITIES_INCLUDE_USERS = "INCLUDE_USERS"

    #: A constant which can be used with the enabled_entities property of a UnifiedAuditPolicy.
    #: This constant has a value of "INCLUDE_ROLES"
    ENABLED_ENTITIES_INCLUDE_ROLES = "INCLUDE_ROLES"

    #: A constant which can be used with the enabled_entities property of a UnifiedAuditPolicy.
    #: This constant has a value of "EXCLUDE_USERS"
    ENABLED_ENTITIES_EXCLUDE_USERS = "EXCLUDE_USERS"

    #: A constant which can be used with the enabled_entities property of a UnifiedAuditPolicy.
    #: This constant has a value of "INCLUDE_USERS_ROLES"
    ENABLED_ENTITIES_INCLUDE_USERS_ROLES = "INCLUDE_USERS_ROLES"

    #: A constant which can be used with the enabled_entities property of a UnifiedAuditPolicy.
    #: This constant has a value of "DISABLED"
    ENABLED_ENTITIES_DISABLED = "DISABLED"

    def __init__(self, **kwargs):
        """
        Initializes a new UnifiedAuditPolicy object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this UnifiedAuditPolicy.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this UnifiedAuditPolicy.
        :type compartment_id: str

        :param display_name:
            The value to assign to the display_name property of this UnifiedAuditPolicy.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UnifiedAuditPolicy.
        :type description: str

        :param security_policy_id:
            The value to assign to the security_policy_id property of this UnifiedAuditPolicy.
        :type security_policy_id: str

        :param unified_audit_policy_definition_id:
            The value to assign to the unified_audit_policy_definition_id property of this UnifiedAuditPolicy.
        :type unified_audit_policy_definition_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this UnifiedAuditPolicy.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "INACTIVE", "FAILED", "DELETING", "NEEDS_ATTENTION", "DELETED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this UnifiedAuditPolicy.
        :type lifecycle_details: str

        :param is_seeded:
            The value to assign to the is_seeded property of this UnifiedAuditPolicy.
        :type is_seeded: bool

        :param status:
            The value to assign to the status property of this UnifiedAuditPolicy.
            Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param enabled_entities:
            The value to assign to the enabled_entities property of this UnifiedAuditPolicy.
            Allowed values for this property are: "ALL_USERS", "INCLUDE_USERS", "INCLUDE_ROLES", "EXCLUDE_USERS", "INCLUDE_USERS_ROLES", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type enabled_entities: str

        :param conditions:
            The value to assign to the conditions property of this UnifiedAuditPolicy.
        :type conditions: list[oci.data_safe.models.PolicyCondition]

        :param time_created:
            The value to assign to the time_created property of this UnifiedAuditPolicy.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this UnifiedAuditPolicy.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UnifiedAuditPolicy.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UnifiedAuditPolicy.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this UnifiedAuditPolicy.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'display_name': 'str',
            'description': 'str',
            'security_policy_id': 'str',
            'unified_audit_policy_definition_id': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'is_seeded': 'bool',
            'status': 'str',
            'enabled_entities': 'str',
            'conditions': 'list[PolicyCondition]',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'display_name': 'displayName',
            'description': 'description',
            'security_policy_id': 'securityPolicyId',
            'unified_audit_policy_definition_id': 'unifiedAuditPolicyDefinitionId',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'is_seeded': 'isSeeded',
            'status': 'status',
            'enabled_entities': 'enabledEntities',
            'conditions': 'conditions',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._display_name = None
        self._description = None
        self._security_policy_id = None
        self._unified_audit_policy_definition_id = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._is_seeded = None
        self._status = None
        self._enabled_entities = None
        self._conditions = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this UnifiedAuditPolicy.
        The OCID of the unified audit policy.


        :return: The id of this UnifiedAuditPolicy.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this UnifiedAuditPolicy.
        The OCID of the unified audit policy.


        :param id: The id of this UnifiedAuditPolicy.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this UnifiedAuditPolicy.
        The OCID of the compartment containing the unified audit policy.


        :return: The compartment_id of this UnifiedAuditPolicy.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this UnifiedAuditPolicy.
        The OCID of the compartment containing the unified audit policy.


        :param compartment_id: The compartment_id of this UnifiedAuditPolicy.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this UnifiedAuditPolicy.
        The display name of the unified audit policy.


        :return: The display_name of this UnifiedAuditPolicy.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UnifiedAuditPolicy.
        The display name of the unified audit policy.


        :param display_name: The display_name of this UnifiedAuditPolicy.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UnifiedAuditPolicy.
        The description of the unified audit policy.


        :return: The description of this UnifiedAuditPolicy.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UnifiedAuditPolicy.
        The description of the unified audit policy.


        :param description: The description of this UnifiedAuditPolicy.
        :type: str
        """
        self._description = description

    @property
    def security_policy_id(self):
        """
        Gets the security_policy_id of this UnifiedAuditPolicy.
        The OCID of the security policy corresponding to the unified audit policy.


        :return: The security_policy_id of this UnifiedAuditPolicy.
        :rtype: str
        """
        return self._security_policy_id

    @security_policy_id.setter
    def security_policy_id(self, security_policy_id):
        """
        Sets the security_policy_id of this UnifiedAuditPolicy.
        The OCID of the security policy corresponding to the unified audit policy.


        :param security_policy_id: The security_policy_id of this UnifiedAuditPolicy.
        :type: str
        """
        self._security_policy_id = security_policy_id

    @property
    def unified_audit_policy_definition_id(self):
        """
        Gets the unified_audit_policy_definition_id of this UnifiedAuditPolicy.
        The OCID of the associated unified audit policy definition.


        :return: The unified_audit_policy_definition_id of this UnifiedAuditPolicy.
        :rtype: str
        """
        return self._unified_audit_policy_definition_id

    @unified_audit_policy_definition_id.setter
    def unified_audit_policy_definition_id(self, unified_audit_policy_definition_id):
        """
        Sets the unified_audit_policy_definition_id of this UnifiedAuditPolicy.
        The OCID of the associated unified audit policy definition.


        :param unified_audit_policy_definition_id: The unified_audit_policy_definition_id of this UnifiedAuditPolicy.
        :type: str
        """
        self._unified_audit_policy_definition_id = unified_audit_policy_definition_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this UnifiedAuditPolicy.
        The current state of the unified audit policy.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "INACTIVE", "FAILED", "DELETING", "NEEDS_ATTENTION", "DELETED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this UnifiedAuditPolicy.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this UnifiedAuditPolicy.
        The current state of the unified audit policy.


        :param lifecycle_state: The lifecycle_state of this UnifiedAuditPolicy.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "INACTIVE", "FAILED", "DELETING", "NEEDS_ATTENTION", "DELETED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this UnifiedAuditPolicy.
        The details of the current state of the unified audit policy in Data Safe.


        :return: The lifecycle_details of this UnifiedAuditPolicy.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this UnifiedAuditPolicy.
        The details of the current state of the unified audit policy in Data Safe.


        :param lifecycle_details: The lifecycle_details of this UnifiedAuditPolicy.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def is_seeded(self):
        """
        Gets the is_seeded of this UnifiedAuditPolicy.
        Indicates whether the unified audit policy is seeded or not.


        :return: The is_seeded of this UnifiedAuditPolicy.
        :rtype: bool
        """
        return self._is_seeded

    @is_seeded.setter
    def is_seeded(self, is_seeded):
        """
        Sets the is_seeded of this UnifiedAuditPolicy.
        Indicates whether the unified audit policy is seeded or not.


        :param is_seeded: The is_seeded of this UnifiedAuditPolicy.
        :type: bool
        """
        self._is_seeded = is_seeded

    @property
    def status(self):
        """
        Gets the status of this UnifiedAuditPolicy.
        Indicates whether the policy has been enabled or disabled.

        Allowed values for this property are: "ENABLED", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this UnifiedAuditPolicy.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this UnifiedAuditPolicy.
        Indicates whether the policy has been enabled or disabled.


        :param status: The status of this UnifiedAuditPolicy.
        :type: str
        """
        allowed_values = ["ENABLED", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def enabled_entities(self):
        """
        Gets the enabled_entities of this UnifiedAuditPolicy.
        Indicates on whom the audit policy is enabled.

        Allowed values for this property are: "ALL_USERS", "INCLUDE_USERS", "INCLUDE_ROLES", "EXCLUDE_USERS", "INCLUDE_USERS_ROLES", "DISABLED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The enabled_entities of this UnifiedAuditPolicy.
        :rtype: str
        """
        return self._enabled_entities

    @enabled_entities.setter
    def enabled_entities(self, enabled_entities):
        """
        Sets the enabled_entities of this UnifiedAuditPolicy.
        Indicates on whom the audit policy is enabled.


        :param enabled_entities: The enabled_entities of this UnifiedAuditPolicy.
        :type: str
        """
        allowed_values = ["ALL_USERS", "INCLUDE_USERS", "INCLUDE_ROLES", "EXCLUDE_USERS", "INCLUDE_USERS_ROLES", "DISABLED"]
        if not value_allowed_none_or_none_sentinel(enabled_entities, allowed_values):
            enabled_entities = 'UNKNOWN_ENUM_VALUE'
        self._enabled_entities = enabled_entities

    @property
    def conditions(self):
        """
        Gets the conditions of this UnifiedAuditPolicy.
        Lists the audit policy provisioning conditions.


        :return: The conditions of this UnifiedAuditPolicy.
        :rtype: list[oci.data_safe.models.PolicyCondition]
        """
        return self._conditions

    @conditions.setter
    def conditions(self, conditions):
        """
        Sets the conditions of this UnifiedAuditPolicy.
        Lists the audit policy provisioning conditions.


        :param conditions: The conditions of this UnifiedAuditPolicy.
        :type: list[oci.data_safe.models.PolicyCondition]
        """
        self._conditions = conditions

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this UnifiedAuditPolicy.
        The time the the unified audit policy was created, in the format defined by RFC3339.


        :return: The time_created of this UnifiedAuditPolicy.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this UnifiedAuditPolicy.
        The time the the unified audit policy was created, in the format defined by RFC3339.


        :param time_created: The time_created of this UnifiedAuditPolicy.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this UnifiedAuditPolicy.
        The last date and time the unified audit policy was updated, in the format defined by RFC3339.


        :return: The time_updated of this UnifiedAuditPolicy.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this UnifiedAuditPolicy.
        The last date and time the unified audit policy was updated, in the format defined by RFC3339.


        :param time_updated: The time_updated of this UnifiedAuditPolicy.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UnifiedAuditPolicy.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UnifiedAuditPolicy.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UnifiedAuditPolicy.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see `Resource Tags`__

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UnifiedAuditPolicy.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UnifiedAuditPolicy.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UnifiedAuditPolicy.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UnifiedAuditPolicy.
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see `Resource Tags`__
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UnifiedAuditPolicy.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this UnifiedAuditPolicy.
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this UnifiedAuditPolicy.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this UnifiedAuditPolicy.
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see Resource Tags.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this UnifiedAuditPolicy.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
