# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220509


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MonthlyCostSummary(object):
    """
    Cost information for monthly maintenance.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MonthlyCostSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param amount:
            The value to assign to the amount property of this MonthlyCostSummary.
        :type amount: float

        :param currency_code:
            The value to assign to the currency_code property of this MonthlyCostSummary.
        :type currency_code: str

        """
        self.swagger_types = {
            'amount': 'float',
            'currency_code': 'str'
        }
        self.attribute_map = {
            'amount': 'amount',
            'currency_code': 'currencyCode'
        }
        self._amount = None
        self._currency_code = None

    @property
    def amount(self):
        """
        **[Required]** Gets the amount of this MonthlyCostSummary.
        Monthly costs for maintenance of this asset.


        :return: The amount of this MonthlyCostSummary.
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount):
        """
        Sets the amount of this MonthlyCostSummary.
        Monthly costs for maintenance of this asset.


        :param amount: The amount of this MonthlyCostSummary.
        :type: float
        """
        self._amount = amount

    @property
    def currency_code(self):
        """
        **[Required]** Gets the currency_code of this MonthlyCostSummary.
        Currency code


        :return: The currency_code of this MonthlyCostSummary.
        :rtype: str
        """
        return self._currency_code

    @currency_code.setter
    def currency_code(self, currency_code):
        """
        Sets the currency_code of this MonthlyCostSummary.
        Currency code


        :param currency_code: The currency_code of this MonthlyCostSummary.
        :type: str
        """
        self._currency_code = currency_code

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
