# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateInternalOccmDemandSignalDeliveryDetails(object):
    """
    Details about different fields used to update the demand signal delivery resource.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateInternalOccmDemandSignalDeliveryDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param accepted_quantity:
            The value to assign to the accepted_quantity property of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :type accepted_quantity: int

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :type lifecycle_details: str

        :param time_delivered:
            The value to assign to the time_delivered property of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :type time_delivered: datetime

        :param justification:
            The value to assign to the justification property of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :type justification: str

        :param notes:
            The value to assign to the notes property of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :type notes: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'accepted_quantity': 'int',
            'lifecycle_details': 'str',
            'time_delivered': 'datetime',
            'justification': 'str',
            'notes': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'accepted_quantity': 'acceptedQuantity',
            'lifecycle_details': 'lifecycleDetails',
            'time_delivered': 'timeDelivered',
            'justification': 'justification',
            'notes': 'notes',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._accepted_quantity = None
        self._lifecycle_details = None
        self._time_delivered = None
        self._justification = None
        self._notes = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def accepted_quantity(self):
        """
        Gets the accepted_quantity of this UpdateInternalOccmDemandSignalDeliveryDetails.
        The quantity of the resource that OCI will supply to the customer.


        :return: The accepted_quantity of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :rtype: int
        """
        return self._accepted_quantity

    @accepted_quantity.setter
    def accepted_quantity(self, accepted_quantity):
        """
        Sets the accepted_quantity of this UpdateInternalOccmDemandSignalDeliveryDetails.
        The quantity of the resource that OCI will supply to the customer.


        :param accepted_quantity: The accepted_quantity of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :type: int
        """
        self._accepted_quantity = accepted_quantity

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this UpdateInternalOccmDemandSignalDeliveryDetails.
        The state in which we want to transition the demand signal delivery resource.


        :return: The lifecycle_details of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this UpdateInternalOccmDemandSignalDeliveryDetails.
        The state in which we want to transition the demand signal delivery resource.


        :param lifecycle_details: The lifecycle_details of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def time_delivered(self):
        """
        Gets the time_delivered of this UpdateInternalOccmDemandSignalDeliveryDetails.
        The date on which the OCI delivered the resource to the customers.


        :return: The time_delivered of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :rtype: datetime
        """
        return self._time_delivered

    @time_delivered.setter
    def time_delivered(self, time_delivered):
        """
        Sets the time_delivered of this UpdateInternalOccmDemandSignalDeliveryDetails.
        The date on which the OCI delivered the resource to the customers.


        :param time_delivered: The time_delivered of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :type: datetime
        """
        self._time_delivered = time_delivered

    @property
    def justification(self):
        """
        Gets the justification of this UpdateInternalOccmDemandSignalDeliveryDetails.
        This field could be used by OCI to communicate the reason for declining the request.


        :return: The justification of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :rtype: str
        """
        return self._justification

    @justification.setter
    def justification(self, justification):
        """
        Sets the justification of this UpdateInternalOccmDemandSignalDeliveryDetails.
        This field could be used by OCI to communicate the reason for declining the request.


        :param justification: The justification of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :type: str
        """
        self._justification = justification

    @property
    def notes(self):
        """
        Gets the notes of this UpdateInternalOccmDemandSignalDeliveryDetails.
        This field acts as a notes section for operators.


        :return: The notes of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """
        Sets the notes of this UpdateInternalOccmDemandSignalDeliveryDetails.
        This field acts as a notes section for operators.


        :param notes: The notes of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :type: str
        """
        self._notes = notes

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateInternalOccmDemandSignalDeliveryDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateInternalOccmDemandSignalDeliveryDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateInternalOccmDemandSignalDeliveryDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateInternalOccmDemandSignalDeliveryDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateInternalOccmDemandSignalDeliveryDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
