# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220125


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VideoStreamObject(object):
    """
    Tracked object in a video stream.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VideoStreamObject object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this VideoStreamObject.
        :type name: str

        :param object_id:
            The value to assign to the object_id property of this VideoStreamObject.
        :type object_id: int

        :param confidence:
            The value to assign to the confidence property of this VideoStreamObject.
        :type confidence: float

        :param bounding_polygon:
            The value to assign to the bounding_polygon property of this VideoStreamObject.
        :type bounding_polygon: oci.ai_vision.models.BoundingPolygon

        :param properties:
            The value to assign to the properties property of this VideoStreamObject.
        :type properties: oci.ai_vision.models.ObjectProperties

        """
        self.swagger_types = {
            'name': 'str',
            'object_id': 'int',
            'confidence': 'float',
            'bounding_polygon': 'BoundingPolygon',
            'properties': 'ObjectProperties'
        }
        self.attribute_map = {
            'name': 'name',
            'object_id': 'objectId',
            'confidence': 'confidence',
            'bounding_polygon': 'boundingPolygon',
            'properties': 'properties'
        }
        self._name = None
        self._object_id = None
        self._confidence = None
        self._bounding_polygon = None
        self._properties = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this VideoStreamObject.
        Name of the object category label.


        :return: The name of this VideoStreamObject.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this VideoStreamObject.
        Name of the object category label.


        :param name: The name of this VideoStreamObject.
        :type: str
        """
        self._name = name

    @property
    def object_id(self):
        """
        Gets the object_id of this VideoStreamObject.
        Unique identifier for the object.


        :return: The object_id of this VideoStreamObject.
        :rtype: int
        """
        return self._object_id

    @object_id.setter
    def object_id(self, object_id):
        """
        Sets the object_id of this VideoStreamObject.
        Unique identifier for the object.


        :param object_id: The object_id of this VideoStreamObject.
        :type: int
        """
        self._object_id = object_id

    @property
    def confidence(self):
        """
        **[Required]** Gets the confidence of this VideoStreamObject.
        The confidence score, between 0 and 1.


        :return: The confidence of this VideoStreamObject.
        :rtype: float
        """
        return self._confidence

    @confidence.setter
    def confidence(self, confidence):
        """
        Sets the confidence of this VideoStreamObject.
        The confidence score, between 0 and 1.


        :param confidence: The confidence of this VideoStreamObject.
        :type: float
        """
        self._confidence = confidence

    @property
    def bounding_polygon(self):
        """
        **[Required]** Gets the bounding_polygon of this VideoStreamObject.

        :return: The bounding_polygon of this VideoStreamObject.
        :rtype: oci.ai_vision.models.BoundingPolygon
        """
        return self._bounding_polygon

    @bounding_polygon.setter
    def bounding_polygon(self, bounding_polygon):
        """
        Sets the bounding_polygon of this VideoStreamObject.

        :param bounding_polygon: The bounding_polygon of this VideoStreamObject.
        :type: oci.ai_vision.models.BoundingPolygon
        """
        self._bounding_polygon = bounding_polygon

    @property
    def properties(self):
        """
        Gets the properties of this VideoStreamObject.

        :return: The properties of this VideoStreamObject.
        :rtype: oci.ai_vision.models.ObjectProperties
        """
        return self._properties

    @properties.setter
    def properties(self, properties):
        """
        Sets the properties of this VideoStreamObject.

        :param properties: The properties of this VideoStreamObject.
        :type: oci.ai_vision.models.ObjectProperties
        """
        self._properties = properties

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
