# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateMappedSecretDetails(object):
    """
    The Request for creating the Mapped Secret
    """

    #: A constant which can be used with the type property of a CreateMappedSecretDetails.
    #: This constant has a value of "SSL_INBOUND_INSPECTION"
    TYPE_SSL_INBOUND_INSPECTION = "SSL_INBOUND_INSPECTION"

    #: A constant which can be used with the type property of a CreateMappedSecretDetails.
    #: This constant has a value of "SSL_FORWARD_PROXY"
    TYPE_SSL_FORWARD_PROXY = "SSL_FORWARD_PROXY"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateMappedSecretDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.network_firewall.models.CreateVaultMappedSecretDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CreateMappedSecretDetails.
        :type name: str

        :param source:
            The value to assign to the source property of this CreateMappedSecretDetails.
        :type source: str

        :param type:
            The value to assign to the type property of this CreateMappedSecretDetails.
            Allowed values for this property are: "SSL_INBOUND_INSPECTION", "SSL_FORWARD_PROXY"
        :type type: str

        """
        self.swagger_types = {
            'name': 'str',
            'source': 'str',
            'type': 'str'
        }
        self.attribute_map = {
            'name': 'name',
            'source': 'source',
            'type': 'type'
        }
        self._name = None
        self._source = None
        self._type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['source']

        if type == 'OCI_VAULT':
            return 'CreateVaultMappedSecretDetails'
        else:
            return 'CreateMappedSecretDetails'

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CreateMappedSecretDetails.
        Unique name to identify the group of urls to be used in the policy rules.


        :return: The name of this CreateMappedSecretDetails.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CreateMappedSecretDetails.
        Unique name to identify the group of urls to be used in the policy rules.


        :param name: The name of this CreateMappedSecretDetails.
        :type: str
        """
        self._name = name

    @property
    def source(self):
        """
        **[Required]** Gets the source of this CreateMappedSecretDetails.
        Source of the secrets, where the secrets are stored.


        :return: The source of this CreateMappedSecretDetails.
        :rtype: str
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this CreateMappedSecretDetails.
        Source of the secrets, where the secrets are stored.


        :param source: The source of this CreateMappedSecretDetails.
        :type: str
        """
        self._source = source

    @property
    def type(self):
        """
        **[Required]** Gets the type of this CreateMappedSecretDetails.
        Type of the secrets mapped based on the policy.

        * `SSL_INBOUND_INSPECTION`: For Inbound inspection of SSL traffic.
        * `SSL_FORWARD_PROXY`: For forward proxy certificates for SSL inspection.

        Allowed values for this property are: "SSL_INBOUND_INSPECTION", "SSL_FORWARD_PROXY"


        :return: The type of this CreateMappedSecretDetails.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this CreateMappedSecretDetails.
        Type of the secrets mapped based on the policy.

        * `SSL_INBOUND_INSPECTION`: For Inbound inspection of SSL traffic.
        * `SSL_FORWARD_PROXY`: For forward proxy certificates for SSL inspection.


        :param type: The type of this CreateMappedSecretDetails.
        :type: str
        """
        allowed_values = ["SSL_INBOUND_INSPECTION", "SSL_FORWARD_PROXY"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            raise ValueError(
                f"Invalid value for `type`, must be None or one of {allowed_values}"
            )
        self._type = type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
