# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20180401


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SuppressionCondition(object):
    """
    Precondition for an alarm suppression within the suppression date and time range (`timeSuppressFrom` to `timeSuppressUntil`).
    """

    #: A constant which can be used with the condition_type property of a SuppressionCondition.
    #: This constant has a value of "RECURRENCE"
    CONDITION_TYPE_RECURRENCE = "RECURRENCE"

    def __init__(self, **kwargs):
        """
        Initializes a new SuppressionCondition object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.monitoring.models.Recurrence`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param condition_type:
            The value to assign to the condition_type property of this SuppressionCondition.
            Allowed values for this property are: "RECURRENCE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type condition_type: str

        """
        self.swagger_types = {
            'condition_type': 'str'
        }
        self.attribute_map = {
            'condition_type': 'conditionType'
        }
        self._condition_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['conditionType']

        if type == 'RECURRENCE':
            return 'Recurrence'
        else:
            return 'SuppressionCondition'

    @property
    def condition_type(self):
        """
        **[Required]** Gets the condition_type of this SuppressionCondition.
        Type of suppression condition.

        Allowed values for this property are: "RECURRENCE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The condition_type of this SuppressionCondition.
        :rtype: str
        """
        return self._condition_type

    @condition_type.setter
    def condition_type(self, condition_type):
        """
        Sets the condition_type of this SuppressionCondition.
        Type of suppression condition.


        :param condition_type: The condition_type of this SuppressionCondition.
        :type: str
        """
        allowed_values = ["RECURRENCE"]
        if not value_allowed_none_or_none_sentinel(condition_type, allowed_values):
            condition_type = 'UNKNOWN_ENUM_VALUE'
        self._condition_type = condition_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
