# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SubnetSet(object):
    """
    Summary information about a KafkaCluster.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new SubnetSet object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param subnets:
            The value to assign to the subnets property of this SubnetSet.
        :type subnets: list[str]

        """
        self.swagger_types = {
            'subnets': 'list[str]'
        }
        self.attribute_map = {
            'subnets': 'subnets'
        }
        self._subnets = None

    @property
    def subnets(self):
        """
        **[Required]** Gets the subnets of this SubnetSet.
        Subnets OCIDs


        :return: The subnets of this SubnetSet.
        :rtype: list[str]
        """
        return self._subnets

    @subnets.setter
    def subnets(self, subnets):
        """
        Sets the subnets of this SubnetSet.
        Subnets OCIDs


        :param subnets: The subnets of this SubnetSet.
        :type: list[str]
        """
        self._subnets = subnets

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
