# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class SyncJobSummary(object):
    """
    Summary information associated with sync jobs.
    """

    #: A constant which can be used with the job_type property of a SyncJobSummary.
    #: This constant has a value of "IMPORT"
    JOB_TYPE_IMPORT = "IMPORT"

    #: A constant which can be used with the job_type property of a SyncJobSummary.
    #: This constant has a value of "EXPORT"
    JOB_TYPE_EXPORT = "EXPORT"

    def __init__(self, **kwargs):
        """
        Initializes a new SyncJobSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this SyncJobSummary.
        :type id: str

        :param job_type:
            The value to assign to the job_type property of this SyncJobSummary.
            Allowed values for this property are: "IMPORT", "EXPORT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type job_type: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this SyncJobSummary.
        :type lifecycle_state: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this SyncJobSummary.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this SyncJobSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this SyncJobSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this SyncJobSummary.
        :type system_tags: dict(str, dict(str, object))

        :param is_overwrite:
            The value to assign to the is_overwrite property of this SyncJobSummary.
        :type is_overwrite: bool

        :param total_objects_scanned:
            The value to assign to the total_objects_scanned property of this SyncJobSummary.
        :type total_objects_scanned: int

        :param objects_transferred:
            The value to assign to the objects_transferred property of this SyncJobSummary.
        :type objects_transferred: int

        :param bytes_transferred:
            The value to assign to the bytes_transferred property of this SyncJobSummary.
        :type bytes_transferred: int

        :param skipped_error_count:
            The value to assign to the skipped_error_count property of this SyncJobSummary.
        :type skipped_error_count: int

        :param time_started:
            The value to assign to the time_started property of this SyncJobSummary.
        :type time_started: datetime

        :param time_finished:
            The value to assign to the time_finished property of this SyncJobSummary.
        :type time_finished: datetime

        :param lustre_file_system_path:
            The value to assign to the lustre_file_system_path property of this SyncJobSummary.
        :type lustre_file_system_path: str

        :param object_storage_path:
            The value to assign to the object_storage_path property of this SyncJobSummary.
        :type object_storage_path: str

        """
        self.swagger_types = {
            'id': 'str',
            'job_type': 'str',
            'lifecycle_state': 'str',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'is_overwrite': 'bool',
            'total_objects_scanned': 'int',
            'objects_transferred': 'int',
            'bytes_transferred': 'int',
            'skipped_error_count': 'int',
            'time_started': 'datetime',
            'time_finished': 'datetime',
            'lustre_file_system_path': 'str',
            'object_storage_path': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'job_type': 'jobType',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'is_overwrite': 'isOverwrite',
            'total_objects_scanned': 'totalObjectsScanned',
            'objects_transferred': 'objectsTransferred',
            'bytes_transferred': 'bytesTransferred',
            'skipped_error_count': 'skippedErrorCount',
            'time_started': 'timeStarted',
            'time_finished': 'timeFinished',
            'lustre_file_system_path': 'lustreFileSystemPath',
            'object_storage_path': 'objectStoragePath'
        }
        self._id = None
        self._job_type = None
        self._lifecycle_state = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._is_overwrite = None
        self._total_objects_scanned = None
        self._objects_transferred = None
        self._bytes_transferred = None
        self._skipped_error_count = None
        self._time_started = None
        self._time_finished = None
        self._lustre_file_system_path = None
        self._object_storage_path = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this SyncJobSummary.
        The `OCID`__ of the sync job.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this SyncJobSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this SyncJobSummary.
        The `OCID`__ of the sync job.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this SyncJobSummary.
        :type: str
        """
        self._id = id

    @property
    def job_type(self):
        """
        **[Required]** Gets the job_type of this SyncJobSummary.
        The type of the sync job.

        Allowed values for this property are: "IMPORT", "EXPORT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The job_type of this SyncJobSummary.
        :rtype: str
        """
        return self._job_type

    @job_type.setter
    def job_type(self, job_type):
        """
        Sets the job_type of this SyncJobSummary.
        The type of the sync job.


        :param job_type: The job_type of this SyncJobSummary.
        :type: str
        """
        allowed_values = ["IMPORT", "EXPORT"]
        if not value_allowed_none_or_none_sentinel(job_type, allowed_values):
            job_type = 'UNKNOWN_ENUM_VALUE'
        self._job_type = job_type

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this SyncJobSummary.
        The current state of the sync job.


        :return: The lifecycle_state of this SyncJobSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this SyncJobSummary.
        The current state of the sync job.


        :param lifecycle_state: The lifecycle_state of this SyncJobSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this SyncJobSummary.
        A message that describes the current state of the sync job in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :return: The lifecycle_details of this SyncJobSummary.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this SyncJobSummary.
        A message that describes the current state of the sync job in more detail. For example,
        can be used to provide actionable information for a resource in the Failed state.


        :param lifecycle_details: The lifecycle_details of this SyncJobSummary.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this SyncJobSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this SyncJobSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this SyncJobSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this SyncJobSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this SyncJobSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this SyncJobSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this SyncJobSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this SyncJobSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        **[Required]** Gets the system_tags of this SyncJobSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this SyncJobSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this SyncJobSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this SyncJobSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def is_overwrite(self):
        """
        **[Required]** Gets the is_overwrite of this SyncJobSummary.
        The flag is an identifier to tell whether this specific job run has overwrite enabled.
        If `isOverwrite` is false, the file to be imported or exported will be skipped if it already exists.
        If `isOverwrite` is true, the file to be imported or exported will be overwritten if it already exists.


        :return: The is_overwrite of this SyncJobSummary.
        :rtype: bool
        """
        return self._is_overwrite

    @is_overwrite.setter
    def is_overwrite(self, is_overwrite):
        """
        Sets the is_overwrite of this SyncJobSummary.
        The flag is an identifier to tell whether this specific job run has overwrite enabled.
        If `isOverwrite` is false, the file to be imported or exported will be skipped if it already exists.
        If `isOverwrite` is true, the file to be imported or exported will be overwritten if it already exists.


        :param is_overwrite: The is_overwrite of this SyncJobSummary.
        :type: bool
        """
        self._is_overwrite = is_overwrite

    @property
    def total_objects_scanned(self):
        """
        **[Required]** Gets the total_objects_scanned of this SyncJobSummary.
        Total object count for scanned files for import or export as part of this sync job.


        :return: The total_objects_scanned of this SyncJobSummary.
        :rtype: int
        """
        return self._total_objects_scanned

    @total_objects_scanned.setter
    def total_objects_scanned(self, total_objects_scanned):
        """
        Sets the total_objects_scanned of this SyncJobSummary.
        Total object count for scanned files for import or export as part of this sync job.


        :param total_objects_scanned: The total_objects_scanned of this SyncJobSummary.
        :type: int
        """
        self._total_objects_scanned = total_objects_scanned

    @property
    def objects_transferred(self):
        """
        **[Required]** Gets the objects_transferred of this SyncJobSummary.
        Count of total files transferred successfully.


        :return: The objects_transferred of this SyncJobSummary.
        :rtype: int
        """
        return self._objects_transferred

    @objects_transferred.setter
    def objects_transferred(self, objects_transferred):
        """
        Sets the objects_transferred of this SyncJobSummary.
        Count of total files transferred successfully.


        :param objects_transferred: The objects_transferred of this SyncJobSummary.
        :type: int
        """
        self._objects_transferred = objects_transferred

    @property
    def bytes_transferred(self):
        """
        **[Required]** Gets the bytes_transferred of this SyncJobSummary.
        Bytes transferred during the sync. This value changes while sync is still in progress.


        :return: The bytes_transferred of this SyncJobSummary.
        :rtype: int
        """
        return self._bytes_transferred

    @bytes_transferred.setter
    def bytes_transferred(self, bytes_transferred):
        """
        Sets the bytes_transferred of this SyncJobSummary.
        Bytes transferred during the sync. This value changes while sync is still in progress.


        :param bytes_transferred: The bytes_transferred of this SyncJobSummary.
        :type: int
        """
        self._bytes_transferred = bytes_transferred

    @property
    def skipped_error_count(self):
        """
        **[Required]** Gets the skipped_error_count of this SyncJobSummary.
        Count of files or objects that failed to export or import due to errors.


        :return: The skipped_error_count of this SyncJobSummary.
        :rtype: int
        """
        return self._skipped_error_count

    @skipped_error_count.setter
    def skipped_error_count(self, skipped_error_count):
        """
        Sets the skipped_error_count of this SyncJobSummary.
        Count of files or objects that failed to export or import due to errors.


        :param skipped_error_count: The skipped_error_count of this SyncJobSummary.
        :type: int
        """
        self._skipped_error_count = skipped_error_count

    @property
    def time_started(self):
        """
        **[Required]** Gets the time_started of this SyncJobSummary.
        The date and time the job was started, expressed in
        `RFC 3339`__ timestamp format.

        Example: `2020-07-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_started of this SyncJobSummary.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this SyncJobSummary.
        The date and time the job was started, expressed in
        `RFC 3339`__ timestamp format.

        Example: `2020-07-25T21:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_started: The time_started of this SyncJobSummary.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_finished(self):
        """
        Gets the time_finished of this SyncJobSummary.
        The date and time the job finished, expressed in
        `RFC 3339`__ timestamp format.

        Example: `2024-07-21T20:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_finished of this SyncJobSummary.
        :rtype: datetime
        """
        return self._time_finished

    @time_finished.setter
    def time_finished(self, time_finished):
        """
        Sets the time_finished of this SyncJobSummary.
        The date and time the job finished, expressed in
        `RFC 3339`__ timestamp format.

        Example: `2024-07-21T20:10:29.600Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_finished: The time_finished of this SyncJobSummary.
        :type: datetime
        """
        self._time_finished = time_finished

    @property
    def lustre_file_system_path(self):
        """
        **[Required]** Gets the lustre_file_system_path of this SyncJobSummary.
        The path in the Lustre file system used for this Object Storage link.

        Example: `myFileSystem/mount/myDirectory`


        :return: The lustre_file_system_path of this SyncJobSummary.
        :rtype: str
        """
        return self._lustre_file_system_path

    @lustre_file_system_path.setter
    def lustre_file_system_path(self, lustre_file_system_path):
        """
        Sets the lustre_file_system_path of this SyncJobSummary.
        The path in the Lustre file system used for this Object Storage link.

        Example: `myFileSystem/mount/myDirectory`


        :param lustre_file_system_path: The lustre_file_system_path of this SyncJobSummary.
        :type: str
        """
        self._lustre_file_system_path = lustre_file_system_path

    @property
    def object_storage_path(self):
        """
        **[Required]** Gets the object_storage_path of this SyncJobSummary.
        The Object Storage namespace and bucket name, including optional object prefix string, to use as the source for imports or destination for exports.

        Example: `objectStorageNamespace:/bucketName/optionalFolder/optionalPrefix`


        :return: The object_storage_path of this SyncJobSummary.
        :rtype: str
        """
        return self._object_storage_path

    @object_storage_path.setter
    def object_storage_path(self, object_storage_path):
        """
        Sets the object_storage_path of this SyncJobSummary.
        The Object Storage namespace and bucket name, including optional object prefix string, to use as the source for imports or destination for exports.

        Example: `objectStorageNamespace:/bucketName/optionalFolder/optionalPrefix`


        :param object_storage_path: The object_storage_path of this SyncJobSummary.
        :type: str
        """
        self._object_storage_path = object_storage_path

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
