# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ValidateLabelConditionResult(object):
    """
    The result of the label condition validation
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ValidateLabelConditionResult object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param condition_string:
            The value to assign to the condition_string property of this ValidateLabelConditionResult.
        :type condition_string: str

        :param condition_block:
            The value to assign to the condition_block property of this ValidateLabelConditionResult.
        :type condition_block: oci.log_analytics.models.ConditionBlock

        :param field_values:
            The value to assign to the field_values property of this ValidateLabelConditionResult.
        :type field_values: list[oci.log_analytics.models.LogAnalyticsProperty]

        :param status:
            The value to assign to the status property of this ValidateLabelConditionResult.
        :type status: str

        :param status_description:
            The value to assign to the status_description property of this ValidateLabelConditionResult.
        :type status_description: str

        :param evaluation_result:
            The value to assign to the evaluation_result property of this ValidateLabelConditionResult.
        :type evaluation_result: bool

        """
        self.swagger_types = {
            'condition_string': 'str',
            'condition_block': 'ConditionBlock',
            'field_values': 'list[LogAnalyticsProperty]',
            'status': 'str',
            'status_description': 'str',
            'evaluation_result': 'bool'
        }
        self.attribute_map = {
            'condition_string': 'conditionString',
            'condition_block': 'conditionBlock',
            'field_values': 'fieldValues',
            'status': 'status',
            'status_description': 'statusDescription',
            'evaluation_result': 'evaluationResult'
        }
        self._condition_string = None
        self._condition_block = None
        self._field_values = None
        self._status = None
        self._status_description = None
        self._evaluation_result = None

    @property
    def condition_string(self):
        """
        **[Required]** Gets the condition_string of this ValidateLabelConditionResult.
        String representation of the validated label condition.


        :return: The condition_string of this ValidateLabelConditionResult.
        :rtype: str
        """
        return self._condition_string

    @condition_string.setter
    def condition_string(self, condition_string):
        """
        Sets the condition_string of this ValidateLabelConditionResult.
        String representation of the validated label condition.


        :param condition_string: The condition_string of this ValidateLabelConditionResult.
        :type: str
        """
        self._condition_string = condition_string

    @property
    def condition_block(self):
        """
        **[Required]** Gets the condition_block of this ValidateLabelConditionResult.

        :return: The condition_block of this ValidateLabelConditionResult.
        :rtype: oci.log_analytics.models.ConditionBlock
        """
        return self._condition_block

    @condition_block.setter
    def condition_block(self, condition_block):
        """
        Sets the condition_block of this ValidateLabelConditionResult.

        :param condition_block: The condition_block of this ValidateLabelConditionResult.
        :type: oci.log_analytics.models.ConditionBlock
        """
        self._condition_block = condition_block

    @property
    def field_values(self):
        """
        Gets the field_values of this ValidateLabelConditionResult.
        Field values against which the label condition was evaluated.


        :return: The field_values of this ValidateLabelConditionResult.
        :rtype: list[oci.log_analytics.models.LogAnalyticsProperty]
        """
        return self._field_values

    @field_values.setter
    def field_values(self, field_values):
        """
        Sets the field_values of this ValidateLabelConditionResult.
        Field values against which the label condition was evaluated.


        :param field_values: The field_values of this ValidateLabelConditionResult.
        :type: list[oci.log_analytics.models.LogAnalyticsProperty]
        """
        self._field_values = field_values

    @property
    def status(self):
        """
        **[Required]** Gets the status of this ValidateLabelConditionResult.
        The validation status.


        :return: The status of this ValidateLabelConditionResult.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this ValidateLabelConditionResult.
        The validation status.


        :param status: The status of this ValidateLabelConditionResult.
        :type: str
        """
        self._status = status

    @property
    def status_description(self):
        """
        Gets the status_description of this ValidateLabelConditionResult.
        The validation status description.


        :return: The status_description of this ValidateLabelConditionResult.
        :rtype: str
        """
        return self._status_description

    @status_description.setter
    def status_description(self, status_description):
        """
        Sets the status_description of this ValidateLabelConditionResult.
        The validation status description.


        :param status_description: The status_description of this ValidateLabelConditionResult.
        :type: str
        """
        self._status_description = status_description

    @property
    def evaluation_result(self):
        """
        Gets the evaluation_result of this ValidateLabelConditionResult.
        The result of evaluating the condition blocks against the specified field values. Either true or false.


        :return: The evaluation_result of this ValidateLabelConditionResult.
        :rtype: bool
        """
        return self._evaluation_result

    @evaluation_result.setter
    def evaluation_result(self, evaluation_result):
        """
        Sets the evaluation_result of this ValidateLabelConditionResult.
        The result of evaluating the condition blocks against the specified field values. Either true or false.


        :param evaluation_result: The evaluation_result of this ValidateLabelConditionResult.
        :type: bool
        """
        self._evaluation_result = evaluation_result

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
