# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: release


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateKeyDetails(object):
    """
    The details of the Key that you wish to update.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateKeyDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_auto_rotation_enabled:
            The value to assign to the is_auto_rotation_enabled property of this UpdateKeyDetails.
        :type is_auto_rotation_enabled: bool

        :param auto_key_rotation_details:
            The value to assign to the auto_key_rotation_details property of this UpdateKeyDetails.
        :type auto_key_rotation_details: oci.key_management.models.AutoKeyRotationDetails

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateKeyDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param display_name:
            The value to assign to the display_name property of this UpdateKeyDetails.
        :type display_name: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateKeyDetails.
        :type freeform_tags: dict(str, str)

        """
        self.swagger_types = {
            'is_auto_rotation_enabled': 'bool',
            'auto_key_rotation_details': 'AutoKeyRotationDetails',
            'defined_tags': 'dict(str, dict(str, object))',
            'display_name': 'str',
            'freeform_tags': 'dict(str, str)'
        }
        self.attribute_map = {
            'is_auto_rotation_enabled': 'isAutoRotationEnabled',
            'auto_key_rotation_details': 'autoKeyRotationDetails',
            'defined_tags': 'definedTags',
            'display_name': 'displayName',
            'freeform_tags': 'freeformTags'
        }
        self._is_auto_rotation_enabled = None
        self._auto_key_rotation_details = None
        self._defined_tags = None
        self._display_name = None
        self._freeform_tags = None

    @property
    def is_auto_rotation_enabled(self):
        """
        Gets the is_auto_rotation_enabled of this UpdateKeyDetails.
        A parameter specifying whether the auto key rotation is enabled or not.


        :return: The is_auto_rotation_enabled of this UpdateKeyDetails.
        :rtype: bool
        """
        return self._is_auto_rotation_enabled

    @is_auto_rotation_enabled.setter
    def is_auto_rotation_enabled(self, is_auto_rotation_enabled):
        """
        Sets the is_auto_rotation_enabled of this UpdateKeyDetails.
        A parameter specifying whether the auto key rotation is enabled or not.


        :param is_auto_rotation_enabled: The is_auto_rotation_enabled of this UpdateKeyDetails.
        :type: bool
        """
        self._is_auto_rotation_enabled = is_auto_rotation_enabled

    @property
    def auto_key_rotation_details(self):
        """
        Gets the auto_key_rotation_details of this UpdateKeyDetails.

        :return: The auto_key_rotation_details of this UpdateKeyDetails.
        :rtype: oci.key_management.models.AutoKeyRotationDetails
        """
        return self._auto_key_rotation_details

    @auto_key_rotation_details.setter
    def auto_key_rotation_details(self, auto_key_rotation_details):
        """
        Sets the auto_key_rotation_details of this UpdateKeyDetails.

        :param auto_key_rotation_details: The auto_key_rotation_details of this UpdateKeyDetails.
        :type: oci.key_management.models.AutoKeyRotationDetails
        """
        self._auto_key_rotation_details = auto_key_rotation_details

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateKeyDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this UpdateKeyDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateKeyDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this UpdateKeyDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateKeyDetails.
        A user-friendly name for the key. It does not have to be unique, and it is changeable.
        Avoid entering confidential information.


        :return: The display_name of this UpdateKeyDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateKeyDetails.
        A user-friendly name for the key. It does not have to be unique, and it is changeable.
        Avoid entering confidential information.


        :param display_name: The display_name of this UpdateKeyDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateKeyDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this UpdateKeyDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateKeyDetails.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.
        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this UpdateKeyDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
