# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AppRole(object):
    """
    AppRole resource.
    """

    #: A constant which can be used with the idcs_prevented_operations property of a AppRole.
    #: This constant has a value of "replace"
    IDCS_PREVENTED_OPERATIONS_REPLACE = "replace"

    #: A constant which can be used with the idcs_prevented_operations property of a AppRole.
    #: This constant has a value of "update"
    IDCS_PREVENTED_OPERATIONS_UPDATE = "update"

    #: A constant which can be used with the idcs_prevented_operations property of a AppRole.
    #: This constant has a value of "delete"
    IDCS_PREVENTED_OPERATIONS_DELETE = "delete"

    def __init__(self, **kwargs):
        """
        Initializes a new AppRole object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this AppRole.
        :type id: str

        :param ocid:
            The value to assign to the ocid property of this AppRole.
        :type ocid: str

        :param schemas:
            The value to assign to the schemas property of this AppRole.
        :type schemas: list[str]

        :param meta:
            The value to assign to the meta property of this AppRole.
        :type meta: oci.identity_domains.models.Meta

        :param idcs_created_by:
            The value to assign to the idcs_created_by property of this AppRole.
        :type idcs_created_by: oci.identity_domains.models.IdcsCreatedBy

        :param idcs_last_modified_by:
            The value to assign to the idcs_last_modified_by property of this AppRole.
        :type idcs_last_modified_by: oci.identity_domains.models.IdcsLastModifiedBy

        :param idcs_prevented_operations:
            The value to assign to the idcs_prevented_operations property of this AppRole.
            Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type idcs_prevented_operations: list[str]

        :param tags:
            The value to assign to the tags property of this AppRole.
        :type tags: list[oci.identity_domains.models.Tags]

        :param delete_in_progress:
            The value to assign to the delete_in_progress property of this AppRole.
        :type delete_in_progress: bool

        :param idcs_last_upgraded_in_release:
            The value to assign to the idcs_last_upgraded_in_release property of this AppRole.
        :type idcs_last_upgraded_in_release: str

        :param domain_ocid:
            The value to assign to the domain_ocid property of this AppRole.
        :type domain_ocid: str

        :param compartment_ocid:
            The value to assign to the compartment_ocid property of this AppRole.
        :type compartment_ocid: str

        :param tenancy_ocid:
            The value to assign to the tenancy_ocid property of this AppRole.
        :type tenancy_ocid: str

        :param display_name:
            The value to assign to the display_name property of this AppRole.
        :type display_name: str

        :param unique_name:
            The value to assign to the unique_name property of this AppRole.
        :type unique_name: str

        :param description:
            The value to assign to the description property of this AppRole.
        :type description: str

        :param legacy_group_name:
            The value to assign to the legacy_group_name property of this AppRole.
        :type legacy_group_name: str

        :param admin_role:
            The value to assign to the admin_role property of this AppRole.
        :type admin_role: bool

        :param limited_to_one_or_more_groups:
            The value to assign to the limited_to_one_or_more_groups property of this AppRole.
        :type limited_to_one_or_more_groups: bool

        :param available_to_users:
            The value to assign to the available_to_users property of this AppRole.
        :type available_to_users: bool

        :param available_to_groups:
            The value to assign to the available_to_groups property of this AppRole.
        :type available_to_groups: bool

        :param available_to_clients:
            The value to assign to the available_to_clients property of this AppRole.
        :type available_to_clients: bool

        :param public:
            The value to assign to the public property of this AppRole.
        :type public: bool

        :param localized_display_name:
            The value to assign to the localized_display_name property of this AppRole.
        :type localized_display_name: str

        :param app:
            The value to assign to the app property of this AppRole.
        :type app: oci.identity_domains.models.AppRoleApp

        :param members:
            The value to assign to the members property of this AppRole.
        :type members: list[oci.identity_domains.models.AppRoleMembers]

        """
        self.swagger_types = {
            'id': 'str',
            'ocid': 'str',
            'schemas': 'list[str]',
            'meta': 'Meta',
            'idcs_created_by': 'IdcsCreatedBy',
            'idcs_last_modified_by': 'IdcsLastModifiedBy',
            'idcs_prevented_operations': 'list[str]',
            'tags': 'list[Tags]',
            'delete_in_progress': 'bool',
            'idcs_last_upgraded_in_release': 'str',
            'domain_ocid': 'str',
            'compartment_ocid': 'str',
            'tenancy_ocid': 'str',
            'display_name': 'str',
            'unique_name': 'str',
            'description': 'str',
            'legacy_group_name': 'str',
            'admin_role': 'bool',
            'limited_to_one_or_more_groups': 'bool',
            'available_to_users': 'bool',
            'available_to_groups': 'bool',
            'available_to_clients': 'bool',
            'public': 'bool',
            'localized_display_name': 'str',
            'app': 'AppRoleApp',
            'members': 'list[AppRoleMembers]'
        }
        self.attribute_map = {
            'id': 'id',
            'ocid': 'ocid',
            'schemas': 'schemas',
            'meta': 'meta',
            'idcs_created_by': 'idcsCreatedBy',
            'idcs_last_modified_by': 'idcsLastModifiedBy',
            'idcs_prevented_operations': 'idcsPreventedOperations',
            'tags': 'tags',
            'delete_in_progress': 'deleteInProgress',
            'idcs_last_upgraded_in_release': 'idcsLastUpgradedInRelease',
            'domain_ocid': 'domainOcid',
            'compartment_ocid': 'compartmentOcid',
            'tenancy_ocid': 'tenancyOcid',
            'display_name': 'displayName',
            'unique_name': 'uniqueName',
            'description': 'description',
            'legacy_group_name': 'legacyGroupName',
            'admin_role': 'adminRole',
            'limited_to_one_or_more_groups': 'limitedToOneOrMoreGroups',
            'available_to_users': 'availableToUsers',
            'available_to_groups': 'availableToGroups',
            'available_to_clients': 'availableToClients',
            'public': 'public',
            'localized_display_name': 'localizedDisplayName',
            'app': 'app',
            'members': 'members'
        }
        self._id = None
        self._ocid = None
        self._schemas = None
        self._meta = None
        self._idcs_created_by = None
        self._idcs_last_modified_by = None
        self._idcs_prevented_operations = None
        self._tags = None
        self._delete_in_progress = None
        self._idcs_last_upgraded_in_release = None
        self._domain_ocid = None
        self._compartment_ocid = None
        self._tenancy_ocid = None
        self._display_name = None
        self._unique_name = None
        self._description = None
        self._legacy_group_name = None
        self._admin_role = None
        self._limited_to_one_or_more_groups = None
        self._available_to_users = None
        self._available_to_groups = None
        self._available_to_clients = None
        self._public = None
        self._localized_display_name = None
        self._app = None
        self._members = None

    @property
    def id(self):
        """
        Gets the id of this AppRole.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :return: The id of this AppRole.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this AppRole.
        Unique identifier for the SCIM Resource as defined by the Service Provider. Each representation of the Resource MUST include a non-empty id value. This identifier MUST be unique across the Service Provider's entire set of Resources. It MUST be a stable, non-reassignable identifier that does not change when the same Resource is returned in subsequent requests. The value of the id attribute is always issued by the Service Provider and MUST never be specified by the Service Consumer. bulkId: is a reserved keyword and MUST NOT be used in the unique identifier.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: global


        :param id: The id of this AppRole.
        :type: str
        """
        self._id = id

    @property
    def ocid(self):
        """
        Gets the ocid of this AppRole.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :return: The ocid of this AppRole.
        :rtype: str
        """
        return self._ocid

    @ocid.setter
    def ocid(self, ocid):
        """
        Sets the ocid of this AppRole.
        Unique OCI identifier for the SCIM Resource.

        **SCIM++ Properties:**
         - caseExact: true
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: global


        :param ocid: The ocid of this AppRole.
        :type: str
        """
        self._ocid = ocid

    @property
    def schemas(self):
        """
        **[Required]** Gets the schemas of this AppRole.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The schemas of this AppRole.
        :rtype: list[str]
        """
        return self._schemas

    @schemas.setter
    def schemas(self, schemas):
        """
        Sets the schemas of this AppRole.
        REQUIRED. The schemas attribute is an array of Strings which allows introspection of the supported schema version for a SCIM representation as well any schema extensions supported by that representation. Each String value must be a unique URI. This specification defines URIs for User, Group, and a standard \\\"enterprise\\\" extension. All representations of SCIM schema MUST include a non-zero value array with value(s) of the URIs supported by that representation. Duplicate values MUST NOT be included. Value order is not specified and MUST not impact behavior.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: true
         - mutability: readWrite
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param schemas: The schemas of this AppRole.
        :type: list[str]
        """
        self._schemas = schemas

    @property
    def meta(self):
        """
        Gets the meta of this AppRole.

        :return: The meta of this AppRole.
        :rtype: oci.identity_domains.models.Meta
        """
        return self._meta

    @meta.setter
    def meta(self, meta):
        """
        Sets the meta of this AppRole.

        :param meta: The meta of this AppRole.
        :type: oci.identity_domains.models.Meta
        """
        self._meta = meta

    @property
    def idcs_created_by(self):
        """
        Gets the idcs_created_by of this AppRole.

        :return: The idcs_created_by of this AppRole.
        :rtype: oci.identity_domains.models.IdcsCreatedBy
        """
        return self._idcs_created_by

    @idcs_created_by.setter
    def idcs_created_by(self, idcs_created_by):
        """
        Sets the idcs_created_by of this AppRole.

        :param idcs_created_by: The idcs_created_by of this AppRole.
        :type: oci.identity_domains.models.IdcsCreatedBy
        """
        self._idcs_created_by = idcs_created_by

    @property
    def idcs_last_modified_by(self):
        """
        Gets the idcs_last_modified_by of this AppRole.

        :return: The idcs_last_modified_by of this AppRole.
        :rtype: oci.identity_domains.models.IdcsLastModifiedBy
        """
        return self._idcs_last_modified_by

    @idcs_last_modified_by.setter
    def idcs_last_modified_by(self, idcs_last_modified_by):
        """
        Sets the idcs_last_modified_by of this AppRole.

        :param idcs_last_modified_by: The idcs_last_modified_by of this AppRole.
        :type: oci.identity_domains.models.IdcsLastModifiedBy
        """
        self._idcs_last_modified_by = idcs_last_modified_by

    @property
    def idcs_prevented_operations(self):
        """
        Gets the idcs_prevented_operations of this AppRole.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none

        Allowed values for items in this list are: "replace", "update", "delete", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The idcs_prevented_operations of this AppRole.
        :rtype: list[str]
        """
        return self._idcs_prevented_operations

    @idcs_prevented_operations.setter
    def idcs_prevented_operations(self, idcs_prevented_operations):
        """
        Sets the idcs_prevented_operations of this AppRole.
        Each value of this attribute specifies an operation that only an internal client may perform on this particular resource.

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_prevented_operations: The idcs_prevented_operations of this AppRole.
        :type: list[str]
        """
        allowed_values = ["replace", "update", "delete"]
        if idcs_prevented_operations:
            idcs_prevented_operations[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in idcs_prevented_operations]
        self._idcs_prevented_operations = idcs_prevented_operations

    @property
    def tags(self):
        """
        Gets the tags of this AppRole.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :return: The tags of this AppRole.
        :rtype: list[oci.identity_domains.models.Tags]
        """
        return self._tags

    @tags.setter
    def tags(self, tags):
        """
        Sets the tags of this AppRole.
        A list of tags on this resource.

        **SCIM++ Properties:**
         - idcsCompositeKey: [key, value]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readWrite
         - required: false
         - returned: request
         - type: complex
         - uniqueness: none


        :param tags: The tags of this AppRole.
        :type: list[oci.identity_domains.models.Tags]
        """
        self._tags = tags

    @property
    def delete_in_progress(self):
        """
        Gets the delete_in_progress of this AppRole.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The delete_in_progress of this AppRole.
        :rtype: bool
        """
        return self._delete_in_progress

    @delete_in_progress.setter
    def delete_in_progress(self, delete_in_progress):
        """
        Sets the delete_in_progress of this AppRole.
        A boolean flag indicating this resource in the process of being deleted. Usually set to true when synchronous deletion of the resource would take too long.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param delete_in_progress: The delete_in_progress of this AppRole.
        :type: bool
        """
        self._delete_in_progress = delete_in_progress

    @property
    def idcs_last_upgraded_in_release(self):
        """
        Gets the idcs_last_upgraded_in_release of this AppRole.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :return: The idcs_last_upgraded_in_release of this AppRole.
        :rtype: str
        """
        return self._idcs_last_upgraded_in_release

    @idcs_last_upgraded_in_release.setter
    def idcs_last_upgraded_in_release(self, idcs_last_upgraded_in_release):
        """
        Sets the idcs_last_upgraded_in_release of this AppRole.
        The release number when the resource was upgraded.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param idcs_last_upgraded_in_release: The idcs_last_upgraded_in_release of this AppRole.
        :type: str
        """
        self._idcs_last_upgraded_in_release = idcs_last_upgraded_in_release

    @property
    def domain_ocid(self):
        """
        Gets the domain_ocid of this AppRole.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The domain_ocid of this AppRole.
        :rtype: str
        """
        return self._domain_ocid

    @domain_ocid.setter
    def domain_ocid(self, domain_ocid):
        """
        Sets the domain_ocid of this AppRole.
        OCI Domain Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param domain_ocid: The domain_ocid of this AppRole.
        :type: str
        """
        self._domain_ocid = domain_ocid

    @property
    def compartment_ocid(self):
        """
        Gets the compartment_ocid of this AppRole.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The compartment_ocid of this AppRole.
        :rtype: str
        """
        return self._compartment_ocid

    @compartment_ocid.setter
    def compartment_ocid(self, compartment_ocid):
        """
        Sets the compartment_ocid of this AppRole.
        OCI Compartment Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param compartment_ocid: The compartment_ocid of this AppRole.
        :type: str
        """
        self._compartment_ocid = compartment_ocid

    @property
    def tenancy_ocid(self):
        """
        Gets the tenancy_ocid of this AppRole.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The tenancy_ocid of this AppRole.
        :rtype: str
        """
        return self._tenancy_ocid

    @tenancy_ocid.setter
    def tenancy_ocid(self, tenancy_ocid):
        """
        Sets the tenancy_ocid of this AppRole.
        OCI Tenant Id (ocid) in which the resource lives.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param tenancy_ocid: The tenancy_ocid of this AppRole.
        :type: str
        """
        self._tenancy_ocid = tenancy_ocid

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this AppRole.
        AppRole name

        **SCIM++ Properties:**
         - caseExact: false
         - idcsCsvAttributeName: Display Name
         - idcsCsvAttributeNameMappings: [[columnHeaderName:Entitlement Value]]
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: always
         - type: string
         - uniqueness: none


        :return: The display_name of this AppRole.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this AppRole.
        AppRole name

        **SCIM++ Properties:**
         - caseExact: false
         - idcsCsvAttributeName: Display Name
         - idcsCsvAttributeNameMappings: [[columnHeaderName:Entitlement Value]]
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: true
         - returned: always
         - type: string
         - uniqueness: none


        :param display_name: The display_name of this AppRole.
        :type: str
        """
        self._display_name = display_name

    @property
    def unique_name(self):
        """
        Gets the unique_name of this AppRole.
        AppRole unique name

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: server


        :return: The unique_name of this AppRole.
        :rtype: str
        """
        return self._unique_name

    @unique_name.setter
    def unique_name(self, unique_name):
        """
        Sets the unique_name of this AppRole.
        AppRole unique name

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: always
         - type: string
         - uniqueness: server


        :param unique_name: The unique_name of this AppRole.
        :type: str
        """
        self._unique_name = unique_name

    @property
    def description(self):
        """
        Gets the description of this AppRole.
        AppRole description

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The description of this AppRole.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this AppRole.
        AppRole description

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param description: The description of this AppRole.
        :type: str
        """
        self._description = description

    @property
    def legacy_group_name(self):
        """
        Gets the legacy_group_name of this AppRole.
        The name of the legacy group associated with this AppRole.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: server


        :return: The legacy_group_name of this AppRole.
        :rtype: str
        """
        return self._legacy_group_name

    @legacy_group_name.setter
    def legacy_group_name(self, legacy_group_name):
        """
        Sets the legacy_group_name of this AppRole.
        The name of the legacy group associated with this AppRole.

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: string
         - uniqueness: server


        :param legacy_group_name: The legacy_group_name of this AppRole.
        :type: str
        """
        self._legacy_group_name = legacy_group_name

    @property
    def admin_role(self):
        """
        Gets the admin_role of this AppRole.
        If true, the role provides administrative access privileges.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The admin_role of this AppRole.
        :rtype: bool
        """
        return self._admin_role

    @admin_role.setter
    def admin_role(self, admin_role):
        """
        Sets the admin_role of this AppRole.
        If true, the role provides administrative access privileges.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param admin_role: The admin_role of this AppRole.
        :type: bool
        """
        self._admin_role = admin_role

    @property
    def limited_to_one_or_more_groups(self):
        """
        Gets the limited_to_one_or_more_groups of this AppRole.
        If true, indicates that this Oracle Identity Cloud Service AppRole can be granted to a delegated administrator whose scope is limited to users that are members of one or more groups.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The limited_to_one_or_more_groups of this AppRole.
        :rtype: bool
        """
        return self._limited_to_one_or_more_groups

    @limited_to_one_or_more_groups.setter
    def limited_to_one_or_more_groups(self, limited_to_one_or_more_groups):
        """
        Sets the limited_to_one_or_more_groups of this AppRole.
        If true, indicates that this Oracle Identity Cloud Service AppRole can be granted to a delegated administrator whose scope is limited to users that are members of one or more groups.

        **Added In:** 19.2.1

        **SCIM++ Properties:**
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param limited_to_one_or_more_groups: The limited_to_one_or_more_groups of this AppRole.
        :type: bool
        """
        self._limited_to_one_or_more_groups = limited_to_one_or_more_groups

    @property
    def available_to_users(self):
        """
        Gets the available_to_users of this AppRole.
        If true, this AppRole can be granted to Users.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The available_to_users of this AppRole.
        :rtype: bool
        """
        return self._available_to_users

    @available_to_users.setter
    def available_to_users(self, available_to_users):
        """
        Sets the available_to_users of this AppRole.
        If true, this AppRole can be granted to Users.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param available_to_users: The available_to_users of this AppRole.
        :type: bool
        """
        self._available_to_users = available_to_users

    @property
    def available_to_groups(self):
        """
        Gets the available_to_groups of this AppRole.
        If true, this AppRole can be granted to Groups.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The available_to_groups of this AppRole.
        :rtype: bool
        """
        return self._available_to_groups

    @available_to_groups.setter
    def available_to_groups(self, available_to_groups):
        """
        Sets the available_to_groups of this AppRole.
        If true, this AppRole can be granted to Groups.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param available_to_groups: The available_to_groups of this AppRole.
        :type: bool
        """
        self._available_to_groups = available_to_groups

    @property
    def available_to_clients(self):
        """
        Gets the available_to_clients of this AppRole.
        If true, this AppRole can be granted to Apps.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The available_to_clients of this AppRole.
        :rtype: bool
        """
        return self._available_to_clients

    @available_to_clients.setter
    def available_to_clients(self, available_to_clients):
        """
        Sets the available_to_clients of this AppRole.
        If true, this AppRole can be granted to Apps.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: immutable
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param available_to_clients: The available_to_clients of this AppRole.
        :type: bool
        """
        self._available_to_clients = available_to_clients

    @property
    def public(self):
        """
        Gets the public of this AppRole.
        If true, this AppRole is available automatically to every Oracle Identity Cloud Service User in this tenancy. There is no need to grant it to individual Users or Groups.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The public of this AppRole.
        :rtype: bool
        """
        return self._public

    @public.setter
    def public(self, public):
        """
        Sets the public of this AppRole.
        If true, this AppRole is available automatically to every Oracle Identity Cloud Service User in this tenancy. There is no need to grant it to individual Users or Groups.

        **SCIM++ Properties:**
         - idcsSearchable: true
         - multiValued: false
         - mutability: readWrite
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param public: The public of this AppRole.
        :type: bool
        """
        self._public = public

    @property
    def localized_display_name(self):
        """
        Gets the localized_display_name of this AppRole.
        AppRole localization name

        **Added In:** 2109090424

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :return: The localized_display_name of this AppRole.
        :rtype: str
        """
        return self._localized_display_name

    @localized_display_name.setter
    def localized_display_name(self, localized_display_name):
        """
        Sets the localized_display_name of this AppRole.
        AppRole localization name

        **Added In:** 2109090424

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: request
         - type: string
         - uniqueness: none


        :param localized_display_name: The localized_display_name of this AppRole.
        :type: str
        """
        self._localized_display_name = localized_display_name

    @property
    def app(self):
        """
        **[Required]** Gets the app of this AppRole.

        :return: The app of this AppRole.
        :rtype: oci.identity_domains.models.AppRoleApp
        """
        return self._app

    @app.setter
    def app(self, app):
        """
        Sets the app of this AppRole.

        :param app: The app of this AppRole.
        :type: oci.identity_domains.models.AppRoleApp
        """
        self._app = app

    @property
    def members(self):
        """
        Gets the members of this AppRole.
        AppRole members - when requesting members attribute, it is recommended to use startIndex and count to return members in pages instead of in a single response, eg : #attributes=members[startIndex=1%26count=10]

        **SCIM++ Properties:**
         - idcsCompositeKey: [value, type]
         - idcsCsvAttributeNameMappings: [[columnHeaderName:Grantee Name, mapsTo:members.value], [columnHeaderName:Grantee Type, mapsTo:members.type]]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - idcsPaginateResponse: true
         - type: complex
         - uniqueness: none


        :return: The members of this AppRole.
        :rtype: list[oci.identity_domains.models.AppRoleMembers]
        """
        return self._members

    @members.setter
    def members(self, members):
        """
        Sets the members of this AppRole.
        AppRole members - when requesting members attribute, it is recommended to use startIndex and count to return members in pages instead of in a single response, eg : #attributes=members[startIndex=1%26count=10]

        **SCIM++ Properties:**
         - idcsCompositeKey: [value, type]
         - idcsCsvAttributeNameMappings: [[columnHeaderName:Grantee Name, mapsTo:members.value], [columnHeaderName:Grantee Type, mapsTo:members.type]]
         - idcsSearchable: true
         - multiValued: true
         - mutability: readOnly
         - required: false
         - returned: request
         - idcsPaginateResponse: true
         - type: complex
         - uniqueness: none


        :param members: The members of this AppRole.
        :type: list[oci.identity_domains.models.AppRoleMembers]
        """
        self._members = members

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
