# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407

from .iceberg_catalog import IcebergCatalog
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PolarisIcebergCatalog(IcebergCatalog):
    """
    Represents a Polaris catalog used in the Iceberg connection.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PolarisIcebergCatalog object with values from keyword arguments. The default value of the :py:attr:`~oci.golden_gate.models.PolarisIcebergCatalog.catalog_type` attribute
        of this class is ``POLARIS`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param catalog_type:
            The value to assign to the catalog_type property of this PolarisIcebergCatalog.
            Allowed values for this property are: "GLUE", "HADOOP", "NESSIE", "POLARIS", "REST"
        :type catalog_type: str

        :param uri:
            The value to assign to the uri property of this PolarisIcebergCatalog.
        :type uri: str

        :param name:
            The value to assign to the name property of this PolarisIcebergCatalog.
        :type name: str

        :param client_id:
            The value to assign to the client_id property of this PolarisIcebergCatalog.
        :type client_id: str

        :param client_secret_secret_id:
            The value to assign to the client_secret_secret_id property of this PolarisIcebergCatalog.
        :type client_secret_secret_id: str

        :param principal_role:
            The value to assign to the principal_role property of this PolarisIcebergCatalog.
        :type principal_role: str

        """
        self.swagger_types = {
            'catalog_type': 'str',
            'uri': 'str',
            'name': 'str',
            'client_id': 'str',
            'client_secret_secret_id': 'str',
            'principal_role': 'str'
        }
        self.attribute_map = {
            'catalog_type': 'catalogType',
            'uri': 'uri',
            'name': 'name',
            'client_id': 'clientId',
            'client_secret_secret_id': 'clientSecretSecretId',
            'principal_role': 'principalRole'
        }
        self._catalog_type = None
        self._uri = None
        self._name = None
        self._client_id = None
        self._client_secret_secret_id = None
        self._principal_role = None
        self._catalog_type = 'POLARIS'

    @property
    def uri(self):
        """
        **[Required]** Gets the uri of this PolarisIcebergCatalog.
        The URL endpoint for the Polaris API.
        e.g.: 'https://<your-snowflake-account>.snowflakecomputing.com/polaris/api/catalog'


        :return: The uri of this PolarisIcebergCatalog.
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """
        Sets the uri of this PolarisIcebergCatalog.
        The URL endpoint for the Polaris API.
        e.g.: 'https://<your-snowflake-account>.snowflakecomputing.com/polaris/api/catalog'


        :param uri: The uri of this PolarisIcebergCatalog.
        :type: str
        """
        self._uri = uri

    @property
    def name(self):
        """
        **[Required]** Gets the name of this PolarisIcebergCatalog.
        The catalog name within Polaris where Iceberg tables are registered.


        :return: The name of this PolarisIcebergCatalog.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this PolarisIcebergCatalog.
        The catalog name within Polaris where Iceberg tables are registered.


        :param name: The name of this PolarisIcebergCatalog.
        :type: str
        """
        self._name = name

    @property
    def client_id(self):
        """
        **[Required]** Gets the client_id of this PolarisIcebergCatalog.
        The OAuth client ID used for authentication.


        :return: The client_id of this PolarisIcebergCatalog.
        :rtype: str
        """
        return self._client_id

    @client_id.setter
    def client_id(self, client_id):
        """
        Sets the client_id of this PolarisIcebergCatalog.
        The OAuth client ID used for authentication.


        :param client_id: The client_id of this PolarisIcebergCatalog.
        :type: str
        """
        self._client_id = client_id

    @property
    def client_secret_secret_id(self):
        """
        **[Required]** Gets the client_secret_secret_id of this PolarisIcebergCatalog.
        The `OCID`__ of the Secret that stores the password Oracle GoldenGate uses to connect to Snowflake platform.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The client_secret_secret_id of this PolarisIcebergCatalog.
        :rtype: str
        """
        return self._client_secret_secret_id

    @client_secret_secret_id.setter
    def client_secret_secret_id(self, client_secret_secret_id):
        """
        Sets the client_secret_secret_id of this PolarisIcebergCatalog.
        The `OCID`__ of the Secret that stores the password Oracle GoldenGate uses to connect to Snowflake platform.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param client_secret_secret_id: The client_secret_secret_id of this PolarisIcebergCatalog.
        :type: str
        """
        self._client_secret_secret_id = client_secret_secret_id

    @property
    def principal_role(self):
        """
        **[Required]** Gets the principal_role of this PolarisIcebergCatalog.
        The Snowflake role used to access Polaris.


        :return: The principal_role of this PolarisIcebergCatalog.
        :rtype: str
        """
        return self._principal_role

    @principal_role.setter
    def principal_role(self, principal_role):
        """
        Sets the principal_role of this PolarisIcebergCatalog.
        The Snowflake role used to access Polaris.


        :param principal_role: The principal_role of this PolarisIcebergCatalog.
        :type: str
        """
        self._principal_role = principal_role

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
