# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class KnowledgeBaseMetadataValue(object):
    """
    Represents a metadata value and the number of appearances in knowledge base.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new KnowledgeBaseMetadataValue object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param value:
            The value to assign to the value property of this KnowledgeBaseMetadataValue.
        :type value: str

        :param count:
            The value to assign to the count property of this KnowledgeBaseMetadataValue.
        :type count: int

        """
        self.swagger_types = {
            'value': 'str',
            'count': 'int'
        }
        self.attribute_map = {
            'value': 'value',
            'count': 'count'
        }
        self._value = None
        self._count = None

    @property
    def value(self):
        """
        **[Required]** Gets the value of this KnowledgeBaseMetadataValue.
        The value of the metadata


        :return: The value of this KnowledgeBaseMetadataValue.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this KnowledgeBaseMetadataValue.
        The value of the metadata


        :param value: The value of this KnowledgeBaseMetadataValue.
        :type: str
        """
        self._value = value

    @property
    def count(self):
        """
        **[Required]** Gets the count of this KnowledgeBaseMetadataValue.
        Number of documents where this value exists


        :return: The count of this KnowledgeBaseMetadataValue.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count):
        """
        Sets the count of this KnowledgeBaseMetadataValue.
        Number of documents where this value exists


        :param count: The count of this KnowledgeBaseMetadataValue.
        :type: int
        """
        self._count = count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
