# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GuardrailConfig(object):
    """
    The configuration details about whether to apply the guardrail checks to input and output.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GuardrailConfig object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param content_moderation_config:
            The value to assign to the content_moderation_config property of this GuardrailConfig.
        :type content_moderation_config: oci.generative_ai_agent.models.ContentModerationGuardrailConfig

        :param prompt_injection_config:
            The value to assign to the prompt_injection_config property of this GuardrailConfig.
        :type prompt_injection_config: oci.generative_ai_agent.models.PromptInjectionGuardrailConfig

        :param personally_identifiable_information_config:
            The value to assign to the personally_identifiable_information_config property of this GuardrailConfig.
        :type personally_identifiable_information_config: oci.generative_ai_agent.models.PersonallyIdentifiableInformationGuardrailConfig

        """
        self.swagger_types = {
            'content_moderation_config': 'ContentModerationGuardrailConfig',
            'prompt_injection_config': 'PromptInjectionGuardrailConfig',
            'personally_identifiable_information_config': 'PersonallyIdentifiableInformationGuardrailConfig'
        }
        self.attribute_map = {
            'content_moderation_config': 'contentModerationConfig',
            'prompt_injection_config': 'promptInjectionConfig',
            'personally_identifiable_information_config': 'personallyIdentifiableInformationConfig'
        }
        self._content_moderation_config = None
        self._prompt_injection_config = None
        self._personally_identifiable_information_config = None

    @property
    def content_moderation_config(self):
        """
        Gets the content_moderation_config of this GuardrailConfig.

        :return: The content_moderation_config of this GuardrailConfig.
        :rtype: oci.generative_ai_agent.models.ContentModerationGuardrailConfig
        """
        return self._content_moderation_config

    @content_moderation_config.setter
    def content_moderation_config(self, content_moderation_config):
        """
        Sets the content_moderation_config of this GuardrailConfig.

        :param content_moderation_config: The content_moderation_config of this GuardrailConfig.
        :type: oci.generative_ai_agent.models.ContentModerationGuardrailConfig
        """
        self._content_moderation_config = content_moderation_config

    @property
    def prompt_injection_config(self):
        """
        Gets the prompt_injection_config of this GuardrailConfig.

        :return: The prompt_injection_config of this GuardrailConfig.
        :rtype: oci.generative_ai_agent.models.PromptInjectionGuardrailConfig
        """
        return self._prompt_injection_config

    @prompt_injection_config.setter
    def prompt_injection_config(self, prompt_injection_config):
        """
        Sets the prompt_injection_config of this GuardrailConfig.

        :param prompt_injection_config: The prompt_injection_config of this GuardrailConfig.
        :type: oci.generative_ai_agent.models.PromptInjectionGuardrailConfig
        """
        self._prompt_injection_config = prompt_injection_config

    @property
    def personally_identifiable_information_config(self):
        """
        Gets the personally_identifiable_information_config of this GuardrailConfig.

        :return: The personally_identifiable_information_config of this GuardrailConfig.
        :rtype: oci.generative_ai_agent.models.PersonallyIdentifiableInformationGuardrailConfig
        """
        return self._personally_identifiable_information_config

    @personally_identifiable_information_config.setter
    def personally_identifiable_information_config(self, personally_identifiable_information_config):
        """
        Sets the personally_identifiable_information_config of this GuardrailConfig.

        :param personally_identifiable_information_config: The personally_identifiable_information_config of this GuardrailConfig.
        :type: oci.generative_ai_agent.models.PersonallyIdentifiableInformationGuardrailConfig
        """
        self._personally_identifiable_information_config = personally_identifiable_information_config

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
