# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .schedule import Schedule
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class MaintenanceWindowSchedule(Schedule):
    """
    MaintenanceWindow Information for Schedule.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new MaintenanceWindowSchedule object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.MaintenanceWindowSchedule.type` attribute
        of this class is ``MAINTENANCE_WINDOW`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this MaintenanceWindowSchedule.
            Allowed values for this property are: "CUSTOM", "MAINTENANCE_WINDOW"
        :type type: str

        :param execution_startdate:
            The value to assign to the execution_startdate property of this MaintenanceWindowSchedule.
        :type execution_startdate: datetime

        :param maintenance_window_id:
            The value to assign to the maintenance_window_id property of this MaintenanceWindowSchedule.
        :type maintenance_window_id: str

        """
        self.swagger_types = {
            'type': 'str',
            'execution_startdate': 'datetime',
            'maintenance_window_id': 'str'
        }
        self.attribute_map = {
            'type': 'type',
            'execution_startdate': 'executionStartdate',
            'maintenance_window_id': 'maintenanceWindowId'
        }
        self._type = None
        self._execution_startdate = None
        self._maintenance_window_id = None
        self._type = 'MAINTENANCE_WINDOW'

    @property
    def maintenance_window_id(self):
        """
        **[Required]** Gets the maintenance_window_id of this MaintenanceWindowSchedule.
        Provide MaintenanceWindowId


        :return: The maintenance_window_id of this MaintenanceWindowSchedule.
        :rtype: str
        """
        return self._maintenance_window_id

    @maintenance_window_id.setter
    def maintenance_window_id(self, maintenance_window_id):
        """
        Sets the maintenance_window_id of this MaintenanceWindowSchedule.
        Provide MaintenanceWindowId


        :param maintenance_window_id: The maintenance_window_id of this MaintenanceWindowSchedule.
        :type: str
        """
        self._maintenance_window_id = maintenance_window_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
