# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateRunbookVersionDetails(object):
    """
    The information about new Runbook.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateRunbookVersionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param runbook_id:
            The value to assign to the runbook_id property of this CreateRunbookVersionDetails.
        :type runbook_id: str

        :param tasks:
            The value to assign to the tasks property of this CreateRunbookVersionDetails.
        :type tasks: list[oci.fleet_apps_management.models.Task]

        :param groups:
            The value to assign to the groups property of this CreateRunbookVersionDetails.
        :type groups: list[oci.fleet_apps_management.models.Group]

        :param execution_workflow_details:
            The value to assign to the execution_workflow_details property of this CreateRunbookVersionDetails.
        :type execution_workflow_details: oci.fleet_apps_management.models.ExecutionWorkflowDetails

        :param rollback_workflow_details:
            The value to assign to the rollback_workflow_details property of this CreateRunbookVersionDetails.
        :type rollback_workflow_details: oci.fleet_apps_management.models.RollbackWorkflowDetails

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateRunbookVersionDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateRunbookVersionDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'runbook_id': 'str',
            'tasks': 'list[Task]',
            'groups': 'list[Group]',
            'execution_workflow_details': 'ExecutionWorkflowDetails',
            'rollback_workflow_details': 'RollbackWorkflowDetails',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'runbook_id': 'runbookId',
            'tasks': 'tasks',
            'groups': 'groups',
            'execution_workflow_details': 'executionWorkflowDetails',
            'rollback_workflow_details': 'rollbackWorkflowDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._runbook_id = None
        self._tasks = None
        self._groups = None
        self._execution_workflow_details = None
        self._rollback_workflow_details = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def runbook_id(self):
        """
        **[Required]** Gets the runbook_id of this CreateRunbookVersionDetails.
        The OCID of the resource.


        :return: The runbook_id of this CreateRunbookVersionDetails.
        :rtype: str
        """
        return self._runbook_id

    @runbook_id.setter
    def runbook_id(self, runbook_id):
        """
        Sets the runbook_id of this CreateRunbookVersionDetails.
        The OCID of the resource.


        :param runbook_id: The runbook_id of this CreateRunbookVersionDetails.
        :type: str
        """
        self._runbook_id = runbook_id

    @property
    def tasks(self):
        """
        **[Required]** Gets the tasks of this CreateRunbookVersionDetails.
        A set of tasks to execute in the runbook.


        :return: The tasks of this CreateRunbookVersionDetails.
        :rtype: list[oci.fleet_apps_management.models.Task]
        """
        return self._tasks

    @tasks.setter
    def tasks(self, tasks):
        """
        Sets the tasks of this CreateRunbookVersionDetails.
        A set of tasks to execute in the runbook.


        :param tasks: The tasks of this CreateRunbookVersionDetails.
        :type: list[oci.fleet_apps_management.models.Task]
        """
        self._tasks = tasks

    @property
    def groups(self):
        """
        **[Required]** Gets the groups of this CreateRunbookVersionDetails.
        The groups of the runbook.


        :return: The groups of this CreateRunbookVersionDetails.
        :rtype: list[oci.fleet_apps_management.models.Group]
        """
        return self._groups

    @groups.setter
    def groups(self, groups):
        """
        Sets the groups of this CreateRunbookVersionDetails.
        The groups of the runbook.


        :param groups: The groups of this CreateRunbookVersionDetails.
        :type: list[oci.fleet_apps_management.models.Group]
        """
        self._groups = groups

    @property
    def execution_workflow_details(self):
        """
        **[Required]** Gets the execution_workflow_details of this CreateRunbookVersionDetails.

        :return: The execution_workflow_details of this CreateRunbookVersionDetails.
        :rtype: oci.fleet_apps_management.models.ExecutionWorkflowDetails
        """
        return self._execution_workflow_details

    @execution_workflow_details.setter
    def execution_workflow_details(self, execution_workflow_details):
        """
        Sets the execution_workflow_details of this CreateRunbookVersionDetails.

        :param execution_workflow_details: The execution_workflow_details of this CreateRunbookVersionDetails.
        :type: oci.fleet_apps_management.models.ExecutionWorkflowDetails
        """
        self._execution_workflow_details = execution_workflow_details

    @property
    def rollback_workflow_details(self):
        """
        Gets the rollback_workflow_details of this CreateRunbookVersionDetails.

        :return: The rollback_workflow_details of this CreateRunbookVersionDetails.
        :rtype: oci.fleet_apps_management.models.RollbackWorkflowDetails
        """
        return self._rollback_workflow_details

    @rollback_workflow_details.setter
    def rollback_workflow_details(self, rollback_workflow_details):
        """
        Sets the rollback_workflow_details of this CreateRunbookVersionDetails.

        :param rollback_workflow_details: The rollback_workflow_details of this CreateRunbookVersionDetails.
        :type: oci.fleet_apps_management.models.RollbackWorkflowDetails
        """
        self._rollback_workflow_details = rollback_workflow_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateRunbookVersionDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateRunbookVersionDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateRunbookVersionDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateRunbookVersionDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateRunbookVersionDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateRunbookVersionDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateRunbookVersionDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateRunbookVersionDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
