# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateCatalogItemDetails(object):
    """
    The data to create a CatalogItem.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateCatalogItemDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateCatalogItemDetails.
        :type compartment_id: str

        :param config_source_type:
            The value to assign to the config_source_type property of this CreateCatalogItemDetails.
        :type config_source_type: str

        :param description:
            The value to assign to the description property of this CreateCatalogItemDetails.
        :type description: str

        :param version_description:
            The value to assign to the version_description property of this CreateCatalogItemDetails.
        :type version_description: str

        :param short_description:
            The value to assign to the short_description property of this CreateCatalogItemDetails.
        :type short_description: str

        :param time_released:
            The value to assign to the time_released property of this CreateCatalogItemDetails.
        :type time_released: datetime

        :param display_name:
            The value to assign to the display_name property of this CreateCatalogItemDetails.
        :type display_name: str

        :param catalog_source_payload:
            The value to assign to the catalog_source_payload property of this CreateCatalogItemDetails.
        :type catalog_source_payload: oci.fleet_apps_management.models.CatalogSourcePayload

        :param listing_id:
            The value to assign to the listing_id property of this CreateCatalogItemDetails.
        :type listing_id: str

        :param listing_version:
            The value to assign to the listing_version property of this CreateCatalogItemDetails.
        :type listing_version: str

        :param package_type:
            The value to assign to the package_type property of this CreateCatalogItemDetails.
        :type package_type: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateCatalogItemDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateCatalogItemDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'config_source_type': 'str',
            'description': 'str',
            'version_description': 'str',
            'short_description': 'str',
            'time_released': 'datetime',
            'display_name': 'str',
            'catalog_source_payload': 'CatalogSourcePayload',
            'listing_id': 'str',
            'listing_version': 'str',
            'package_type': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'config_source_type': 'configSourceType',
            'description': 'description',
            'version_description': 'versionDescription',
            'short_description': 'shortDescription',
            'time_released': 'timeReleased',
            'display_name': 'displayName',
            'catalog_source_payload': 'catalogSourcePayload',
            'listing_id': 'listingId',
            'listing_version': 'listingVersion',
            'package_type': 'packageType',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._compartment_id = None
        self._config_source_type = None
        self._description = None
        self._version_description = None
        self._short_description = None
        self._time_released = None
        self._display_name = None
        self._catalog_source_payload = None
        self._listing_id = None
        self._listing_version = None
        self._package_type = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateCatalogItemDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateCatalogItemDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateCatalogItemDetails.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateCatalogItemDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def config_source_type(self):
        """
        **[Required]** Gets the config_source_type of this CreateCatalogItemDetails.
        Config source type Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, GIT_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.


        :return: The config_source_type of this CreateCatalogItemDetails.
        :rtype: str
        """
        return self._config_source_type

    @config_source_type.setter
    def config_source_type(self, config_source_type):
        """
        Sets the config_source_type of this CreateCatalogItemDetails.
        Config source type Eg: STACK_TEMPLATE_CATALOG_SOURCE, PAR_CATALOG_SOURCE, GIT_CATALOG_SOURCE, MARKETPLACE_CATALOG_SOURCE.


        :param config_source_type: The config_source_type of this CreateCatalogItemDetails.
        :type: str
        """
        self._config_source_type = config_source_type

    @property
    def description(self):
        """
        **[Required]** Gets the description of this CreateCatalogItemDetails.
        The description of the CatalogItem.


        :return: The description of this CreateCatalogItemDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateCatalogItemDetails.
        The description of the CatalogItem.


        :param description: The description of this CreateCatalogItemDetails.
        :type: str
        """
        self._description = description

    @property
    def version_description(self):
        """
        Gets the version_description of this CreateCatalogItemDetails.
        Version description about the catalog item.


        :return: The version_description of this CreateCatalogItemDetails.
        :rtype: str
        """
        return self._version_description

    @version_description.setter
    def version_description(self, version_description):
        """
        Sets the version_description of this CreateCatalogItemDetails.
        Version description about the catalog item.


        :param version_description: The version_description of this CreateCatalogItemDetails.
        :type: str
        """
        self._version_description = version_description

    @property
    def short_description(self):
        """
        Gets the short_description of this CreateCatalogItemDetails.
        Short description about the catalog item.


        :return: The short_description of this CreateCatalogItemDetails.
        :rtype: str
        """
        return self._short_description

    @short_description.setter
    def short_description(self, short_description):
        """
        Sets the short_description of this CreateCatalogItemDetails.
        Short description about the catalog item.


        :param short_description: The short_description of this CreateCatalogItemDetails.
        :type: str
        """
        self._short_description = short_description

    @property
    def time_released(self):
        """
        Gets the time_released of this CreateCatalogItemDetails.
        The date and time the CatalogItem was released, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_released of this CreateCatalogItemDetails.
        :rtype: datetime
        """
        return self._time_released

    @time_released.setter
    def time_released(self, time_released):
        """
        Sets the time_released of this CreateCatalogItemDetails.
        The date and time the CatalogItem was released, in the format defined by `RFC 3339`__.
        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_released: The time_released of this CreateCatalogItemDetails.
        :type: datetime
        """
        self._time_released = time_released

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateCatalogItemDetails.
        The CatalogItem name.


        :return: The display_name of this CreateCatalogItemDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateCatalogItemDetails.
        The CatalogItem name.


        :param display_name: The display_name of this CreateCatalogItemDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def catalog_source_payload(self):
        """
        Gets the catalog_source_payload of this CreateCatalogItemDetails.

        :return: The catalog_source_payload of this CreateCatalogItemDetails.
        :rtype: oci.fleet_apps_management.models.CatalogSourcePayload
        """
        return self._catalog_source_payload

    @catalog_source_payload.setter
    def catalog_source_payload(self, catalog_source_payload):
        """
        Sets the catalog_source_payload of this CreateCatalogItemDetails.

        :param catalog_source_payload: The catalog_source_payload of this CreateCatalogItemDetails.
        :type: oci.fleet_apps_management.models.CatalogSourcePayload
        """
        self._catalog_source_payload = catalog_source_payload

    @property
    def listing_id(self):
        """
        Gets the listing_id of this CreateCatalogItemDetails.
        The catalog listing Id.


        :return: The listing_id of this CreateCatalogItemDetails.
        :rtype: str
        """
        return self._listing_id

    @listing_id.setter
    def listing_id(self, listing_id):
        """
        Sets the listing_id of this CreateCatalogItemDetails.
        The catalog listing Id.


        :param listing_id: The listing_id of this CreateCatalogItemDetails.
        :type: str
        """
        self._listing_id = listing_id

    @property
    def listing_version(self):
        """
        Gets the listing_version of this CreateCatalogItemDetails.
        The catalog package version.


        :return: The listing_version of this CreateCatalogItemDetails.
        :rtype: str
        """
        return self._listing_version

    @listing_version.setter
    def listing_version(self, listing_version):
        """
        Sets the listing_version of this CreateCatalogItemDetails.
        The catalog package version.


        :param listing_version: The listing_version of this CreateCatalogItemDetails.
        :type: str
        """
        self._listing_version = listing_version

    @property
    def package_type(self):
        """
        **[Required]** Gets the package_type of this CreateCatalogItemDetails.
        Config package type Eg: TF_PACKAGE, NON_TF_PACKAGE, CONFIG_FILE.


        :return: The package_type of this CreateCatalogItemDetails.
        :rtype: str
        """
        return self._package_type

    @package_type.setter
    def package_type(self, package_type):
        """
        Sets the package_type of this CreateCatalogItemDetails.
        Config package type Eg: TF_PACKAGE, NON_TF_PACKAGE, CONFIG_FILE.


        :param package_type: The package_type of this CreateCatalogItemDetails.
        :type: str
        """
        self._package_type = package_type

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateCatalogItemDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateCatalogItemDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateCatalogItemDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateCatalogItemDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateCatalogItemDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateCatalogItemDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateCatalogItemDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateCatalogItemDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
