# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AddDistributedDatabaseGdsControlNodeDetails(object):
    """
    Details required to create a new Global database services control(GDS CTL) compute node.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AddDistributedDatabaseGdsControlNodeDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param public_ssh_key:
            The value to assign to the public_ssh_key property of this AddDistributedDatabaseGdsControlNodeDetails.
        :type public_ssh_key: str

        :param subnet_id:
            The value to assign to the subnet_id property of this AddDistributedDatabaseGdsControlNodeDetails.
        :type subnet_id: str

        """
        self.swagger_types = {
            'public_ssh_key': 'str',
            'subnet_id': 'str'
        }
        self.attribute_map = {
            'public_ssh_key': 'publicSshKey',
            'subnet_id': 'subnetId'
        }
        self._public_ssh_key = None
        self._subnet_id = None

    @property
    def public_ssh_key(self):
        """
        **[Required]** Gets the public_ssh_key of this AddDistributedDatabaseGdsControlNodeDetails.
        The public sshKey for Global database services control(GDS CTL) node.


        :return: The public_ssh_key of this AddDistributedDatabaseGdsControlNodeDetails.
        :rtype: str
        """
        return self._public_ssh_key

    @public_ssh_key.setter
    def public_ssh_key(self, public_ssh_key):
        """
        Sets the public_ssh_key of this AddDistributedDatabaseGdsControlNodeDetails.
        The public sshKey for Global database services control(GDS CTL) node.


        :param public_ssh_key: The public_ssh_key of this AddDistributedDatabaseGdsControlNodeDetails.
        :type: str
        """
        self._public_ssh_key = public_ssh_key

    @property
    def subnet_id(self):
        """
        Gets the subnet_id of this AddDistributedDatabaseGdsControlNodeDetails.
        The `OCID`__ of the subnet on which the Global database services control(GDS CTL) node should be created.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The subnet_id of this AddDistributedDatabaseGdsControlNodeDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this AddDistributedDatabaseGdsControlNodeDetails.
        The `OCID`__ of the subnet on which the Global database services control(GDS CTL) node should be created.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param subnet_id: The subnet_id of this AddDistributedDatabaseGdsControlNodeDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
