# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PullRequestComment(object):
    """
    User comments created by reviewers during the pull request review.
    """

    #: A constant which can be used with the file_type property of a PullRequestComment.
    #: This constant has a value of "SOURCE"
    FILE_TYPE_SOURCE = "SOURCE"

    #: A constant which can be used with the file_type property of a PullRequestComment.
    #: This constant has a value of "DESTINATION"
    FILE_TYPE_DESTINATION = "DESTINATION"

    #: A constant which can be used with the status property of a PullRequestComment.
    #: This constant has a value of "ACTIVE"
    STATUS_ACTIVE = "ACTIVE"

    #: A constant which can be used with the status property of a PullRequestComment.
    #: This constant has a value of "OUTDATED"
    STATUS_OUTDATED = "OUTDATED"

    #: A constant which can be used with the context_status property of a PullRequestComment.
    #: This constant has a value of "PROCESSED"
    CONTEXT_STATUS_PROCESSED = "PROCESSED"

    #: A constant which can be used with the context_status property of a PullRequestComment.
    #: This constant has a value of "NEEDS_PROCESSING"
    CONTEXT_STATUS_NEEDS_PROCESSING = "NEEDS_PROCESSING"

    def __init__(self, **kwargs):
        """
        Initializes a new PullRequestComment object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this PullRequestComment.
        :type id: str

        :param pull_request_id:
            The value to assign to the pull_request_id property of this PullRequestComment.
        :type pull_request_id: str

        :param data:
            The value to assign to the data property of this PullRequestComment.
        :type data: str

        :param parent_id:
            The value to assign to the parent_id property of this PullRequestComment.
        :type parent_id: str

        :param file_path:
            The value to assign to the file_path property of this PullRequestComment.
        :type file_path: str

        :param commit_id:
            The value to assign to the commit_id property of this PullRequestComment.
        :type commit_id: str

        :param file_type:
            The value to assign to the file_type property of this PullRequestComment.
            Allowed values for this property are: "SOURCE", "DESTINATION", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type file_type: str

        :param line_number:
            The value to assign to the line_number property of this PullRequestComment.
        :type line_number: int

        :param likes:
            The value to assign to the likes property of this PullRequestComment.
        :type likes: oci.devops.models.PullRequestCommentLikeCollection

        :param status:
            The value to assign to the status property of this PullRequestComment.
            Allowed values for this property are: "ACTIVE", "OUTDATED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param time_created:
            The value to assign to the time_created property of this PullRequestComment.
        :type time_created: datetime

        :param created_by:
            The value to assign to the created_by property of this PullRequestComment.
        :type created_by: oci.devops.models.PrincipalDetails

        :param time_updated:
            The value to assign to the time_updated property of this PullRequestComment.
        :type time_updated: datetime

        :param updated_by:
            The value to assign to the updated_by property of this PullRequestComment.
        :type updated_by: oci.devops.models.PrincipalDetails

        :param context_status:
            The value to assign to the context_status property of this PullRequestComment.
            Allowed values for this property are: "PROCESSED", "NEEDS_PROCESSING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type context_status: str

        :param comment_context:
            The value to assign to the comment_context property of this PullRequestComment.
        :type comment_context: list[oci.devops.models.DiffLineDetails]

        """
        self.swagger_types = {
            'id': 'str',
            'pull_request_id': 'str',
            'data': 'str',
            'parent_id': 'str',
            'file_path': 'str',
            'commit_id': 'str',
            'file_type': 'str',
            'line_number': 'int',
            'likes': 'PullRequestCommentLikeCollection',
            'status': 'str',
            'time_created': 'datetime',
            'created_by': 'PrincipalDetails',
            'time_updated': 'datetime',
            'updated_by': 'PrincipalDetails',
            'context_status': 'str',
            'comment_context': 'list[DiffLineDetails]'
        }
        self.attribute_map = {
            'id': 'id',
            'pull_request_id': 'pullRequestId',
            'data': 'data',
            'parent_id': 'parentId',
            'file_path': 'filePath',
            'commit_id': 'commitId',
            'file_type': 'fileType',
            'line_number': 'lineNumber',
            'likes': 'likes',
            'status': 'status',
            'time_created': 'timeCreated',
            'created_by': 'createdBy',
            'time_updated': 'timeUpdated',
            'updated_by': 'updatedBy',
            'context_status': 'contextStatus',
            'comment_context': 'commentContext'
        }
        self._id = None
        self._pull_request_id = None
        self._data = None
        self._parent_id = None
        self._file_path = None
        self._commit_id = None
        self._file_type = None
        self._line_number = None
        self._likes = None
        self._status = None
        self._time_created = None
        self._created_by = None
        self._time_updated = None
        self._updated_by = None
        self._context_status = None
        self._comment_context = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this PullRequestComment.
        Unique identifier that is immutable on creation


        :return: The id of this PullRequestComment.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PullRequestComment.
        Unique identifier that is immutable on creation


        :param id: The id of this PullRequestComment.
        :type: str
        """
        self._id = id

    @property
    def pull_request_id(self):
        """
        **[Required]** Gets the pull_request_id of this PullRequestComment.
        OCID of the pull request that this comment belongs to


        :return: The pull_request_id of this PullRequestComment.
        :rtype: str
        """
        return self._pull_request_id

    @pull_request_id.setter
    def pull_request_id(self, pull_request_id):
        """
        Sets the pull_request_id of this PullRequestComment.
        OCID of the pull request that this comment belongs to


        :param pull_request_id: The pull_request_id of this PullRequestComment.
        :type: str
        """
        self._pull_request_id = pull_request_id

    @property
    def data(self):
        """
        **[Required]** Gets the data of this PullRequestComment.
        Content of the Comment.


        :return: The data of this PullRequestComment.
        :rtype: str
        """
        return self._data

    @data.setter
    def data(self, data):
        """
        Sets the data of this PullRequestComment.
        Content of the Comment.


        :param data: The data of this PullRequestComment.
        :type: str
        """
        self._data = data

    @property
    def parent_id(self):
        """
        Gets the parent_id of this PullRequestComment.
        ID of parent Comment


        :return: The parent_id of this PullRequestComment.
        :rtype: str
        """
        return self._parent_id

    @parent_id.setter
    def parent_id(self, parent_id):
        """
        Sets the parent_id of this PullRequestComment.
        ID of parent Comment


        :param parent_id: The parent_id of this PullRequestComment.
        :type: str
        """
        self._parent_id = parent_id

    @property
    def file_path(self):
        """
        Gets the file_path of this PullRequestComment.
        File path in the commit


        :return: The file_path of this PullRequestComment.
        :rtype: str
        """
        return self._file_path

    @file_path.setter
    def file_path(self, file_path):
        """
        Sets the file_path of this PullRequestComment.
        File path in the commit


        :param file_path: The file_path of this PullRequestComment.
        :type: str
        """
        self._file_path = file_path

    @property
    def commit_id(self):
        """
        Gets the commit_id of this PullRequestComment.
        Commit SHA


        :return: The commit_id of this PullRequestComment.
        :rtype: str
        """
        return self._commit_id

    @commit_id.setter
    def commit_id(self, commit_id):
        """
        Sets the commit_id of this PullRequestComment.
        Commit SHA


        :param commit_id: The commit_id of this PullRequestComment.
        :type: str
        """
        self._commit_id = commit_id

    @property
    def file_type(self):
        """
        Gets the file_type of this PullRequestComment.
        File path in the target commit

        Allowed values for this property are: "SOURCE", "DESTINATION", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The file_type of this PullRequestComment.
        :rtype: str
        """
        return self._file_type

    @file_type.setter
    def file_type(self, file_type):
        """
        Sets the file_type of this PullRequestComment.
        File path in the target commit


        :param file_type: The file_type of this PullRequestComment.
        :type: str
        """
        allowed_values = ["SOURCE", "DESTINATION"]
        if not value_allowed_none_or_none_sentinel(file_type, allowed_values):
            file_type = 'UNKNOWN_ENUM_VALUE'
        self._file_type = file_type

    @property
    def line_number(self):
        """
        Gets the line_number of this PullRequestComment.
        Line number in the file


        :return: The line_number of this PullRequestComment.
        :rtype: int
        """
        return self._line_number

    @line_number.setter
    def line_number(self, line_number):
        """
        Sets the line_number of this PullRequestComment.
        Line number in the file


        :param line_number: The line_number of this PullRequestComment.
        :type: int
        """
        self._line_number = line_number

    @property
    def likes(self):
        """
        Gets the likes of this PullRequestComment.

        :return: The likes of this PullRequestComment.
        :rtype: oci.devops.models.PullRequestCommentLikeCollection
        """
        return self._likes

    @likes.setter
    def likes(self, likes):
        """
        Sets the likes of this PullRequestComment.

        :param likes: The likes of this PullRequestComment.
        :type: oci.devops.models.PullRequestCommentLikeCollection
        """
        self._likes = likes

    @property
    def status(self):
        """
        **[Required]** Gets the status of this PullRequestComment.
        Status of the Comment

        Allowed values for this property are: "ACTIVE", "OUTDATED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this PullRequestComment.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this PullRequestComment.
        Status of the Comment


        :param status: The status of this PullRequestComment.
        :type: str
        """
        allowed_values = ["ACTIVE", "OUTDATED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this PullRequestComment.
        Creation timestamp. Format defined by `RFC3339`__.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_created of this PullRequestComment.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this PullRequestComment.
        Creation timestamp. Format defined by `RFC3339`__.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_created: The time_created of this PullRequestComment.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def created_by(self):
        """
        **[Required]** Gets the created_by of this PullRequestComment.

        :return: The created_by of this PullRequestComment.
        :rtype: oci.devops.models.PrincipalDetails
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this PullRequestComment.

        :param created_by: The created_by of this PullRequestComment.
        :type: oci.devops.models.PrincipalDetails
        """
        self._created_by = created_by

    @property
    def time_updated(self):
        """
        Gets the time_updated of this PullRequestComment.
        Latest update timestamp. Format defined by `RFC3339`__.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :return: The time_updated of this PullRequestComment.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this PullRequestComment.
        Latest update timestamp. Format defined by `RFC3339`__.

        __ https://datatracker.ietf.org/doc/html/rfc3339


        :param time_updated: The time_updated of this PullRequestComment.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def updated_by(self):
        """
        Gets the updated_by of this PullRequestComment.

        :return: The updated_by of this PullRequestComment.
        :rtype: oci.devops.models.PrincipalDetails
        """
        return self._updated_by

    @updated_by.setter
    def updated_by(self, updated_by):
        """
        Sets the updated_by of this PullRequestComment.

        :param updated_by: The updated_by of this PullRequestComment.
        :type: oci.devops.models.PrincipalDetails
        """
        self._updated_by = updated_by

    @property
    def context_status(self):
        """
        Gets the context_status of this PullRequestComment.
        Shows the status of an inline comments context

        Allowed values for this property are: "PROCESSED", "NEEDS_PROCESSING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The context_status of this PullRequestComment.
        :rtype: str
        """
        return self._context_status

    @context_status.setter
    def context_status(self, context_status):
        """
        Sets the context_status of this PullRequestComment.
        Shows the status of an inline comments context


        :param context_status: The context_status of this PullRequestComment.
        :type: str
        """
        allowed_values = ["PROCESSED", "NEEDS_PROCESSING"]
        if not value_allowed_none_or_none_sentinel(context_status, allowed_values):
            context_status = 'UNKNOWN_ENUM_VALUE'
        self._context_status = context_status

    @property
    def comment_context(self):
        """
        Gets the comment_context of this PullRequestComment.
        4 line snippet to be displayed as context for inline comments


        :return: The comment_context of this PullRequestComment.
        :rtype: list[oci.devops.models.DiffLineDetails]
        """
        return self._comment_context

    @comment_context.setter
    def comment_context(self, comment_context):
        """
        Sets the comment_context of this PullRequestComment.
        4 line snippet to be displayed as context for inline comments


        :param comment_context: The comment_context of this PullRequestComment.
        :type: list[oci.devops.models.DiffLineDetails]
        """
        self._comment_context = comment_context

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
