# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class WorkRequest(object):
    """
    A description of work request status.
    """

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CREATE_AZURE_CONNECTOR"
    OPERATION_TYPE_CREATE_AZURE_CONNECTOR = "CREATE_AZURE_CONNECTOR"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DELETE_AZURE_CONNECTOR"
    OPERATION_TYPE_DELETE_AZURE_CONNECTOR = "DELETE_AZURE_CONNECTOR"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "UPDATE_AZURE_CONNECTOR"
    OPERATION_TYPE_UPDATE_AZURE_CONNECTOR = "UPDATE_AZURE_CONNECTOR"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "MOVE_AZURE_CONNECTOR"
    OPERATION_TYPE_MOVE_AZURE_CONNECTOR = "MOVE_AZURE_CONNECTOR"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "REFRESH_AZURE_CONNECTOR"
    OPERATION_TYPE_REFRESH_AZURE_CONNECTOR = "REFRESH_AZURE_CONNECTOR"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CREATE_AZURE_BLOB_CONTAINER"
    OPERATION_TYPE_CREATE_AZURE_BLOB_CONTAINER = "CREATE_AZURE_BLOB_CONTAINER"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DELETE_AZURE_BLOB_CONTAINER"
    OPERATION_TYPE_DELETE_AZURE_BLOB_CONTAINER = "DELETE_AZURE_BLOB_CONTAINER"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "UPDATE_AZURE_BLOB_CONTAINER"
    OPERATION_TYPE_UPDATE_AZURE_BLOB_CONTAINER = "UPDATE_AZURE_BLOB_CONTAINER"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "MOVE_AZURE_BLOB_CONTAINER"
    OPERATION_TYPE_MOVE_AZURE_BLOB_CONTAINER = "MOVE_AZURE_BLOB_CONTAINER"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CREATE_AZURE_BLOB_MOUNT"
    OPERATION_TYPE_CREATE_AZURE_BLOB_MOUNT = "CREATE_AZURE_BLOB_MOUNT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "MOVE_AZURE_BLOB_MOUNT"
    OPERATION_TYPE_MOVE_AZURE_BLOB_MOUNT = "MOVE_AZURE_BLOB_MOUNT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "UPDATE_AZURE_BLOB_MOUNT"
    OPERATION_TYPE_UPDATE_AZURE_BLOB_MOUNT = "UPDATE_AZURE_BLOB_MOUNT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DELETE_AZURE_BLOB_MOUNT"
    OPERATION_TYPE_DELETE_AZURE_BLOB_MOUNT = "DELETE_AZURE_BLOB_MOUNT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CREATE_MULTICLOUD_DISCOVERY"
    OPERATION_TYPE_CREATE_MULTICLOUD_DISCOVERY = "CREATE_MULTICLOUD_DISCOVERY"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DELETE_MULTICLOUD_DISCOVERY"
    OPERATION_TYPE_DELETE_MULTICLOUD_DISCOVERY = "DELETE_MULTICLOUD_DISCOVERY"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "UPDATE_MULTICLOUD_DISCOVERY"
    OPERATION_TYPE_UPDATE_MULTICLOUD_DISCOVERY = "UPDATE_MULTICLOUD_DISCOVERY"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "MOVE_MULTICLOUD_DISCOVERY"
    OPERATION_TYPE_MOVE_MULTICLOUD_DISCOVERY = "MOVE_MULTICLOUD_DISCOVERY"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CREATE_AZURE_VAULT"
    OPERATION_TYPE_CREATE_AZURE_VAULT = "CREATE_AZURE_VAULT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DELETE_AZURE_VAULT"
    OPERATION_TYPE_DELETE_AZURE_VAULT = "DELETE_AZURE_VAULT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "UPDATE_AZURE_VAULT"
    OPERATION_TYPE_UPDATE_AZURE_VAULT = "UPDATE_AZURE_VAULT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "MOVE_AZURE_VAULT"
    OPERATION_TYPE_MOVE_AZURE_VAULT = "MOVE_AZURE_VAULT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "REFRESH_AZURE_VAULT"
    OPERATION_TYPE_REFRESH_AZURE_VAULT = "REFRESH_AZURE_VAULT"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CREATE_AZURE_VAULT_ASSOCIATION"
    OPERATION_TYPE_CREATE_AZURE_VAULT_ASSOCIATION = "CREATE_AZURE_VAULT_ASSOCIATION"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DELETE_AZURE_VAULT_ASSOCIATION"
    OPERATION_TYPE_DELETE_AZURE_VAULT_ASSOCIATION = "DELETE_AZURE_VAULT_ASSOCIATION"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "UPDATE_AZURE_VAULT_ASSOCIATION"
    OPERATION_TYPE_UPDATE_AZURE_VAULT_ASSOCIATION = "UPDATE_AZURE_VAULT_ASSOCIATION"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "MOVE_AZURE_VAULT_ASSOCIATION"
    OPERATION_TYPE_MOVE_AZURE_VAULT_ASSOCIATION = "MOVE_AZURE_VAULT_ASSOCIATION"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "PATCH_DB_RESOURCE"
    OPERATION_TYPE_PATCH_DB_RESOURCE = "PATCH_DB_RESOURCE"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CREATE_GCP_IDENTITY_CONFIGURATION"
    OPERATION_TYPE_CREATE_GCP_IDENTITY_CONFIGURATION = "CREATE_GCP_IDENTITY_CONFIGURATION"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CREATE_GCP_CONNECTOR"
    OPERATION_TYPE_CREATE_GCP_CONNECTOR = "CREATE_GCP_CONNECTOR"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DELETE_GCP_CONNECTOR"
    OPERATION_TYPE_DELETE_GCP_CONNECTOR = "DELETE_GCP_CONNECTOR"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "UPDATE_GCP_CONNECTOR"
    OPERATION_TYPE_UPDATE_GCP_CONNECTOR = "UPDATE_GCP_CONNECTOR"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "MOVE_GCP_CONNECTOR"
    OPERATION_TYPE_MOVE_GCP_CONNECTOR = "MOVE_GCP_CONNECTOR"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "REFRESH_GCP_CONNECTOR"
    OPERATION_TYPE_REFRESH_GCP_CONNECTOR = "REFRESH_GCP_CONNECTOR"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "GCP_DISCOVERY"
    OPERATION_TYPE_GCP_DISCOVERY = "GCP_DISCOVERY"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "CREATE_GCP_KEY_RING"
    OPERATION_TYPE_CREATE_GCP_KEY_RING = "CREATE_GCP_KEY_RING"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "DELETE_GCP_KEY_RING"
    OPERATION_TYPE_DELETE_GCP_KEY_RING = "DELETE_GCP_KEY_RING"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "UPDATE_GCP_KEY_RING"
    OPERATION_TYPE_UPDATE_GCP_KEY_RING = "UPDATE_GCP_KEY_RING"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "MOVE_GCP_KEY_RING"
    OPERATION_TYPE_MOVE_GCP_KEY_RING = "MOVE_GCP_KEY_RING"

    #: A constant which can be used with the operation_type property of a WorkRequest.
    #: This constant has a value of "REFRESH_GCP_KEY_RING"
    OPERATION_TYPE_REFRESH_GCP_KEY_RING = "REFRESH_GCP_KEY_RING"

    #: A constant which can be used with the status property of a WorkRequest.
    #: This constant has a value of "ACCEPTED"
    STATUS_ACCEPTED = "ACCEPTED"

    #: A constant which can be used with the status property of a WorkRequest.
    #: This constant has a value of "IN_PROGRESS"
    STATUS_IN_PROGRESS = "IN_PROGRESS"

    #: A constant which can be used with the status property of a WorkRequest.
    #: This constant has a value of "WAITING"
    STATUS_WAITING = "WAITING"

    #: A constant which can be used with the status property of a WorkRequest.
    #: This constant has a value of "NEEDS_ATTENTION"
    STATUS_NEEDS_ATTENTION = "NEEDS_ATTENTION"

    #: A constant which can be used with the status property of a WorkRequest.
    #: This constant has a value of "FAILED"
    STATUS_FAILED = "FAILED"

    #: A constant which can be used with the status property of a WorkRequest.
    #: This constant has a value of "SUCCEEDED"
    STATUS_SUCCEEDED = "SUCCEEDED"

    #: A constant which can be used with the status property of a WorkRequest.
    #: This constant has a value of "CANCELING"
    STATUS_CANCELING = "CANCELING"

    #: A constant which can be used with the status property of a WorkRequest.
    #: This constant has a value of "CANCELED"
    STATUS_CANCELED = "CANCELED"

    def __init__(self, **kwargs):
        """
        Initializes a new WorkRequest object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param operation_type:
            The value to assign to the operation_type property of this WorkRequest.
            Allowed values for this property are: "CREATE_AZURE_CONNECTOR", "DELETE_AZURE_CONNECTOR", "UPDATE_AZURE_CONNECTOR", "MOVE_AZURE_CONNECTOR", "REFRESH_AZURE_CONNECTOR", "CREATE_AZURE_BLOB_CONTAINER", "DELETE_AZURE_BLOB_CONTAINER", "UPDATE_AZURE_BLOB_CONTAINER", "MOVE_AZURE_BLOB_CONTAINER", "CREATE_AZURE_BLOB_MOUNT", "MOVE_AZURE_BLOB_MOUNT", "UPDATE_AZURE_BLOB_MOUNT", "DELETE_AZURE_BLOB_MOUNT", "CREATE_MULTICLOUD_DISCOVERY", "DELETE_MULTICLOUD_DISCOVERY", "UPDATE_MULTICLOUD_DISCOVERY", "MOVE_MULTICLOUD_DISCOVERY", "CREATE_AZURE_VAULT", "DELETE_AZURE_VAULT", "UPDATE_AZURE_VAULT", "MOVE_AZURE_VAULT", "REFRESH_AZURE_VAULT", "CREATE_AZURE_VAULT_ASSOCIATION", "DELETE_AZURE_VAULT_ASSOCIATION", "UPDATE_AZURE_VAULT_ASSOCIATION", "MOVE_AZURE_VAULT_ASSOCIATION", "PATCH_DB_RESOURCE", "CREATE_GCP_IDENTITY_CONFIGURATION", "CREATE_GCP_CONNECTOR", "DELETE_GCP_CONNECTOR", "UPDATE_GCP_CONNECTOR", "MOVE_GCP_CONNECTOR", "REFRESH_GCP_CONNECTOR", "GCP_DISCOVERY", "CREATE_GCP_KEY_RING", "DELETE_GCP_KEY_RING", "UPDATE_GCP_KEY_RING", "MOVE_GCP_KEY_RING", "REFRESH_GCP_KEY_RING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type operation_type: str

        :param status:
            The value to assign to the status property of this WorkRequest.
            Allowed values for this property are: "ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type status: str

        :param id:
            The value to assign to the id property of this WorkRequest.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this WorkRequest.
        :type compartment_id: str

        :param resources:
            The value to assign to the resources property of this WorkRequest.
        :type resources: list[oci.dbmulticloud.models.WorkRequestResource]

        :param percent_complete:
            The value to assign to the percent_complete property of this WorkRequest.
        :type percent_complete: float

        :param time_accepted:
            The value to assign to the time_accepted property of this WorkRequest.
        :type time_accepted: datetime

        :param time_started:
            The value to assign to the time_started property of this WorkRequest.
        :type time_started: datetime

        :param time_finished:
            The value to assign to the time_finished property of this WorkRequest.
        :type time_finished: datetime

        """
        self.swagger_types = {
            'operation_type': 'str',
            'status': 'str',
            'id': 'str',
            'compartment_id': 'str',
            'resources': 'list[WorkRequestResource]',
            'percent_complete': 'float',
            'time_accepted': 'datetime',
            'time_started': 'datetime',
            'time_finished': 'datetime'
        }
        self.attribute_map = {
            'operation_type': 'operationType',
            'status': 'status',
            'id': 'id',
            'compartment_id': 'compartmentId',
            'resources': 'resources',
            'percent_complete': 'percentComplete',
            'time_accepted': 'timeAccepted',
            'time_started': 'timeStarted',
            'time_finished': 'timeFinished'
        }
        self._operation_type = None
        self._status = None
        self._id = None
        self._compartment_id = None
        self._resources = None
        self._percent_complete = None
        self._time_accepted = None
        self._time_started = None
        self._time_finished = None

    @property
    def operation_type(self):
        """
        **[Required]** Gets the operation_type of this WorkRequest.
        Type of the work request.

        Allowed values for this property are: "CREATE_AZURE_CONNECTOR", "DELETE_AZURE_CONNECTOR", "UPDATE_AZURE_CONNECTOR", "MOVE_AZURE_CONNECTOR", "REFRESH_AZURE_CONNECTOR", "CREATE_AZURE_BLOB_CONTAINER", "DELETE_AZURE_BLOB_CONTAINER", "UPDATE_AZURE_BLOB_CONTAINER", "MOVE_AZURE_BLOB_CONTAINER", "CREATE_AZURE_BLOB_MOUNT", "MOVE_AZURE_BLOB_MOUNT", "UPDATE_AZURE_BLOB_MOUNT", "DELETE_AZURE_BLOB_MOUNT", "CREATE_MULTICLOUD_DISCOVERY", "DELETE_MULTICLOUD_DISCOVERY", "UPDATE_MULTICLOUD_DISCOVERY", "MOVE_MULTICLOUD_DISCOVERY", "CREATE_AZURE_VAULT", "DELETE_AZURE_VAULT", "UPDATE_AZURE_VAULT", "MOVE_AZURE_VAULT", "REFRESH_AZURE_VAULT", "CREATE_AZURE_VAULT_ASSOCIATION", "DELETE_AZURE_VAULT_ASSOCIATION", "UPDATE_AZURE_VAULT_ASSOCIATION", "MOVE_AZURE_VAULT_ASSOCIATION", "PATCH_DB_RESOURCE", "CREATE_GCP_IDENTITY_CONFIGURATION", "CREATE_GCP_CONNECTOR", "DELETE_GCP_CONNECTOR", "UPDATE_GCP_CONNECTOR", "MOVE_GCP_CONNECTOR", "REFRESH_GCP_CONNECTOR", "GCP_DISCOVERY", "CREATE_GCP_KEY_RING", "DELETE_GCP_KEY_RING", "UPDATE_GCP_KEY_RING", "MOVE_GCP_KEY_RING", "REFRESH_GCP_KEY_RING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The operation_type of this WorkRequest.
        :rtype: str
        """
        return self._operation_type

    @operation_type.setter
    def operation_type(self, operation_type):
        """
        Sets the operation_type of this WorkRequest.
        Type of the work request.


        :param operation_type: The operation_type of this WorkRequest.
        :type: str
        """
        allowed_values = ["CREATE_AZURE_CONNECTOR", "DELETE_AZURE_CONNECTOR", "UPDATE_AZURE_CONNECTOR", "MOVE_AZURE_CONNECTOR", "REFRESH_AZURE_CONNECTOR", "CREATE_AZURE_BLOB_CONTAINER", "DELETE_AZURE_BLOB_CONTAINER", "UPDATE_AZURE_BLOB_CONTAINER", "MOVE_AZURE_BLOB_CONTAINER", "CREATE_AZURE_BLOB_MOUNT", "MOVE_AZURE_BLOB_MOUNT", "UPDATE_AZURE_BLOB_MOUNT", "DELETE_AZURE_BLOB_MOUNT", "CREATE_MULTICLOUD_DISCOVERY", "DELETE_MULTICLOUD_DISCOVERY", "UPDATE_MULTICLOUD_DISCOVERY", "MOVE_MULTICLOUD_DISCOVERY", "CREATE_AZURE_VAULT", "DELETE_AZURE_VAULT", "UPDATE_AZURE_VAULT", "MOVE_AZURE_VAULT", "REFRESH_AZURE_VAULT", "CREATE_AZURE_VAULT_ASSOCIATION", "DELETE_AZURE_VAULT_ASSOCIATION", "UPDATE_AZURE_VAULT_ASSOCIATION", "MOVE_AZURE_VAULT_ASSOCIATION", "PATCH_DB_RESOURCE", "CREATE_GCP_IDENTITY_CONFIGURATION", "CREATE_GCP_CONNECTOR", "DELETE_GCP_CONNECTOR", "UPDATE_GCP_CONNECTOR", "MOVE_GCP_CONNECTOR", "REFRESH_GCP_CONNECTOR", "GCP_DISCOVERY", "CREATE_GCP_KEY_RING", "DELETE_GCP_KEY_RING", "UPDATE_GCP_KEY_RING", "MOVE_GCP_KEY_RING", "REFRESH_GCP_KEY_RING"]
        if not value_allowed_none_or_none_sentinel(operation_type, allowed_values):
            operation_type = 'UNKNOWN_ENUM_VALUE'
        self._operation_type = operation_type

    @property
    def status(self):
        """
        **[Required]** Gets the status of this WorkRequest.
        Status of current work request.

        Allowed values for this property are: "ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The status of this WorkRequest.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """
        Sets the status of this WorkRequest.
        Status of current work request.


        :param status: The status of this WorkRequest.
        :type: str
        """
        allowed_values = ["ACCEPTED", "IN_PROGRESS", "WAITING", "NEEDS_ATTENTION", "FAILED", "SUCCEEDED", "CANCELING", "CANCELED"]
        if not value_allowed_none_or_none_sentinel(status, allowed_values):
            status = 'UNKNOWN_ENUM_VALUE'
        self._status = status

    @property
    def id(self):
        """
        **[Required]** Gets the id of this WorkRequest.
        The id of the work request.


        :return: The id of this WorkRequest.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this WorkRequest.
        The id of the work request.


        :param id: The id of this WorkRequest.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this WorkRequest.
        The ID of the compartment that contains the work request. Work requests should be scoped to
        the same compartment as the resource the work request affects. If the work request affects multiple resources,
        and those resources are not in the same compartment, it is up to the service team to pick the primary
        resource whose compartment should be used


        :return: The compartment_id of this WorkRequest.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this WorkRequest.
        The ID of the compartment that contains the work request. Work requests should be scoped to
        the same compartment as the resource the work request affects. If the work request affects multiple resources,
        and those resources are not in the same compartment, it is up to the service team to pick the primary
        resource whose compartment should be used


        :param compartment_id: The compartment_id of this WorkRequest.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def resources(self):
        """
        **[Required]** Gets the resources of this WorkRequest.
        The resources affected by this work request.


        :return: The resources of this WorkRequest.
        :rtype: list[oci.dbmulticloud.models.WorkRequestResource]
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """
        Sets the resources of this WorkRequest.
        The resources affected by this work request.


        :param resources: The resources of this WorkRequest.
        :type: list[oci.dbmulticloud.models.WorkRequestResource]
        """
        self._resources = resources

    @property
    def percent_complete(self):
        """
        **[Required]** Gets the percent_complete of this WorkRequest.
        Percentage of the request completed.


        :return: The percent_complete of this WorkRequest.
        :rtype: float
        """
        return self._percent_complete

    @percent_complete.setter
    def percent_complete(self, percent_complete):
        """
        Sets the percent_complete of this WorkRequest.
        Percentage of the request completed.


        :param percent_complete: The percent_complete of this WorkRequest.
        :type: float
        """
        self._percent_complete = percent_complete

    @property
    def time_accepted(self):
        """
        **[Required]** Gets the time_accepted of this WorkRequest.
        The date and time the request was created, as described in
        `RFC 3339`__, section 14.29.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_accepted of this WorkRequest.
        :rtype: datetime
        """
        return self._time_accepted

    @time_accepted.setter
    def time_accepted(self, time_accepted):
        """
        Sets the time_accepted of this WorkRequest.
        The date and time the request was created, as described in
        `RFC 3339`__, section 14.29.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_accepted: The time_accepted of this WorkRequest.
        :type: datetime
        """
        self._time_accepted = time_accepted

    @property
    def time_started(self):
        """
        Gets the time_started of this WorkRequest.
        The date and time the request was started, as described in `RFC 3339`__,
        section 14.29.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_started of this WorkRequest.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this WorkRequest.
        The date and time the request was started, as described in `RFC 3339`__,
        section 14.29.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_started: The time_started of this WorkRequest.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_finished(self):
        """
        Gets the time_finished of this WorkRequest.
        The date and time the object was finished, as described in `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_finished of this WorkRequest.
        :rtype: datetime
        """
        return self._time_finished

    @time_finished.setter
    def time_finished(self, time_finished):
        """
        Sets the time_finished of this WorkRequest.
        The date and time the object was finished, as described in `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_finished: The time_finished of this WorkRequest.
        :type: datetime
        """
        self._time_finished = time_finished

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
