# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ImagesPatchRecommendationSummary(object):
    """
    Summary of image patches recommended to install.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ImagesPatchRecommendationSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param total_images_count:
            The value to assign to the total_images_count property of this ImagesPatchRecommendationSummary.
        :type total_images_count: int

        :param up_to_date_images_count:
            The value to assign to the up_to_date_images_count property of this ImagesPatchRecommendationSummary.
        :type up_to_date_images_count: int

        :param image_patch_recommendations_count:
            The value to assign to the image_patch_recommendations_count property of this ImagesPatchRecommendationSummary.
        :type image_patch_recommendations_count: int

        """
        self.swagger_types = {
            'total_images_count': 'int',
            'up_to_date_images_count': 'int',
            'image_patch_recommendations_count': 'int'
        }
        self.attribute_map = {
            'total_images_count': 'totalImagesCount',
            'up_to_date_images_count': 'upToDateImagesCount',
            'image_patch_recommendations_count': 'imagePatchRecommendationsCount'
        }
        self._total_images_count = None
        self._up_to_date_images_count = None
        self._image_patch_recommendations_count = None

    @property
    def total_images_count(self):
        """
        Gets the total_images_count of this ImagesPatchRecommendationSummary.
        Total number of images.


        :return: The total_images_count of this ImagesPatchRecommendationSummary.
        :rtype: int
        """
        return self._total_images_count

    @total_images_count.setter
    def total_images_count(self, total_images_count):
        """
        Sets the total_images_count of this ImagesPatchRecommendationSummary.
        Total number of images.


        :param total_images_count: The total_images_count of this ImagesPatchRecommendationSummary.
        :type: int
        """
        self._total_images_count = total_images_count

    @property
    def up_to_date_images_count(self):
        """
        Gets the up_to_date_images_count of this ImagesPatchRecommendationSummary.
        Total number of up to date images.


        :return: The up_to_date_images_count of this ImagesPatchRecommendationSummary.
        :rtype: int
        """
        return self._up_to_date_images_count

    @up_to_date_images_count.setter
    def up_to_date_images_count(self, up_to_date_images_count):
        """
        Sets the up_to_date_images_count of this ImagesPatchRecommendationSummary.
        Total number of up to date images.


        :param up_to_date_images_count: The up_to_date_images_count of this ImagesPatchRecommendationSummary.
        :type: int
        """
        self._up_to_date_images_count = up_to_date_images_count

    @property
    def image_patch_recommendations_count(self):
        """
        Gets the image_patch_recommendations_count of this ImagesPatchRecommendationSummary.
        Total number of patch recommendations available.


        :return: The image_patch_recommendations_count of this ImagesPatchRecommendationSummary.
        :rtype: int
        """
        return self._image_patch_recommendations_count

    @image_patch_recommendations_count.setter
    def image_patch_recommendations_count(self, image_patch_recommendations_count):
        """
        Sets the image_patch_recommendations_count of this ImagesPatchRecommendationSummary.
        Total number of patch recommendations available.


        :param image_patch_recommendations_count: The image_patch_recommendations_count of this ImagesPatchRecommendationSummary.
        :type: int
        """
        self._image_patch_recommendations_count = image_patch_recommendations_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
