# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240102


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabasesSummary(object):
    """
    Summary of a databases.
    """

    #: A constant which can be used with the database_type property of a DatabasesSummary.
    #: This constant has a value of "SI"
    DATABASE_TYPE_SI = "SI"

    #: A constant which can be used with the database_type property of a DatabasesSummary.
    #: This constant has a value of "RAC"
    DATABASE_TYPE_RAC = "RAC"

    #: A constant which can be used with the lifecycle_state property of a DatabasesSummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a DatabasesSummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a DatabasesSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a DatabasesSummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a DatabasesSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a DatabasesSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new DatabasesSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param database_id:
            The value to assign to the database_id property of this DatabasesSummary.
        :type database_id: str

        :param database_name:
            The value to assign to the database_name property of this DatabasesSummary.
        :type database_name: str

        :param database_type:
            The value to assign to the database_type property of this DatabasesSummary.
            Allowed values for this property are: "SI", "RAC", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type database_type: str

        :param release:
            The value to assign to the release property of this DatabasesSummary.
        :type release: str

        :param release_full_version:
            The value to assign to the release_full_version property of this DatabasesSummary.
        :type release_full_version: str

        :param oracle_home_path:
            The value to assign to the oracle_home_path property of this DatabasesSummary.
        :type oracle_home_path: str

        :param current_patch_watermark:
            The value to assign to the current_patch_watermark property of this DatabasesSummary.
        :type current_patch_watermark: str

        :param host_or_cluster:
            The value to assign to the host_or_cluster property of this DatabasesSummary.
        :type host_or_cluster: str

        :param image_details:
            The value to assign to the image_details property of this DatabasesSummary.
        :type image_details: oci.dblm.models.ImageDetails

        :param patch_compliance_details:
            The value to assign to the patch_compliance_details property of this DatabasesSummary.
        :type patch_compliance_details: oci.dblm.models.PatchComplianceDetails

        :param patch_activity_details:
            The value to assign to the patch_activity_details property of this DatabasesSummary.
        :type patch_activity_details: oci.dblm.models.PatchActivityDetails

        :param patch_user:
            The value to assign to the patch_user property of this DatabasesSummary.
        :type patch_user: str

        :param sudo_file_path:
            The value to assign to the sudo_file_path property of this DatabasesSummary.
        :type sudo_file_path: str

        :param additional_patches:
            The value to assign to the additional_patches property of this DatabasesSummary.
        :type additional_patches: list[oci.dblm.models.AdditionalPatches]

        :param vulnerabilities_summary:
            The value to assign to the vulnerabilities_summary property of this DatabasesSummary.
        :type vulnerabilities_summary: object

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this DatabasesSummary.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this DatabasesSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this DatabasesSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this DatabasesSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'database_id': 'str',
            'database_name': 'str',
            'database_type': 'str',
            'release': 'str',
            'release_full_version': 'str',
            'oracle_home_path': 'str',
            'current_patch_watermark': 'str',
            'host_or_cluster': 'str',
            'image_details': 'ImageDetails',
            'patch_compliance_details': 'PatchComplianceDetails',
            'patch_activity_details': 'PatchActivityDetails',
            'patch_user': 'str',
            'sudo_file_path': 'str',
            'additional_patches': 'list[AdditionalPatches]',
            'vulnerabilities_summary': 'object',
            'lifecycle_state': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'database_id': 'databaseId',
            'database_name': 'databaseName',
            'database_type': 'databaseType',
            'release': 'release',
            'release_full_version': 'releaseFullVersion',
            'oracle_home_path': 'oracleHomePath',
            'current_patch_watermark': 'currentPatchWatermark',
            'host_or_cluster': 'hostOrCluster',
            'image_details': 'imageDetails',
            'patch_compliance_details': 'patchComplianceDetails',
            'patch_activity_details': 'patchActivityDetails',
            'patch_user': 'patchUser',
            'sudo_file_path': 'sudoFilePath',
            'additional_patches': 'additionalPatches',
            'vulnerabilities_summary': 'vulnerabilitiesSummary',
            'lifecycle_state': 'lifecycleState',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._database_id = None
        self._database_name = None
        self._database_type = None
        self._release = None
        self._release_full_version = None
        self._oracle_home_path = None
        self._current_patch_watermark = None
        self._host_or_cluster = None
        self._image_details = None
        self._patch_compliance_details = None
        self._patch_activity_details = None
        self._patch_user = None
        self._sudo_file_path = None
        self._additional_patches = None
        self._vulnerabilities_summary = None
        self._lifecycle_state = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def database_id(self):
        """
        **[Required]** Gets the database_id of this DatabasesSummary.
        Database ocid.


        :return: The database_id of this DatabasesSummary.
        :rtype: str
        """
        return self._database_id

    @database_id.setter
    def database_id(self, database_id):
        """
        Sets the database_id of this DatabasesSummary.
        Database ocid.


        :param database_id: The database_id of this DatabasesSummary.
        :type: str
        """
        self._database_id = database_id

    @property
    def database_name(self):
        """
        Gets the database_name of this DatabasesSummary.
        Database name.


        :return: The database_name of this DatabasesSummary.
        :rtype: str
        """
        return self._database_name

    @database_name.setter
    def database_name(self, database_name):
        """
        Sets the database_name of this DatabasesSummary.
        Database name.


        :param database_name: The database_name of this DatabasesSummary.
        :type: str
        """
        self._database_name = database_name

    @property
    def database_type(self):
        """
        Gets the database_type of this DatabasesSummary.
        Database type.

        Allowed values for this property are: "SI", "RAC", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The database_type of this DatabasesSummary.
        :rtype: str
        """
        return self._database_type

    @database_type.setter
    def database_type(self, database_type):
        """
        Sets the database_type of this DatabasesSummary.
        Database type.


        :param database_type: The database_type of this DatabasesSummary.
        :type: str
        """
        allowed_values = ["SI", "RAC"]
        if not value_allowed_none_or_none_sentinel(database_type, allowed_values):
            database_type = 'UNKNOWN_ENUM_VALUE'
        self._database_type = database_type

    @property
    def release(self):
        """
        Gets the release of this DatabasesSummary.
        Database release.


        :return: The release of this DatabasesSummary.
        :rtype: str
        """
        return self._release

    @release.setter
    def release(self, release):
        """
        Sets the release of this DatabasesSummary.
        Database release.


        :param release: The release of this DatabasesSummary.
        :type: str
        """
        self._release = release

    @property
    def release_full_version(self):
        """
        Gets the release_full_version of this DatabasesSummary.
        Database release full version.


        :return: The release_full_version of this DatabasesSummary.
        :rtype: str
        """
        return self._release_full_version

    @release_full_version.setter
    def release_full_version(self, release_full_version):
        """
        Sets the release_full_version of this DatabasesSummary.
        Database release full version.


        :param release_full_version: The release_full_version of this DatabasesSummary.
        :type: str
        """
        self._release_full_version = release_full_version

    @property
    def oracle_home_path(self):
        """
        Gets the oracle_home_path of this DatabasesSummary.
        Path to the Oracle home.


        :return: The oracle_home_path of this DatabasesSummary.
        :rtype: str
        """
        return self._oracle_home_path

    @oracle_home_path.setter
    def oracle_home_path(self, oracle_home_path):
        """
        Sets the oracle_home_path of this DatabasesSummary.
        Path to the Oracle home.


        :param oracle_home_path: The oracle_home_path of this DatabasesSummary.
        :type: str
        """
        self._oracle_home_path = oracle_home_path

    @property
    def current_patch_watermark(self):
        """
        Gets the current_patch_watermark of this DatabasesSummary.
        This is the hashcode representing the list of patches applied.


        :return: The current_patch_watermark of this DatabasesSummary.
        :rtype: str
        """
        return self._current_patch_watermark

    @current_patch_watermark.setter
    def current_patch_watermark(self, current_patch_watermark):
        """
        Sets the current_patch_watermark of this DatabasesSummary.
        This is the hashcode representing the list of patches applied.


        :param current_patch_watermark: The current_patch_watermark of this DatabasesSummary.
        :type: str
        """
        self._current_patch_watermark = current_patch_watermark

    @property
    def host_or_cluster(self):
        """
        Gets the host_or_cluster of this DatabasesSummary.
        For SI, hosted on host and for RAC, host on cluster.


        :return: The host_or_cluster of this DatabasesSummary.
        :rtype: str
        """
        return self._host_or_cluster

    @host_or_cluster.setter
    def host_or_cluster(self, host_or_cluster):
        """
        Sets the host_or_cluster of this DatabasesSummary.
        For SI, hosted on host and for RAC, host on cluster.


        :param host_or_cluster: The host_or_cluster of this DatabasesSummary.
        :type: str
        """
        self._host_or_cluster = host_or_cluster

    @property
    def image_details(self):
        """
        **[Required]** Gets the image_details of this DatabasesSummary.

        :return: The image_details of this DatabasesSummary.
        :rtype: oci.dblm.models.ImageDetails
        """
        return self._image_details

    @image_details.setter
    def image_details(self, image_details):
        """
        Sets the image_details of this DatabasesSummary.

        :param image_details: The image_details of this DatabasesSummary.
        :type: oci.dblm.models.ImageDetails
        """
        self._image_details = image_details

    @property
    def patch_compliance_details(self):
        """
        **[Required]** Gets the patch_compliance_details of this DatabasesSummary.

        :return: The patch_compliance_details of this DatabasesSummary.
        :rtype: oci.dblm.models.PatchComplianceDetails
        """
        return self._patch_compliance_details

    @patch_compliance_details.setter
    def patch_compliance_details(self, patch_compliance_details):
        """
        Sets the patch_compliance_details of this DatabasesSummary.

        :param patch_compliance_details: The patch_compliance_details of this DatabasesSummary.
        :type: oci.dblm.models.PatchComplianceDetails
        """
        self._patch_compliance_details = patch_compliance_details

    @property
    def patch_activity_details(self):
        """
        **[Required]** Gets the patch_activity_details of this DatabasesSummary.

        :return: The patch_activity_details of this DatabasesSummary.
        :rtype: oci.dblm.models.PatchActivityDetails
        """
        return self._patch_activity_details

    @patch_activity_details.setter
    def patch_activity_details(self, patch_activity_details):
        """
        Sets the patch_activity_details of this DatabasesSummary.

        :param patch_activity_details: The patch_activity_details of this DatabasesSummary.
        :type: oci.dblm.models.PatchActivityDetails
        """
        self._patch_activity_details = patch_activity_details

    @property
    def patch_user(self):
        """
        Gets the patch_user of this DatabasesSummary.
        Intermediate user to be used for patching, created and maintained by customers. This user requires sudo access to switch as Oracle home owner and root user


        :return: The patch_user of this DatabasesSummary.
        :rtype: str
        """
        return self._patch_user

    @patch_user.setter
    def patch_user(self, patch_user):
        """
        Sets the patch_user of this DatabasesSummary.
        Intermediate user to be used for patching, created and maintained by customers. This user requires sudo access to switch as Oracle home owner and root user


        :param patch_user: The patch_user of this DatabasesSummary.
        :type: str
        """
        self._patch_user = patch_user

    @property
    def sudo_file_path(self):
        """
        Gets the sudo_file_path of this DatabasesSummary.
        Path to sudo binary (executable) file


        :return: The sudo_file_path of this DatabasesSummary.
        :rtype: str
        """
        return self._sudo_file_path

    @sudo_file_path.setter
    def sudo_file_path(self, sudo_file_path):
        """
        Sets the sudo_file_path of this DatabasesSummary.
        Path to sudo binary (executable) file


        :param sudo_file_path: The sudo_file_path of this DatabasesSummary.
        :type: str
        """
        self._sudo_file_path = sudo_file_path

    @property
    def additional_patches(self):
        """
        Gets the additional_patches of this DatabasesSummary.
        List of additional patches on database.


        :return: The additional_patches of this DatabasesSummary.
        :rtype: list[oci.dblm.models.AdditionalPatches]
        """
        return self._additional_patches

    @additional_patches.setter
    def additional_patches(self, additional_patches):
        """
        Sets the additional_patches of this DatabasesSummary.
        List of additional patches on database.


        :param additional_patches: The additional_patches of this DatabasesSummary.
        :type: list[oci.dblm.models.AdditionalPatches]
        """
        self._additional_patches = additional_patches

    @property
    def vulnerabilities_summary(self):
        """
        Gets the vulnerabilities_summary of this DatabasesSummary.
        Summary of vulnerabilities found in registered resources grouped by severity.


        :return: The vulnerabilities_summary of this DatabasesSummary.
        :rtype: object
        """
        return self._vulnerabilities_summary

    @vulnerabilities_summary.setter
    def vulnerabilities_summary(self, vulnerabilities_summary):
        """
        Sets the vulnerabilities_summary of this DatabasesSummary.
        Summary of vulnerabilities found in registered resources grouped by severity.


        :param vulnerabilities_summary: The vulnerabilities_summary of this DatabasesSummary.
        :type: object
        """
        self._vulnerabilities_summary = vulnerabilities_summary

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this DatabasesSummary.
        The current state of the database.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this DatabasesSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this DatabasesSummary.
        The current state of the database.


        :param lifecycle_state: The lifecycle_state of this DatabasesSummary.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def freeform_tags(self):
        """
        **[Required]** Gets the freeform_tags of this DatabasesSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this DatabasesSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this DatabasesSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this DatabasesSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        **[Required]** Gets the defined_tags of this DatabasesSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this DatabasesSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this DatabasesSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this DatabasesSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this DatabasesSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this DatabasesSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this DatabasesSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this DatabasesSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
