# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CloudAsmConnectionCredentials(object):
    """
    The credentials used to connect to the Cloud ASM instance. Currently only the `DETAILS` type
    is supported for creating MACS connector credentials.
    """

    #: A constant which can be used with the credential_type property of a CloudAsmConnectionCredentials.
    #: This constant has a value of "NAME_REFERENCE"
    CREDENTIAL_TYPE_NAME_REFERENCE = "NAME_REFERENCE"

    #: A constant which can be used with the credential_type property of a CloudAsmConnectionCredentials.
    #: This constant has a value of "DETAILS"
    CREDENTIAL_TYPE_DETAILS = "DETAILS"

    def __init__(self, **kwargs):
        """
        Initializes a new CloudAsmConnectionCredentials object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.database_management.models.CloudAsmConnectionCredentialsByDetails`
        * :class:`~oci.database_management.models.CloudAsmConnectionCredentialsByName`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param credential_type:
            The value to assign to the credential_type property of this CloudAsmConnectionCredentials.
            Allowed values for this property are: "NAME_REFERENCE", "DETAILS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type credential_type: str

        """
        self.swagger_types = {
            'credential_type': 'str'
        }
        self.attribute_map = {
            'credential_type': 'credentialType'
        }
        self._credential_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['credentialType']

        if type == 'DETAILS':
            return 'CloudAsmConnectionCredentialsByDetails'

        if type == 'NAME_REFERENCE':
            return 'CloudAsmConnectionCredentialsByName'
        else:
            return 'CloudAsmConnectionCredentials'

    @property
    def credential_type(self):
        """
        Gets the credential_type of this CloudAsmConnectionCredentials.
        The type of credential used to connect to the ASM instance.

        Allowed values for this property are: "NAME_REFERENCE", "DETAILS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The credential_type of this CloudAsmConnectionCredentials.
        :rtype: str
        """
        return self._credential_type

    @credential_type.setter
    def credential_type(self, credential_type):
        """
        Sets the credential_type of this CloudAsmConnectionCredentials.
        The type of credential used to connect to the ASM instance.


        :param credential_type: The credential_type of this CloudAsmConnectionCredentials.
        :type: str
        """
        allowed_values = ["NAME_REFERENCE", "DETAILS"]
        if not value_allowed_none_or_none_sentinel(credential_type, allowed_values):
            credential_type = 'UNKNOWN_ENUM_VALUE'
        self._credential_type = credential_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
