# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ResourcePoolSummary(object):
    """
    The configuration details for resource pool
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ResourcePoolSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param pool_size:
            The value to assign to the pool_size property of this ResourcePoolSummary.
        :type pool_size: int

        :param total_compute_capacity:
            The value to assign to the total_compute_capacity property of this ResourcePoolSummary.
        :type total_compute_capacity: int

        :param available_compute_capacity:
            The value to assign to the available_compute_capacity property of this ResourcePoolSummary.
        :type available_compute_capacity: int

        :param is_disabled:
            The value to assign to the is_disabled property of this ResourcePoolSummary.
        :type is_disabled: bool

        """
        self.swagger_types = {
            'pool_size': 'int',
            'total_compute_capacity': 'int',
            'available_compute_capacity': 'int',
            'is_disabled': 'bool'
        }
        self.attribute_map = {
            'pool_size': 'poolSize',
            'total_compute_capacity': 'totalComputeCapacity',
            'available_compute_capacity': 'availableComputeCapacity',
            'is_disabled': 'isDisabled'
        }
        self._pool_size = None
        self._total_compute_capacity = None
        self._available_compute_capacity = None
        self._is_disabled = None

    @property
    def pool_size(self):
        """
        Gets the pool_size of this ResourcePoolSummary.
        Resource pool size.


        :return: The pool_size of this ResourcePoolSummary.
        :rtype: int
        """
        return self._pool_size

    @pool_size.setter
    def pool_size(self, pool_size):
        """
        Sets the pool_size of this ResourcePoolSummary.
        Resource pool size.


        :param pool_size: The pool_size of this ResourcePoolSummary.
        :type: int
        """
        self._pool_size = pool_size

    @property
    def total_compute_capacity(self):
        """
        Gets the total_compute_capacity of this ResourcePoolSummary.
        Resource Pool total capacity, it's currently 4x of pool size


        :return: The total_compute_capacity of this ResourcePoolSummary.
        :rtype: int
        """
        return self._total_compute_capacity

    @total_compute_capacity.setter
    def total_compute_capacity(self, total_compute_capacity):
        """
        Sets the total_compute_capacity of this ResourcePoolSummary.
        Resource Pool total capacity, it's currently 4x of pool size


        :param total_compute_capacity: The total_compute_capacity of this ResourcePoolSummary.
        :type: int
        """
        self._total_compute_capacity = total_compute_capacity

    @property
    def available_compute_capacity(self):
        """
        Gets the available_compute_capacity of this ResourcePoolSummary.
        Available capacity left for new elastic pool members provision


        :return: The available_compute_capacity of this ResourcePoolSummary.
        :rtype: int
        """
        return self._available_compute_capacity

    @available_compute_capacity.setter
    def available_compute_capacity(self, available_compute_capacity):
        """
        Sets the available_compute_capacity of this ResourcePoolSummary.
        Available capacity left for new elastic pool members provision


        :param available_compute_capacity: The available_compute_capacity of this ResourcePoolSummary.
        :type: int
        """
        self._available_compute_capacity = available_compute_capacity

    @property
    def is_disabled(self):
        """
        Gets the is_disabled of this ResourcePoolSummary.
        Indicates if the resource pool should be deleted for the Autonomous AI Database.


        :return: The is_disabled of this ResourcePoolSummary.
        :rtype: bool
        """
        return self._is_disabled

    @is_disabled.setter
    def is_disabled(self, is_disabled):
        """
        Sets the is_disabled of this ResourcePoolSummary.
        Indicates if the resource pool should be deleted for the Autonomous AI Database.


        :param is_disabled: The is_disabled of this ResourcePoolSummary.
        :type: bool
        """
        self._is_disabled = is_disabled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
