# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PluggableDatabaseSnapshot(object):
    """
    Details of the Pluggable Database Snapshot.
    """

    #: A constant which can be used with the lifecycle_state property of a PluggableDatabaseSnapshot.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a PluggableDatabaseSnapshot.
    #: This constant has a value of "AVAILABLE"
    LIFECYCLE_STATE_AVAILABLE = "AVAILABLE"

    #: A constant which can be used with the lifecycle_state property of a PluggableDatabaseSnapshot.
    #: This constant has a value of "TERMINATING"
    LIFECYCLE_STATE_TERMINATING = "TERMINATING"

    #: A constant which can be used with the lifecycle_state property of a PluggableDatabaseSnapshot.
    #: This constant has a value of "TERMINATED"
    LIFECYCLE_STATE_TERMINATED = "TERMINATED"

    #: A constant which can be used with the lifecycle_state property of a PluggableDatabaseSnapshot.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new PluggableDatabaseSnapshot object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this PluggableDatabaseSnapshot.
        :type id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this PluggableDatabaseSnapshot.
            Allowed values for this property are: "CREATING", "AVAILABLE", "TERMINATING", "TERMINATED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param name:
            The value to assign to the name property of this PluggableDatabaseSnapshot.
        :type name: str

        :param pluggable_database_id:
            The value to assign to the pluggable_database_id property of this PluggableDatabaseSnapshot.
        :type pluggable_database_id: str

        :param time_created:
            The value to assign to the time_created property of this PluggableDatabaseSnapshot.
        :type time_created: datetime

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this PluggableDatabaseSnapshot.
        :type lifecycle_details: str

        :param freeform_tags:
            The value to assign to the freeform_tags property of this PluggableDatabaseSnapshot.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this PluggableDatabaseSnapshot.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this PluggableDatabaseSnapshot.
        :type system_tags: dict(str, dict(str, object))

        :param compartment_id:
            The value to assign to the compartment_id property of this PluggableDatabaseSnapshot.
        :type compartment_id: str

        :param cluster_id:
            The value to assign to the cluster_id property of this PluggableDatabaseSnapshot.
        :type cluster_id: str

        """
        self.swagger_types = {
            'id': 'str',
            'lifecycle_state': 'str',
            'name': 'str',
            'pluggable_database_id': 'str',
            'time_created': 'datetime',
            'lifecycle_details': 'str',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))',
            'compartment_id': 'str',
            'cluster_id': 'str'
        }
        self.attribute_map = {
            'id': 'id',
            'lifecycle_state': 'lifecycleState',
            'name': 'name',
            'pluggable_database_id': 'pluggableDatabaseId',
            'time_created': 'timeCreated',
            'lifecycle_details': 'lifecycleDetails',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags',
            'compartment_id': 'compartmentId',
            'cluster_id': 'clusterId'
        }
        self._id = None
        self._lifecycle_state = None
        self._name = None
        self._pluggable_database_id = None
        self._time_created = None
        self._lifecycle_details = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None
        self._compartment_id = None
        self._cluster_id = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this PluggableDatabaseSnapshot.
        The `OCID`__ of the Exadata Pluggable Database Snapshot.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The id of this PluggableDatabaseSnapshot.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PluggableDatabaseSnapshot.
        The `OCID`__ of the Exadata Pluggable Database Snapshot.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param id: The id of this PluggableDatabaseSnapshot.
        :type: str
        """
        self._id = id

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this PluggableDatabaseSnapshot.
        The current state of the Exadata Pluggable Database Snapshot.

        Allowed values for this property are: "CREATING", "AVAILABLE", "TERMINATING", "TERMINATED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this PluggableDatabaseSnapshot.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this PluggableDatabaseSnapshot.
        The current state of the Exadata Pluggable Database Snapshot.


        :param lifecycle_state: The lifecycle_state of this PluggableDatabaseSnapshot.
        :type: str
        """
        allowed_values = ["CREATING", "AVAILABLE", "TERMINATING", "TERMINATED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def name(self):
        """
        **[Required]** Gets the name of this PluggableDatabaseSnapshot.
        The user-friendly name for the Database Snapshot. The name should be unique.


        :return: The name of this PluggableDatabaseSnapshot.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this PluggableDatabaseSnapshot.
        The user-friendly name for the Database Snapshot. The name should be unique.


        :param name: The name of this PluggableDatabaseSnapshot.
        :type: str
        """
        self._name = name

    @property
    def pluggable_database_id(self):
        """
        **[Required]** Gets the pluggable_database_id of this PluggableDatabaseSnapshot.
        The `OCID`__ of the Exadata Pluggable Database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The pluggable_database_id of this PluggableDatabaseSnapshot.
        :rtype: str
        """
        return self._pluggable_database_id

    @pluggable_database_id.setter
    def pluggable_database_id(self, pluggable_database_id):
        """
        Sets the pluggable_database_id of this PluggableDatabaseSnapshot.
        The `OCID`__ of the Exadata Pluggable Database.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param pluggable_database_id: The pluggable_database_id of this PluggableDatabaseSnapshot.
        :type: str
        """
        self._pluggable_database_id = pluggable_database_id

    @property
    def time_created(self):
        """
        Gets the time_created of this PluggableDatabaseSnapshot.
        The date and time that the Exadata Pluggable Database Snapshot was created, as expressed in RFC 3339 format. For example: 2023-06-27T21:10:29Z


        :return: The time_created of this PluggableDatabaseSnapshot.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this PluggableDatabaseSnapshot.
        The date and time that the Exadata Pluggable Database Snapshot was created, as expressed in RFC 3339 format. For example: 2023-06-27T21:10:29Z


        :param time_created: The time_created of this PluggableDatabaseSnapshot.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this PluggableDatabaseSnapshot.
        Additional information about the current lifecycle state of the Exadata Pluggable Database Snapshot.


        :return: The lifecycle_details of this PluggableDatabaseSnapshot.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this PluggableDatabaseSnapshot.
        Additional information about the current lifecycle state of the Exadata Pluggable Database Snapshot.


        :param lifecycle_details: The lifecycle_details of this PluggableDatabaseSnapshot.
        :type: str
        """
        self._lifecycle_details = lifecycle_details

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this PluggableDatabaseSnapshot.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this PluggableDatabaseSnapshot.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this PluggableDatabaseSnapshot.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this PluggableDatabaseSnapshot.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this PluggableDatabaseSnapshot.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this PluggableDatabaseSnapshot.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this PluggableDatabaseSnapshot.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this PluggableDatabaseSnapshot.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this PluggableDatabaseSnapshot.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :return: The system_tags of this PluggableDatabaseSnapshot.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this PluggableDatabaseSnapshot.
        System tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/resourcetags.htm


        :param system_tags: The system_tags of this PluggableDatabaseSnapshot.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this PluggableDatabaseSnapshot.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this PluggableDatabaseSnapshot.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this PluggableDatabaseSnapshot.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this PluggableDatabaseSnapshot.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def cluster_id(self):
        """
        Gets the cluster_id of this PluggableDatabaseSnapshot.
        The `OCID`__ of the VM cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The cluster_id of this PluggableDatabaseSnapshot.
        :rtype: str
        """
        return self._cluster_id

    @cluster_id.setter
    def cluster_id(self, cluster_id):
        """
        Sets the cluster_id of this PluggableDatabaseSnapshot.
        The `OCID`__ of the VM cluster.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param cluster_id: The cluster_id of this PluggableDatabaseSnapshot.
        :type: str
        """
        self._cluster_id = cluster_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
