# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20221208


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UpdateCccUpgradeScheduleDetails(object):
    """
    Updates the schedule details, all schedule information must be entered, similar to an
    initial schedule create. Include all events in the update.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UpdateCccUpgradeScheduleDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this UpdateCccUpgradeScheduleDetails.
        :type display_name: str

        :param description:
            The value to assign to the description property of this UpdateCccUpgradeScheduleDetails.
        :type description: str

        :param events:
            The value to assign to the events property of this UpdateCccUpgradeScheduleDetails.
        :type events: list[oci.compute_cloud_at_customer.models.UpdateCccScheduleEvent]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this UpdateCccUpgradeScheduleDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this UpdateCccUpgradeScheduleDetails.
        :type defined_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'display_name': 'str',
            'description': 'str',
            'events': 'list[UpdateCccScheduleEvent]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'description': 'description',
            'events': 'events',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags'
        }
        self._display_name = None
        self._description = None
        self._events = None
        self._freeform_tags = None
        self._defined_tags = None

    @property
    def display_name(self):
        """
        Gets the display_name of this UpdateCccUpgradeScheduleDetails.
        Compute Cloud@Customer upgrade schedule display name.
        Avoid entering confidential information.


        :return: The display_name of this UpdateCccUpgradeScheduleDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this UpdateCccUpgradeScheduleDetails.
        Compute Cloud@Customer upgrade schedule display name.
        Avoid entering confidential information.


        :param display_name: The display_name of this UpdateCccUpgradeScheduleDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def description(self):
        """
        Gets the description of this UpdateCccUpgradeScheduleDetails.
        An optional description of the Compute Cloud@Customer upgrade schedule.
        Avoid entering confidential information.


        :return: The description of this UpdateCccUpgradeScheduleDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this UpdateCccUpgradeScheduleDetails.
        An optional description of the Compute Cloud@Customer upgrade schedule.
        Avoid entering confidential information.


        :param description: The description of this UpdateCccUpgradeScheduleDetails.
        :type: str
        """
        self._description = description

    @property
    def events(self):
        """
        Gets the events of this UpdateCccUpgradeScheduleDetails.
        List of preferred times for a Compute Cloud@Customer infrastructure to be upgraded.


        :return: The events of this UpdateCccUpgradeScheduleDetails.
        :rtype: list[oci.compute_cloud_at_customer.models.UpdateCccScheduleEvent]
        """
        return self._events

    @events.setter
    def events(self, events):
        """
        Sets the events of this UpdateCccUpgradeScheduleDetails.
        List of preferred times for a Compute Cloud@Customer infrastructure to be upgraded.


        :param events: The events of this UpdateCccUpgradeScheduleDetails.
        :type: list[oci.compute_cloud_at_customer.models.UpdateCccScheduleEvent]
        """
        self._events = events

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this UpdateCccUpgradeScheduleDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this UpdateCccUpgradeScheduleDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this UpdateCccUpgradeScheduleDetails.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this UpdateCccUpgradeScheduleDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this UpdateCccUpgradeScheduleDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this UpdateCccUpgradeScheduleDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this UpdateCccUpgradeScheduleDetails.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this UpdateCccUpgradeScheduleDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
