# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220315


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AttachedOciCacheCluster(object):
    """
    OciCacheCluster to which the OciCacheUser is attached.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AttachedOciCacheCluster object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param oci_cache_cluster_id:
            The value to assign to the oci_cache_cluster_id property of this AttachedOciCacheCluster.
        :type oci_cache_cluster_id: str

        """
        self.swagger_types = {
            'oci_cache_cluster_id': 'str'
        }
        self.attribute_map = {
            'oci_cache_cluster_id': 'ociCacheClusterId'
        }
        self._oci_cache_cluster_id = None

    @property
    def oci_cache_cluster_id(self):
        """
        **[Required]** Gets the oci_cache_cluster_id of this AttachedOciCacheCluster.
        OCID of the OciCacheCluster


        :return: The oci_cache_cluster_id of this AttachedOciCacheCluster.
        :rtype: str
        """
        return self._oci_cache_cluster_id

    @oci_cache_cluster_id.setter
    def oci_cache_cluster_id(self, oci_cache_cluster_id):
        """
        Sets the oci_cache_cluster_id of this AttachedOciCacheCluster.
        OCID of the OciCacheCluster


        :param oci_cache_cluster_id: The oci_cache_cluster_id of this AttachedOciCacheCluster.
        :type: str
        """
        self._oci_cache_cluster_id = oci_cache_cluster_id

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
