# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VxlanInspectionRuleProfile(object):
    """
    Vxlan Inspect profile used in Vxlan Tunnel Inspection Rules.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VxlanInspectionRuleProfile object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param must_return_traffic_to_source:
            The value to assign to the must_return_traffic_to_source property of this VxlanInspectionRuleProfile.
        :type must_return_traffic_to_source: bool

        """
        self.swagger_types = {
            'must_return_traffic_to_source': 'bool'
        }
        self.attribute_map = {
            'must_return_traffic_to_source': 'mustReturnTrafficToSource'
        }
        self._must_return_traffic_to_source = None

    @property
    def must_return_traffic_to_source(self):
        """
        Gets the must_return_traffic_to_source of this VxlanInspectionRuleProfile.
        Return scanned VXLAN tunnel traffic to source.


        :return: The must_return_traffic_to_source of this VxlanInspectionRuleProfile.
        :rtype: bool
        """
        return self._must_return_traffic_to_source

    @must_return_traffic_to_source.setter
    def must_return_traffic_to_source(self, must_return_traffic_to_source):
        """
        Sets the must_return_traffic_to_source of this VxlanInspectionRuleProfile.
        Return scanned VXLAN tunnel traffic to source.


        :param must_return_traffic_to_source: The must_return_traffic_to_source of this VxlanInspectionRuleProfile.
        :type: bool
        """
        self._must_return_traffic_to_source = must_return_traffic_to_source

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
