# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200601


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CredentialEndpoint(object):
    """
    The endpoint from where to fetch a credential, for example, the OAuth 2.0 token.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CredentialEndpoint object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param name:
            The value to assign to the name property of this CredentialEndpoint.
        :type name: str

        :param description:
            The value to assign to the description property of this CredentialEndpoint.
        :type description: str

        :param model:
            The value to assign to the model property of this CredentialEndpoint.
        :type model: str

        :param endpoint_id:
            The value to assign to the endpoint_id property of this CredentialEndpoint.
        :type endpoint_id: int

        :param request:
            The value to assign to the request property of this CredentialEndpoint.
        :type request: oci.log_analytics.models.EndpointRequest

        :param response:
            The value to assign to the response property of this CredentialEndpoint.
        :type response: oci.log_analytics.models.EndpointResponse

        :param proxy:
            The value to assign to the proxy property of this CredentialEndpoint.
        :type proxy: oci.log_analytics.models.EndpointProxy

        """
        self.swagger_types = {
            'name': 'str',
            'description': 'str',
            'model': 'str',
            'endpoint_id': 'int',
            'request': 'EndpointRequest',
            'response': 'EndpointResponse',
            'proxy': 'EndpointProxy'
        }
        self.attribute_map = {
            'name': 'name',
            'description': 'description',
            'model': 'model',
            'endpoint_id': 'endpointId',
            'request': 'request',
            'response': 'response',
            'proxy': 'proxy'
        }
        self._name = None
        self._description = None
        self._model = None
        self._endpoint_id = None
        self._request = None
        self._response = None
        self._proxy = None

    @property
    def name(self):
        """
        **[Required]** Gets the name of this CredentialEndpoint.
        The credential endpoint name.


        :return: The name of this CredentialEndpoint.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this CredentialEndpoint.
        The credential endpoint name.


        :param name: The name of this CredentialEndpoint.
        :type: str
        """
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this CredentialEndpoint.
        The credential endpoint description.


        :return: The description of this CredentialEndpoint.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CredentialEndpoint.
        The credential endpoint description.


        :param description: The description of this CredentialEndpoint.
        :type: str
        """
        self._description = description

    @property
    def model(self):
        """
        Gets the model of this CredentialEndpoint.
        The credential endpoint model.


        :return: The model of this CredentialEndpoint.
        :rtype: str
        """
        return self._model

    @model.setter
    def model(self, model):
        """
        Sets the model of this CredentialEndpoint.
        The credential endpoint model.


        :param model: The model of this CredentialEndpoint.
        :type: str
        """
        self._model = model

    @property
    def endpoint_id(self):
        """
        Gets the endpoint_id of this CredentialEndpoint.
        The endpoint unique identifier.


        :return: The endpoint_id of this CredentialEndpoint.
        :rtype: int
        """
        return self._endpoint_id

    @endpoint_id.setter
    def endpoint_id(self, endpoint_id):
        """
        Sets the endpoint_id of this CredentialEndpoint.
        The endpoint unique identifier.


        :param endpoint_id: The endpoint_id of this CredentialEndpoint.
        :type: int
        """
        self._endpoint_id = endpoint_id

    @property
    def request(self):
        """
        **[Required]** Gets the request of this CredentialEndpoint.

        :return: The request of this CredentialEndpoint.
        :rtype: oci.log_analytics.models.EndpointRequest
        """
        return self._request

    @request.setter
    def request(self, request):
        """
        Sets the request of this CredentialEndpoint.

        :param request: The request of this CredentialEndpoint.
        :type: oci.log_analytics.models.EndpointRequest
        """
        self._request = request

    @property
    def response(self):
        """
        Gets the response of this CredentialEndpoint.

        :return: The response of this CredentialEndpoint.
        :rtype: oci.log_analytics.models.EndpointResponse
        """
        return self._response

    @response.setter
    def response(self, response):
        """
        Sets the response of this CredentialEndpoint.

        :param response: The response of this CredentialEndpoint.
        :type: oci.log_analytics.models.EndpointResponse
        """
        self._response = response

    @property
    def proxy(self):
        """
        Gets the proxy of this CredentialEndpoint.

        :return: The proxy of this CredentialEndpoint.
        :rtype: oci.log_analytics.models.EndpointProxy
        """
        return self._proxy

    @proxy.setter
    def proxy(self, proxy):
        """
        Sets the proxy of this CredentialEndpoint.

        :param proxy: The proxy of this CredentialEndpoint.
        :type: oci.log_analytics.models.EndpointProxy
        """
        self._proxy = proxy

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
