# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250521


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PerformanceTuningAnalysis(object):
    """
    To use any of the API operations, you must be authorized by an IAM policy. If you're not authorized, talk to
    an administrator. If you're an administrator who needs to write policies to give users access, see
    `Getting Started with Policies`__.

    __ https://docs.cloud.oracle.com/iaas/Content/Identity/policiesgs/get-started-with-policies.htm
    """

    #: A constant which can be used with the result property of a PerformanceTuningAnalysis.
    #: This constant has a value of "ACTION_RECOMMENDED"
    RESULT_ACTION_RECOMMENDED = "ACTION_RECOMMENDED"

    #: A constant which can be used with the result property of a PerformanceTuningAnalysis.
    #: This constant has a value of "NO_WARNINGS"
    RESULT_NO_WARNINGS = "NO_WARNINGS"

    def __init__(self, **kwargs):
        """
        Initializes a new PerformanceTuningAnalysis object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this PerformanceTuningAnalysis.
        :type id: str

        :param work_request_id:
            The value to assign to the work_request_id property of this PerformanceTuningAnalysis.
        :type work_request_id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this PerformanceTuningAnalysis.
        :type compartment_id: str

        :param analysis_project_name:
            The value to assign to the analysis_project_name property of this PerformanceTuningAnalysis.
        :type analysis_project_name: str

        :param warning_count:
            The value to assign to the warning_count property of this PerformanceTuningAnalysis.
        :type warning_count: int

        :param result:
            The value to assign to the result property of this PerformanceTuningAnalysis.
            Allowed values for this property are: "ACTION_RECOMMENDED", "NO_WARNINGS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type result: str

        :param result_object_storage_path:
            The value to assign to the result_object_storage_path property of this PerformanceTuningAnalysis.
        :type result_object_storage_path: str

        :param artifact_object_storage_path:
            The value to assign to the artifact_object_storage_path property of this PerformanceTuningAnalysis.
        :type artifact_object_storage_path: str

        :param time_created:
            The value to assign to the time_created property of this PerformanceTuningAnalysis.
        :type time_created: datetime

        :param time_started:
            The value to assign to the time_started property of this PerformanceTuningAnalysis.
        :type time_started: datetime

        :param time_finished:
            The value to assign to the time_finished property of this PerformanceTuningAnalysis.
        :type time_finished: datetime

        :param created_by:
            The value to assign to the created_by property of this PerformanceTuningAnalysis.
        :type created_by: oci.jms_utils.models.Principal

        """
        self.swagger_types = {
            'id': 'str',
            'work_request_id': 'str',
            'compartment_id': 'str',
            'analysis_project_name': 'str',
            'warning_count': 'int',
            'result': 'str',
            'result_object_storage_path': 'str',
            'artifact_object_storage_path': 'str',
            'time_created': 'datetime',
            'time_started': 'datetime',
            'time_finished': 'datetime',
            'created_by': 'Principal'
        }
        self.attribute_map = {
            'id': 'id',
            'work_request_id': 'workRequestId',
            'compartment_id': 'compartmentId',
            'analysis_project_name': 'analysisProjectName',
            'warning_count': 'warningCount',
            'result': 'result',
            'result_object_storage_path': 'resultObjectStoragePath',
            'artifact_object_storage_path': 'artifactObjectStoragePath',
            'time_created': 'timeCreated',
            'time_started': 'timeStarted',
            'time_finished': 'timeFinished',
            'created_by': 'createdBy'
        }
        self._id = None
        self._work_request_id = None
        self._compartment_id = None
        self._analysis_project_name = None
        self._warning_count = None
        self._result = None
        self._result_object_storage_path = None
        self._artifact_object_storage_path = None
        self._time_created = None
        self._time_started = None
        self._time_finished = None
        self._created_by = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this PerformanceTuningAnalysis.
        The `OCID`__ of the Performance Tuning Analysis.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this PerformanceTuningAnalysis.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PerformanceTuningAnalysis.
        The `OCID`__ of the Performance Tuning Analysis.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this PerformanceTuningAnalysis.
        :type: str
        """
        self._id = id

    @property
    def work_request_id(self):
        """
        **[Required]** Gets the work_request_id of this PerformanceTuningAnalysis.
        The `OCID`__ of the Work Request.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The work_request_id of this PerformanceTuningAnalysis.
        :rtype: str
        """
        return self._work_request_id

    @work_request_id.setter
    def work_request_id(self, work_request_id):
        """
        Sets the work_request_id of this PerformanceTuningAnalysis.
        The `OCID`__ of the Work Request.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param work_request_id: The work_request_id of this PerformanceTuningAnalysis.
        :type: str
        """
        self._work_request_id = work_request_id

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this PerformanceTuningAnalysis.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this PerformanceTuningAnalysis.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this PerformanceTuningAnalysis.
        The `OCID`__ of the compartment.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this PerformanceTuningAnalysis.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def analysis_project_name(self):
        """
        **[Required]** Gets the analysis_project_name of this PerformanceTuningAnalysis.
        Name of the analysis project.


        :return: The analysis_project_name of this PerformanceTuningAnalysis.
        :rtype: str
        """
        return self._analysis_project_name

    @analysis_project_name.setter
    def analysis_project_name(self, analysis_project_name):
        """
        Sets the analysis_project_name of this PerformanceTuningAnalysis.
        Name of the analysis project.


        :param analysis_project_name: The analysis_project_name of this PerformanceTuningAnalysis.
        :type: str
        """
        self._analysis_project_name = analysis_project_name

    @property
    def warning_count(self):
        """
        **[Required]** Gets the warning_count of this PerformanceTuningAnalysis.
        Number of warnings in the Performance Tuning Analysis.


        :return: The warning_count of this PerformanceTuningAnalysis.
        :rtype: int
        """
        return self._warning_count

    @warning_count.setter
    def warning_count(self, warning_count):
        """
        Sets the warning_count of this PerformanceTuningAnalysis.
        Number of warnings in the Performance Tuning Analysis.


        :param warning_count: The warning_count of this PerformanceTuningAnalysis.
        :type: int
        """
        self._warning_count = warning_count

    @property
    def result(self):
        """
        **[Required]** Gets the result of this PerformanceTuningAnalysis.
        Possible Performance Tuning Result statuses.

        Allowed values for this property are: "ACTION_RECOMMENDED", "NO_WARNINGS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The result of this PerformanceTuningAnalysis.
        :rtype: str
        """
        return self._result

    @result.setter
    def result(self, result):
        """
        Sets the result of this PerformanceTuningAnalysis.
        Possible Performance Tuning Result statuses.


        :param result: The result of this PerformanceTuningAnalysis.
        :type: str
        """
        allowed_values = ["ACTION_RECOMMENDED", "NO_WARNINGS"]
        if not value_allowed_none_or_none_sentinel(result, allowed_values):
            result = 'UNKNOWN_ENUM_VALUE'
        self._result = result

    @property
    def result_object_storage_path(self):
        """
        **[Required]** Gets the result_object_storage_path of this PerformanceTuningAnalysis.
        Object storage path to the analysis.


        :return: The result_object_storage_path of this PerformanceTuningAnalysis.
        :rtype: str
        """
        return self._result_object_storage_path

    @result_object_storage_path.setter
    def result_object_storage_path(self, result_object_storage_path):
        """
        Sets the result_object_storage_path of this PerformanceTuningAnalysis.
        Object storage path to the analysis.


        :param result_object_storage_path: The result_object_storage_path of this PerformanceTuningAnalysis.
        :type: str
        """
        self._result_object_storage_path = result_object_storage_path

    @property
    def artifact_object_storage_path(self):
        """
        **[Required]** Gets the artifact_object_storage_path of this PerformanceTuningAnalysis.
        Object storage path to the artifact.


        :return: The artifact_object_storage_path of this PerformanceTuningAnalysis.
        :rtype: str
        """
        return self._artifact_object_storage_path

    @artifact_object_storage_path.setter
    def artifact_object_storage_path(self, artifact_object_storage_path):
        """
        Sets the artifact_object_storage_path of this PerformanceTuningAnalysis.
        Object storage path to the artifact.


        :param artifact_object_storage_path: The artifact_object_storage_path of this PerformanceTuningAnalysis.
        :type: str
        """
        self._artifact_object_storage_path = artifact_object_storage_path

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this PerformanceTuningAnalysis.
        The date and time the Performance Tuning Analysis was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this PerformanceTuningAnalysis.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this PerformanceTuningAnalysis.
        The date and time the Performance Tuning Analysis was created, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this PerformanceTuningAnalysis.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_started(self):
        """
        **[Required]** Gets the time_started of this PerformanceTuningAnalysis.
        The date and time the Performance Tuning Analysis was started, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_started of this PerformanceTuningAnalysis.
        :rtype: datetime
        """
        return self._time_started

    @time_started.setter
    def time_started(self, time_started):
        """
        Sets the time_started of this PerformanceTuningAnalysis.
        The date and time the Performance Tuning Analysis was started, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_started: The time_started of this PerformanceTuningAnalysis.
        :type: datetime
        """
        self._time_started = time_started

    @property
    def time_finished(self):
        """
        **[Required]** Gets the time_finished of this PerformanceTuningAnalysis.
        The date and time the Performance Tuning Analysis was finished, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_finished of this PerformanceTuningAnalysis.
        :rtype: datetime
        """
        return self._time_finished

    @time_finished.setter
    def time_finished(self, time_finished):
        """
        Sets the time_finished of this PerformanceTuningAnalysis.
        The date and time the Performance Tuning Analysis was finished, in the format defined by `RFC 3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_finished: The time_finished of this PerformanceTuningAnalysis.
        :type: datetime
        """
        self._time_finished = time_finished

    @property
    def created_by(self):
        """
        **[Required]** Gets the created_by of this PerformanceTuningAnalysis.

        :return: The created_by of this PerformanceTuningAnalysis.
        :rtype: oci.jms_utils.models.Principal
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by):
        """
        Sets the created_by of this PerformanceTuningAnalysis.

        :param created_by: The created_by of this PerformanceTuningAnalysis.
        :type: oci.jms_utils.models.Principal
        """
        self._created_by = created_by

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
