# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: v1


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CloudGateExtUpstreamServerGroups(object):
    """
    A list of upstream server groups
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CloudGateExtUpstreamServerGroups object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param value:
            The value to assign to the value property of this CloudGateExtUpstreamServerGroups.
        :type value: str

        :param ref:
            The value to assign to the ref property of this CloudGateExtUpstreamServerGroups.
        :type ref: str

        :param nginx_settings:
            The value to assign to the nginx_settings property of this CloudGateExtUpstreamServerGroups.
        :type nginx_settings: str

        :param ssl:
            The value to assign to the ssl property of this CloudGateExtUpstreamServerGroups.
        :type ssl: bool

        :param display_name:
            The value to assign to the display_name property of this CloudGateExtUpstreamServerGroups.
        :type display_name: str

        """
        self.swagger_types = {
            'value': 'str',
            'ref': 'str',
            'nginx_settings': 'str',
            'ssl': 'bool',
            'display_name': 'str'
        }
        self.attribute_map = {
            'value': 'value',
            'ref': '$ref',
            'nginx_settings': 'nginxSettings',
            'ssl': 'ssl',
            'display_name': 'displayName'
        }
        self._value = None
        self._ref = None
        self._nginx_settings = None
        self._ssl = None
        self._display_name = None

    @property
    def value(self):
        """
        **[Required]** Gets the value of this CloudGateExtUpstreamServerGroups.
        Name for the Upstream Block

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The value of this CloudGateExtUpstreamServerGroups.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this CloudGateExtUpstreamServerGroups.
        Name for the Upstream Block

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: true
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param value: The value of this CloudGateExtUpstreamServerGroups.
        :type: str
        """
        self._value = value

    @property
    def ref(self):
        """
        Gets the ref of this CloudGateExtUpstreamServerGroups.
        URI of the upstream server groups

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: reference
         - uniqueness: none


        :return: The ref of this CloudGateExtUpstreamServerGroups.
        :rtype: str
        """
        return self._ref

    @ref.setter
    def ref(self, ref):
        """
        Sets the ref of this CloudGateExtUpstreamServerGroups.
        URI of the upstream server groups

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: reference
         - uniqueness: none


        :param ref: The ref of this CloudGateExtUpstreamServerGroups.
        :type: str
        """
        self._ref = ref

    @property
    def nginx_settings(self):
        """
        Gets the nginx_settings of this CloudGateExtUpstreamServerGroups.
        Any additional settings in nginx configuration form

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :return: The nginx_settings of this CloudGateExtUpstreamServerGroups.
        :rtype: str
        """
        return self._nginx_settings

    @nginx_settings.setter
    def nginx_settings(self, nginx_settings):
        """
        Sets the nginx_settings of this CloudGateExtUpstreamServerGroups.
        Any additional settings in nginx configuration form

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: string
         - uniqueness: none


        :param nginx_settings: The nginx_settings of this CloudGateExtUpstreamServerGroups.
        :type: str
        """
        self._nginx_settings = nginx_settings

    @property
    def ssl(self):
        """
        Gets the ssl of this CloudGateExtUpstreamServerGroups.
        SSL flag for the Upstream Block

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :return: The ssl of this CloudGateExtUpstreamServerGroups.
        :rtype: bool
        """
        return self._ssl

    @ssl.setter
    def ssl(self, ssl):
        """
        Sets the ssl of this CloudGateExtUpstreamServerGroups.
        SSL flag for the Upstream Block

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: false
         - returned: default
         - type: boolean
         - uniqueness: none


        :param ssl: The ssl of this CloudGateExtUpstreamServerGroups.
        :type: bool
        """
        self._ssl = ssl

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CloudGateExtUpstreamServerGroups.
        Display name of upstream

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :return: The display_name of this CloudGateExtUpstreamServerGroups.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CloudGateExtUpstreamServerGroups.
        Display name of upstream

        **Added In:** 20.1.3

        **SCIM++ Properties:**
         - caseExact: false
         - idcsSearchable: false
         - multiValued: false
         - mutability: readOnly
         - required: true
         - returned: default
         - type: string
         - uniqueness: none


        :param display_name: The display_name of this CloudGateExtUpstreamServerGroups.
        :type: str
        """
        self._display_name = display_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
