# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200407


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDeploymentDetails(object):
    """
    The information about a new Deployment.
    """

    #: A constant which can be used with the license_model property of a CreateDeploymentDetails.
    #: This constant has a value of "LICENSE_INCLUDED"
    LICENSE_MODEL_LICENSE_INCLUDED = "LICENSE_INCLUDED"

    #: A constant which can be used with the license_model property of a CreateDeploymentDetails.
    #: This constant has a value of "BRING_YOUR_OWN_LICENSE"
    LICENSE_MODEL_BRING_YOUR_OWN_LICENSE = "BRING_YOUR_OWN_LICENSE"

    #: A constant which can be used with the environment_type property of a CreateDeploymentDetails.
    #: This constant has a value of "PRODUCTION"
    ENVIRONMENT_TYPE_PRODUCTION = "PRODUCTION"

    #: A constant which can be used with the environment_type property of a CreateDeploymentDetails.
    #: This constant has a value of "DEVELOPMENT_OR_TESTING"
    ENVIRONMENT_TYPE_DEVELOPMENT_OR_TESTING = "DEVELOPMENT_OR_TESTING"

    #: A constant which can be used with the deployment_type property of a CreateDeploymentDetails.
    #: This constant has a value of "OGG"
    DEPLOYMENT_TYPE_OGG = "OGG"

    #: A constant which can be used with the deployment_type property of a CreateDeploymentDetails.
    #: This constant has a value of "DATABASE_ORACLE"
    DEPLOYMENT_TYPE_DATABASE_ORACLE = "DATABASE_ORACLE"

    #: A constant which can be used with the deployment_type property of a CreateDeploymentDetails.
    #: This constant has a value of "BIGDATA"
    DEPLOYMENT_TYPE_BIGDATA = "BIGDATA"

    #: A constant which can be used with the deployment_type property of a CreateDeploymentDetails.
    #: This constant has a value of "DATABASE_MICROSOFT_SQLSERVER"
    DEPLOYMENT_TYPE_DATABASE_MICROSOFT_SQLSERVER = "DATABASE_MICROSOFT_SQLSERVER"

    #: A constant which can be used with the deployment_type property of a CreateDeploymentDetails.
    #: This constant has a value of "DATABASE_MYSQL"
    DEPLOYMENT_TYPE_DATABASE_MYSQL = "DATABASE_MYSQL"

    #: A constant which can be used with the deployment_type property of a CreateDeploymentDetails.
    #: This constant has a value of "DATABASE_POSTGRESQL"
    DEPLOYMENT_TYPE_DATABASE_POSTGRESQL = "DATABASE_POSTGRESQL"

    #: A constant which can be used with the deployment_type property of a CreateDeploymentDetails.
    #: This constant has a value of "DATABASE_DB2ZOS"
    DEPLOYMENT_TYPE_DATABASE_DB2_ZOS = "DATABASE_DB2ZOS"

    #: A constant which can be used with the deployment_type property of a CreateDeploymentDetails.
    #: This constant has a value of "DATABASE_DB2I"
    DEPLOYMENT_TYPE_DATABASE_DB2_I = "DATABASE_DB2I"

    #: A constant which can be used with the deployment_type property of a CreateDeploymentDetails.
    #: This constant has a value of "GGSA"
    DEPLOYMENT_TYPE_GGSA = "GGSA"

    #: A constant which can be used with the deployment_type property of a CreateDeploymentDetails.
    #: This constant has a value of "DATA_TRANSFORMS"
    DEPLOYMENT_TYPE_DATA_TRANSFORMS = "DATA_TRANSFORMS"

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDeploymentDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param display_name:
            The value to assign to the display_name property of this CreateDeploymentDetails.
        :type display_name: str

        :param license_model:
            The value to assign to the license_model property of this CreateDeploymentDetails.
            Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"
        :type license_model: str

        :param is_byol_cpu_core_count_limit_enabled:
            The value to assign to the is_byol_cpu_core_count_limit_enabled property of this CreateDeploymentDetails.
        :type is_byol_cpu_core_count_limit_enabled: bool

        :param byol_cpu_core_count_limit:
            The value to assign to the byol_cpu_core_count_limit property of this CreateDeploymentDetails.
        :type byol_cpu_core_count_limit: int

        :param environment_type:
            The value to assign to the environment_type property of this CreateDeploymentDetails.
            Allowed values for this property are: "PRODUCTION", "DEVELOPMENT_OR_TESTING"
        :type environment_type: str

        :param description:
            The value to assign to the description property of this CreateDeploymentDetails.
        :type description: str

        :param compartment_id:
            The value to assign to the compartment_id property of this CreateDeploymentDetails.
        :type compartment_id: str

        :param source_deployment_id:
            The value to assign to the source_deployment_id property of this CreateDeploymentDetails.
        :type source_deployment_id: str

        :param availability_domain:
            The value to assign to the availability_domain property of this CreateDeploymentDetails.
        :type availability_domain: str

        :param fault_domain:
            The value to assign to the fault_domain property of this CreateDeploymentDetails.
        :type fault_domain: str

        :param placements:
            The value to assign to the placements property of this CreateDeploymentDetails.
        :type placements: list[oci.golden_gate.models.DeploymentPlacementDetails]

        :param freeform_tags:
            The value to assign to the freeform_tags property of this CreateDeploymentDetails.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this CreateDeploymentDetails.
        :type defined_tags: dict(str, dict(str, object))

        :param locks:
            The value to assign to the locks property of this CreateDeploymentDetails.
        :type locks: list[oci.golden_gate.models.AddResourceLockDetails]

        :param deployment_backup_id:
            The value to assign to the deployment_backup_id property of this CreateDeploymentDetails.
        :type deployment_backup_id: str

        :param subnet_id:
            The value to assign to the subnet_id property of this CreateDeploymentDetails.
        :type subnet_id: str

        :param load_balancer_subnet_id:
            The value to assign to the load_balancer_subnet_id property of this CreateDeploymentDetails.
        :type load_balancer_subnet_id: str

        :param fqdn:
            The value to assign to the fqdn property of this CreateDeploymentDetails.
        :type fqdn: str

        :param nsg_ids:
            The value to assign to the nsg_ids property of this CreateDeploymentDetails.
        :type nsg_ids: list[str]

        :param is_public:
            The value to assign to the is_public property of this CreateDeploymentDetails.
        :type is_public: bool

        :param cpu_core_count:
            The value to assign to the cpu_core_count property of this CreateDeploymentDetails.
        :type cpu_core_count: int

        :param is_auto_scaling_enabled:
            The value to assign to the is_auto_scaling_enabled property of this CreateDeploymentDetails.
        :type is_auto_scaling_enabled: bool

        :param deployment_type:
            The value to assign to the deployment_type property of this CreateDeploymentDetails.
            Allowed values for this property are: "OGG", "DATABASE_ORACLE", "BIGDATA", "DATABASE_MICROSOFT_SQLSERVER", "DATABASE_MYSQL", "DATABASE_POSTGRESQL", "DATABASE_DB2ZOS", "DATABASE_DB2I", "GGSA", "DATA_TRANSFORMS"
        :type deployment_type: str

        :param subscription_id:
            The value to assign to the subscription_id property of this CreateDeploymentDetails.
        :type subscription_id: str

        :param cluster_placement_group_id:
            The value to assign to the cluster_placement_group_id property of this CreateDeploymentDetails.
        :type cluster_placement_group_id: str

        :param security_attributes:
            The value to assign to the security_attributes property of this CreateDeploymentDetails.
        :type security_attributes: dict(str, dict(str, object))

        :param ogg_data:
            The value to assign to the ogg_data property of this CreateDeploymentDetails.
        :type ogg_data: oci.golden_gate.models.CreateOggDeploymentDetails

        :param maintenance_window:
            The value to assign to the maintenance_window property of this CreateDeploymentDetails.
        :type maintenance_window: oci.golden_gate.models.CreateMaintenanceWindowDetails

        :param maintenance_configuration:
            The value to assign to the maintenance_configuration property of this CreateDeploymentDetails.
        :type maintenance_configuration: oci.golden_gate.models.CreateMaintenanceConfigurationDetails

        :param backup_schedule:
            The value to assign to the backup_schedule property of this CreateDeploymentDetails.
        :type backup_schedule: oci.golden_gate.models.CreateBackupScheduleDetails

        """
        self.swagger_types = {
            'display_name': 'str',
            'license_model': 'str',
            'is_byol_cpu_core_count_limit_enabled': 'bool',
            'byol_cpu_core_count_limit': 'int',
            'environment_type': 'str',
            'description': 'str',
            'compartment_id': 'str',
            'source_deployment_id': 'str',
            'availability_domain': 'str',
            'fault_domain': 'str',
            'placements': 'list[DeploymentPlacementDetails]',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'locks': 'list[AddResourceLockDetails]',
            'deployment_backup_id': 'str',
            'subnet_id': 'str',
            'load_balancer_subnet_id': 'str',
            'fqdn': 'str',
            'nsg_ids': 'list[str]',
            'is_public': 'bool',
            'cpu_core_count': 'int',
            'is_auto_scaling_enabled': 'bool',
            'deployment_type': 'str',
            'subscription_id': 'str',
            'cluster_placement_group_id': 'str',
            'security_attributes': 'dict(str, dict(str, object))',
            'ogg_data': 'CreateOggDeploymentDetails',
            'maintenance_window': 'CreateMaintenanceWindowDetails',
            'maintenance_configuration': 'CreateMaintenanceConfigurationDetails',
            'backup_schedule': 'CreateBackupScheduleDetails'
        }
        self.attribute_map = {
            'display_name': 'displayName',
            'license_model': 'licenseModel',
            'is_byol_cpu_core_count_limit_enabled': 'isByolCpuCoreCountLimitEnabled',
            'byol_cpu_core_count_limit': 'byolCpuCoreCountLimit',
            'environment_type': 'environmentType',
            'description': 'description',
            'compartment_id': 'compartmentId',
            'source_deployment_id': 'sourceDeploymentId',
            'availability_domain': 'availabilityDomain',
            'fault_domain': 'faultDomain',
            'placements': 'placements',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'locks': 'locks',
            'deployment_backup_id': 'deploymentBackupId',
            'subnet_id': 'subnetId',
            'load_balancer_subnet_id': 'loadBalancerSubnetId',
            'fqdn': 'fqdn',
            'nsg_ids': 'nsgIds',
            'is_public': 'isPublic',
            'cpu_core_count': 'cpuCoreCount',
            'is_auto_scaling_enabled': 'isAutoScalingEnabled',
            'deployment_type': 'deploymentType',
            'subscription_id': 'subscriptionId',
            'cluster_placement_group_id': 'clusterPlacementGroupId',
            'security_attributes': 'securityAttributes',
            'ogg_data': 'oggData',
            'maintenance_window': 'maintenanceWindow',
            'maintenance_configuration': 'maintenanceConfiguration',
            'backup_schedule': 'backupSchedule'
        }
        self._display_name = None
        self._license_model = None
        self._is_byol_cpu_core_count_limit_enabled = None
        self._byol_cpu_core_count_limit = None
        self._environment_type = None
        self._description = None
        self._compartment_id = None
        self._source_deployment_id = None
        self._availability_domain = None
        self._fault_domain = None
        self._placements = None
        self._freeform_tags = None
        self._defined_tags = None
        self._locks = None
        self._deployment_backup_id = None
        self._subnet_id = None
        self._load_balancer_subnet_id = None
        self._fqdn = None
        self._nsg_ids = None
        self._is_public = None
        self._cpu_core_count = None
        self._is_auto_scaling_enabled = None
        self._deployment_type = None
        self._subscription_id = None
        self._cluster_placement_group_id = None
        self._security_attributes = None
        self._ogg_data = None
        self._maintenance_window = None
        self._maintenance_configuration = None
        self._backup_schedule = None

    @property
    def display_name(self):
        """
        **[Required]** Gets the display_name of this CreateDeploymentDetails.
        An object's Display Name.


        :return: The display_name of this CreateDeploymentDetails.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this CreateDeploymentDetails.
        An object's Display Name.


        :param display_name: The display_name of this CreateDeploymentDetails.
        :type: str
        """
        self._display_name = display_name

    @property
    def license_model(self):
        """
        Gets the license_model of this CreateDeploymentDetails.
        The Oracle license model that applies to a Deployment.

        Allowed values for this property are: "LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"


        :return: The license_model of this CreateDeploymentDetails.
        :rtype: str
        """
        return self._license_model

    @license_model.setter
    def license_model(self, license_model):
        """
        Sets the license_model of this CreateDeploymentDetails.
        The Oracle license model that applies to a Deployment.


        :param license_model: The license_model of this CreateDeploymentDetails.
        :type: str
        """
        allowed_values = ["LICENSE_INCLUDED", "BRING_YOUR_OWN_LICENSE"]
        if not value_allowed_none_or_none_sentinel(license_model, allowed_values):
            raise ValueError(
                f"Invalid value for `license_model`, must be None or one of {allowed_values}"
            )
        self._license_model = license_model

    @property
    def is_byol_cpu_core_count_limit_enabled(self):
        """
        Gets the is_byol_cpu_core_count_limit_enabled of this CreateDeploymentDetails.
        Flag to allow to configure the 'Bring Your Own License' (BYOL) license type CPU limit.
        If enabled, the exact number of CPUs must be provided via byolCpuCoreCountLimit.


        :return: The is_byol_cpu_core_count_limit_enabled of this CreateDeploymentDetails.
        :rtype: bool
        """
        return self._is_byol_cpu_core_count_limit_enabled

    @is_byol_cpu_core_count_limit_enabled.setter
    def is_byol_cpu_core_count_limit_enabled(self, is_byol_cpu_core_count_limit_enabled):
        """
        Sets the is_byol_cpu_core_count_limit_enabled of this CreateDeploymentDetails.
        Flag to allow to configure the 'Bring Your Own License' (BYOL) license type CPU limit.
        If enabled, the exact number of CPUs must be provided via byolCpuCoreCountLimit.


        :param is_byol_cpu_core_count_limit_enabled: The is_byol_cpu_core_count_limit_enabled of this CreateDeploymentDetails.
        :type: bool
        """
        self._is_byol_cpu_core_count_limit_enabled = is_byol_cpu_core_count_limit_enabled

    @property
    def byol_cpu_core_count_limit(self):
        """
        Gets the byol_cpu_core_count_limit of this CreateDeploymentDetails.
        The maximum number of CPUs allowed with a 'Bring Your Own License' (BYOL) license type.
        Any CPU usage above this limit is considered as License Included and billed.


        :return: The byol_cpu_core_count_limit of this CreateDeploymentDetails.
        :rtype: int
        """
        return self._byol_cpu_core_count_limit

    @byol_cpu_core_count_limit.setter
    def byol_cpu_core_count_limit(self, byol_cpu_core_count_limit):
        """
        Sets the byol_cpu_core_count_limit of this CreateDeploymentDetails.
        The maximum number of CPUs allowed with a 'Bring Your Own License' (BYOL) license type.
        Any CPU usage above this limit is considered as License Included and billed.


        :param byol_cpu_core_count_limit: The byol_cpu_core_count_limit of this CreateDeploymentDetails.
        :type: int
        """
        self._byol_cpu_core_count_limit = byol_cpu_core_count_limit

    @property
    def environment_type(self):
        """
        Gets the environment_type of this CreateDeploymentDetails.
        Specifies whether the deployment is used in a production or development/testing environment.

        Allowed values for this property are: "PRODUCTION", "DEVELOPMENT_OR_TESTING"


        :return: The environment_type of this CreateDeploymentDetails.
        :rtype: str
        """
        return self._environment_type

    @environment_type.setter
    def environment_type(self, environment_type):
        """
        Sets the environment_type of this CreateDeploymentDetails.
        Specifies whether the deployment is used in a production or development/testing environment.


        :param environment_type: The environment_type of this CreateDeploymentDetails.
        :type: str
        """
        allowed_values = ["PRODUCTION", "DEVELOPMENT_OR_TESTING"]
        if not value_allowed_none_or_none_sentinel(environment_type, allowed_values):
            raise ValueError(
                f"Invalid value for `environment_type`, must be None or one of {allowed_values}"
            )
        self._environment_type = environment_type

    @property
    def description(self):
        """
        Gets the description of this CreateDeploymentDetails.
        Metadata about this specific object.


        :return: The description of this CreateDeploymentDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this CreateDeploymentDetails.
        Metadata about this specific object.


        :param description: The description of this CreateDeploymentDetails.
        :type: str
        """
        self._description = description

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this CreateDeploymentDetails.
        The `OCID`__ of the compartment being referenced.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this CreateDeploymentDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this CreateDeploymentDetails.
        The `OCID`__ of the compartment being referenced.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this CreateDeploymentDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def source_deployment_id(self):
        """
        Gets the source_deployment_id of this CreateDeploymentDetails.
        The `OCID`__ of the deployment being referenced.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The source_deployment_id of this CreateDeploymentDetails.
        :rtype: str
        """
        return self._source_deployment_id

    @source_deployment_id.setter
    def source_deployment_id(self, source_deployment_id):
        """
        Sets the source_deployment_id of this CreateDeploymentDetails.
        The `OCID`__ of the deployment being referenced.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param source_deployment_id: The source_deployment_id of this CreateDeploymentDetails.
        :type: str
        """
        self._source_deployment_id = source_deployment_id

    @property
    def availability_domain(self):
        """
        Gets the availability_domain of this CreateDeploymentDetails.
        The availability domain of a placement.


        :return: The availability_domain of this CreateDeploymentDetails.
        :rtype: str
        """
        return self._availability_domain

    @availability_domain.setter
    def availability_domain(self, availability_domain):
        """
        Sets the availability_domain of this CreateDeploymentDetails.
        The availability domain of a placement.


        :param availability_domain: The availability_domain of this CreateDeploymentDetails.
        :type: str
        """
        self._availability_domain = availability_domain

    @property
    def fault_domain(self):
        """
        Gets the fault_domain of this CreateDeploymentDetails.
        The fault domain of a placement.


        :return: The fault_domain of this CreateDeploymentDetails.
        :rtype: str
        """
        return self._fault_domain

    @fault_domain.setter
    def fault_domain(self, fault_domain):
        """
        Sets the fault_domain of this CreateDeploymentDetails.
        The fault domain of a placement.


        :param fault_domain: The fault_domain of this CreateDeploymentDetails.
        :type: str
        """
        self._fault_domain = fault_domain

    @property
    def placements(self):
        """
        Gets the placements of this CreateDeploymentDetails.
        An array of local peers of deployment


        :return: The placements of this CreateDeploymentDetails.
        :rtype: list[oci.golden_gate.models.DeploymentPlacementDetails]
        """
        return self._placements

    @placements.setter
    def placements(self, placements):
        """
        Sets the placements of this CreateDeploymentDetails.
        An array of local peers of deployment


        :param placements: The placements of this CreateDeploymentDetails.
        :type: list[oci.golden_gate.models.DeploymentPlacementDetails]
        """
        self._placements = placements

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this CreateDeploymentDetails.
        A simple key-value pair that is applied without any predefined name, type, or scope. Exists
        for cross-compatibility only.

        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this CreateDeploymentDetails.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this CreateDeploymentDetails.
        A simple key-value pair that is applied without any predefined name, type, or scope. Exists
        for cross-compatibility only.

        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this CreateDeploymentDetails.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this CreateDeploymentDetails.
        Tags defined for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this CreateDeploymentDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this CreateDeploymentDetails.
        Tags defined for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this CreateDeploymentDetails.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def locks(self):
        """
        Gets the locks of this CreateDeploymentDetails.
        Locks associated with this resource.


        :return: The locks of this CreateDeploymentDetails.
        :rtype: list[oci.golden_gate.models.AddResourceLockDetails]
        """
        return self._locks

    @locks.setter
    def locks(self, locks):
        """
        Sets the locks of this CreateDeploymentDetails.
        Locks associated with this resource.


        :param locks: The locks of this CreateDeploymentDetails.
        :type: list[oci.golden_gate.models.AddResourceLockDetails]
        """
        self._locks = locks

    @property
    def deployment_backup_id(self):
        """
        Gets the deployment_backup_id of this CreateDeploymentDetails.
        The `OCID`__ of the backup being referenced.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The deployment_backup_id of this CreateDeploymentDetails.
        :rtype: str
        """
        return self._deployment_backup_id

    @deployment_backup_id.setter
    def deployment_backup_id(self, deployment_backup_id):
        """
        Sets the deployment_backup_id of this CreateDeploymentDetails.
        The `OCID`__ of the backup being referenced.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param deployment_backup_id: The deployment_backup_id of this CreateDeploymentDetails.
        :type: str
        """
        self._deployment_backup_id = deployment_backup_id

    @property
    def subnet_id(self):
        """
        **[Required]** Gets the subnet_id of this CreateDeploymentDetails.
        The `OCID`__ of the subnet of the deployment's private endpoint.
        The subnet must be a private subnet. For backward compatibility, public subnets are allowed until May 31 2025,
        after which the private subnet will be enforced.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The subnet_id of this CreateDeploymentDetails.
        :rtype: str
        """
        return self._subnet_id

    @subnet_id.setter
    def subnet_id(self, subnet_id):
        """
        Sets the subnet_id of this CreateDeploymentDetails.
        The `OCID`__ of the subnet of the deployment's private endpoint.
        The subnet must be a private subnet. For backward compatibility, public subnets are allowed until May 31 2025,
        after which the private subnet will be enforced.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param subnet_id: The subnet_id of this CreateDeploymentDetails.
        :type: str
        """
        self._subnet_id = subnet_id

    @property
    def load_balancer_subnet_id(self):
        """
        Gets the load_balancer_subnet_id of this CreateDeploymentDetails.
        The `OCID`__ of a public subnet in the customer tenancy.
        Can be provided only for public deployments. If provided, the loadbalancer will be created in this subnet instead of the service tenancy.
        For backward compatibility, this is an optional property. It will become mandatory for public deployments after October 1, 2024.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The load_balancer_subnet_id of this CreateDeploymentDetails.
        :rtype: str
        """
        return self._load_balancer_subnet_id

    @load_balancer_subnet_id.setter
    def load_balancer_subnet_id(self, load_balancer_subnet_id):
        """
        Sets the load_balancer_subnet_id of this CreateDeploymentDetails.
        The `OCID`__ of a public subnet in the customer tenancy.
        Can be provided only for public deployments. If provided, the loadbalancer will be created in this subnet instead of the service tenancy.
        For backward compatibility, this is an optional property. It will become mandatory for public deployments after October 1, 2024.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param load_balancer_subnet_id: The load_balancer_subnet_id of this CreateDeploymentDetails.
        :type: str
        """
        self._load_balancer_subnet_id = load_balancer_subnet_id

    @property
    def fqdn(self):
        """
        Gets the fqdn of this CreateDeploymentDetails.
        A three-label Fully Qualified Domain Name (FQDN) for a resource.


        :return: The fqdn of this CreateDeploymentDetails.
        :rtype: str
        """
        return self._fqdn

    @fqdn.setter
    def fqdn(self, fqdn):
        """
        Sets the fqdn of this CreateDeploymentDetails.
        A three-label Fully Qualified Domain Name (FQDN) for a resource.


        :param fqdn: The fqdn of this CreateDeploymentDetails.
        :type: str
        """
        self._fqdn = fqdn

    @property
    def nsg_ids(self):
        """
        Gets the nsg_ids of this CreateDeploymentDetails.
        An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.


        :return: The nsg_ids of this CreateDeploymentDetails.
        :rtype: list[str]
        """
        return self._nsg_ids

    @nsg_ids.setter
    def nsg_ids(self, nsg_ids):
        """
        Sets the nsg_ids of this CreateDeploymentDetails.
        An array of Network Security Group OCIDs used to define network access for either Deployments or Connections.


        :param nsg_ids: The nsg_ids of this CreateDeploymentDetails.
        :type: list[str]
        """
        self._nsg_ids = nsg_ids

    @property
    def is_public(self):
        """
        Gets the is_public of this CreateDeploymentDetails.
        True if this object is publicly available.


        :return: The is_public of this CreateDeploymentDetails.
        :rtype: bool
        """
        return self._is_public

    @is_public.setter
    def is_public(self, is_public):
        """
        Sets the is_public of this CreateDeploymentDetails.
        True if this object is publicly available.


        :param is_public: The is_public of this CreateDeploymentDetails.
        :type: bool
        """
        self._is_public = is_public

    @property
    def cpu_core_count(self):
        """
        Gets the cpu_core_count of this CreateDeploymentDetails.
        The Minimum number of OCPUs to be made available for this Deployment.


        :return: The cpu_core_count of this CreateDeploymentDetails.
        :rtype: int
        """
        return self._cpu_core_count

    @cpu_core_count.setter
    def cpu_core_count(self, cpu_core_count):
        """
        Sets the cpu_core_count of this CreateDeploymentDetails.
        The Minimum number of OCPUs to be made available for this Deployment.


        :param cpu_core_count: The cpu_core_count of this CreateDeploymentDetails.
        :type: int
        """
        self._cpu_core_count = cpu_core_count

    @property
    def is_auto_scaling_enabled(self):
        """
        Gets the is_auto_scaling_enabled of this CreateDeploymentDetails.
        Indicates if auto scaling is enabled for the Deployment's CPU core count.


        :return: The is_auto_scaling_enabled of this CreateDeploymentDetails.
        :rtype: bool
        """
        return self._is_auto_scaling_enabled

    @is_auto_scaling_enabled.setter
    def is_auto_scaling_enabled(self, is_auto_scaling_enabled):
        """
        Sets the is_auto_scaling_enabled of this CreateDeploymentDetails.
        Indicates if auto scaling is enabled for the Deployment's CPU core count.


        :param is_auto_scaling_enabled: The is_auto_scaling_enabled of this CreateDeploymentDetails.
        :type: bool
        """
        self._is_auto_scaling_enabled = is_auto_scaling_enabled

    @property
    def deployment_type(self):
        """
        Gets the deployment_type of this CreateDeploymentDetails.
        The type of deployment, which can be any one of the Allowed values.
        NOTE: Use of the value 'OGG' is maintained for backward compatibility purposes.
            Its use is discouraged in favor of 'DATABASE_ORACLE'.

        Allowed values for this property are: "OGG", "DATABASE_ORACLE", "BIGDATA", "DATABASE_MICROSOFT_SQLSERVER", "DATABASE_MYSQL", "DATABASE_POSTGRESQL", "DATABASE_DB2ZOS", "DATABASE_DB2I", "GGSA", "DATA_TRANSFORMS"


        :return: The deployment_type of this CreateDeploymentDetails.
        :rtype: str
        """
        return self._deployment_type

    @deployment_type.setter
    def deployment_type(self, deployment_type):
        """
        Sets the deployment_type of this CreateDeploymentDetails.
        The type of deployment, which can be any one of the Allowed values.
        NOTE: Use of the value 'OGG' is maintained for backward compatibility purposes.
            Its use is discouraged in favor of 'DATABASE_ORACLE'.


        :param deployment_type: The deployment_type of this CreateDeploymentDetails.
        :type: str
        """
        allowed_values = ["OGG", "DATABASE_ORACLE", "BIGDATA", "DATABASE_MICROSOFT_SQLSERVER", "DATABASE_MYSQL", "DATABASE_POSTGRESQL", "DATABASE_DB2ZOS", "DATABASE_DB2I", "GGSA", "DATA_TRANSFORMS"]
        if not value_allowed_none_or_none_sentinel(deployment_type, allowed_values):
            raise ValueError(
                f"Invalid value for `deployment_type`, must be None or one of {allowed_values}"
            )
        self._deployment_type = deployment_type

    @property
    def subscription_id(self):
        """
        Gets the subscription_id of this CreateDeploymentDetails.
        The `OCID`__ of the subscription with which resource needs to be associated with.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The subscription_id of this CreateDeploymentDetails.
        :rtype: str
        """
        return self._subscription_id

    @subscription_id.setter
    def subscription_id(self, subscription_id):
        """
        Sets the subscription_id of this CreateDeploymentDetails.
        The `OCID`__ of the subscription with which resource needs to be associated with.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param subscription_id: The subscription_id of this CreateDeploymentDetails.
        :type: str
        """
        self._subscription_id = subscription_id

    @property
    def cluster_placement_group_id(self):
        """
        Gets the cluster_placement_group_id of this CreateDeploymentDetails.
        The OCID(/Content/General/Concepts/identifiers.htm) of the cluster placement group for the resource.
        Only applicable for multicloud subscriptions. The cluster placement group id must be provided when a multicloud
        subscription id is provided. Otherwise the cluster placement group must not be provided.


        :return: The cluster_placement_group_id of this CreateDeploymentDetails.
        :rtype: str
        """
        return self._cluster_placement_group_id

    @cluster_placement_group_id.setter
    def cluster_placement_group_id(self, cluster_placement_group_id):
        """
        Sets the cluster_placement_group_id of this CreateDeploymentDetails.
        The OCID(/Content/General/Concepts/identifiers.htm) of the cluster placement group for the resource.
        Only applicable for multicloud subscriptions. The cluster placement group id must be provided when a multicloud
        subscription id is provided. Otherwise the cluster placement group must not be provided.


        :param cluster_placement_group_id: The cluster_placement_group_id of this CreateDeploymentDetails.
        :type: str
        """
        self._cluster_placement_group_id = cluster_placement_group_id

    @property
    def security_attributes(self):
        """
        Gets the security_attributes of this CreateDeploymentDetails.
        Security attributes for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Oracle-ZPR\": {\"MaxEgressCount\": {\"value\": \"42\", \"mode\": \"enforce\"}}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The security_attributes of this CreateDeploymentDetails.
        :rtype: dict(str, dict(str, object))
        """
        return self._security_attributes

    @security_attributes.setter
    def security_attributes(self, security_attributes):
        """
        Sets the security_attributes of this CreateDeploymentDetails.
        Security attributes for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Oracle-ZPR\": {\"MaxEgressCount\": {\"value\": \"42\", \"mode\": \"enforce\"}}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param security_attributes: The security_attributes of this CreateDeploymentDetails.
        :type: dict(str, dict(str, object))
        """
        self._security_attributes = security_attributes

    @property
    def ogg_data(self):
        """
        Gets the ogg_data of this CreateDeploymentDetails.

        :return: The ogg_data of this CreateDeploymentDetails.
        :rtype: oci.golden_gate.models.CreateOggDeploymentDetails
        """
        return self._ogg_data

    @ogg_data.setter
    def ogg_data(self, ogg_data):
        """
        Sets the ogg_data of this CreateDeploymentDetails.

        :param ogg_data: The ogg_data of this CreateDeploymentDetails.
        :type: oci.golden_gate.models.CreateOggDeploymentDetails
        """
        self._ogg_data = ogg_data

    @property
    def maintenance_window(self):
        """
        Gets the maintenance_window of this CreateDeploymentDetails.

        :return: The maintenance_window of this CreateDeploymentDetails.
        :rtype: oci.golden_gate.models.CreateMaintenanceWindowDetails
        """
        return self._maintenance_window

    @maintenance_window.setter
    def maintenance_window(self, maintenance_window):
        """
        Sets the maintenance_window of this CreateDeploymentDetails.

        :param maintenance_window: The maintenance_window of this CreateDeploymentDetails.
        :type: oci.golden_gate.models.CreateMaintenanceWindowDetails
        """
        self._maintenance_window = maintenance_window

    @property
    def maintenance_configuration(self):
        """
        Gets the maintenance_configuration of this CreateDeploymentDetails.

        :return: The maintenance_configuration of this CreateDeploymentDetails.
        :rtype: oci.golden_gate.models.CreateMaintenanceConfigurationDetails
        """
        return self._maintenance_configuration

    @maintenance_configuration.setter
    def maintenance_configuration(self, maintenance_configuration):
        """
        Sets the maintenance_configuration of this CreateDeploymentDetails.

        :param maintenance_configuration: The maintenance_configuration of this CreateDeploymentDetails.
        :type: oci.golden_gate.models.CreateMaintenanceConfigurationDetails
        """
        self._maintenance_configuration = maintenance_configuration

    @property
    def backup_schedule(self):
        """
        Gets the backup_schedule of this CreateDeploymentDetails.

        :return: The backup_schedule of this CreateDeploymentDetails.
        :rtype: oci.golden_gate.models.CreateBackupScheduleDetails
        """
        return self._backup_schedule

    @backup_schedule.setter
    def backup_schedule(self, backup_schedule):
        """
        Sets the backup_schedule of this CreateDeploymentDetails.

        :param backup_schedule: The backup_schedule of this CreateDeploymentDetails.
        :type: oci.golden_gate.models.CreateBackupScheduleDetails
        """
        self._backup_schedule = backup_schedule

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
