# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20231130

from .response_format import ResponseFormat
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class JsonSchemaResponseFormat(ResponseFormat):
    """
    Enables Structured Outputs which ensures the model will match your supplied JSON schema.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new JsonSchemaResponseFormat object with values from keyword arguments. The default value of the :py:attr:`~oci.generative_ai_inference.models.JsonSchemaResponseFormat.type` attribute
        of this class is ``JSON_SCHEMA`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this JsonSchemaResponseFormat.
            Allowed values for this property are: "TEXT", "JSON_OBJECT", "JSON_SCHEMA"
        :type type: str

        :param json_schema:
            The value to assign to the json_schema property of this JsonSchemaResponseFormat.
        :type json_schema: oci.generative_ai_inference.models.ResponseJsonSchema

        """
        self.swagger_types = {
            'type': 'str',
            'json_schema': 'ResponseJsonSchema'
        }
        self.attribute_map = {
            'type': 'type',
            'json_schema': 'jsonSchema'
        }
        self._type = None
        self._json_schema = None
        self._type = 'JSON_SCHEMA'

    @property
    def json_schema(self):
        """
        Gets the json_schema of this JsonSchemaResponseFormat.

        :return: The json_schema of this JsonSchemaResponseFormat.
        :rtype: oci.generative_ai_inference.models.ResponseJsonSchema
        """
        return self._json_schema

    @json_schema.setter
    def json_schema(self, json_schema):
        """
        Sets the json_schema of this JsonSchemaResponseFormat.

        :param json_schema: The json_schema of this JsonSchemaResponseFormat.
        :type: oci.generative_ai_inference.models.ResponseJsonSchema
        """
        self._json_schema = json_schema

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
