# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20240531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class UsageDetails(object):
    """
    Usage details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new UsageDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param input_token_count:
            The value to assign to the input_token_count property of this UsageDetails.
        :type input_token_count: int

        :param output_token_count:
            The value to assign to the output_token_count property of this UsageDetails.
        :type output_token_count: int

        :param input_char_count:
            The value to assign to the input_char_count property of this UsageDetails.
        :type input_char_count: int

        :param output_char_count:
            The value to assign to the output_char_count property of this UsageDetails.
        :type output_char_count: int

        """
        self.swagger_types = {
            'input_token_count': 'int',
            'output_token_count': 'int',
            'input_char_count': 'int',
            'output_char_count': 'int'
        }
        self.attribute_map = {
            'input_token_count': 'inputTokenCount',
            'output_token_count': 'outputTokenCount',
            'input_char_count': 'inputCharCount',
            'output_char_count': 'outputCharCount'
        }
        self._input_token_count = None
        self._output_token_count = None
        self._input_char_count = None
        self._output_char_count = None

    @property
    def input_token_count(self):
        """
        Gets the input_token_count of this UsageDetails.
        Number of input tokens.


        :return: The input_token_count of this UsageDetails.
        :rtype: int
        """
        return self._input_token_count

    @input_token_count.setter
    def input_token_count(self, input_token_count):
        """
        Sets the input_token_count of this UsageDetails.
        Number of input tokens.


        :param input_token_count: The input_token_count of this UsageDetails.
        :type: int
        """
        self._input_token_count = input_token_count

    @property
    def output_token_count(self):
        """
        Gets the output_token_count of this UsageDetails.
        Number of output tokens.


        :return: The output_token_count of this UsageDetails.
        :rtype: int
        """
        return self._output_token_count

    @output_token_count.setter
    def output_token_count(self, output_token_count):
        """
        Sets the output_token_count of this UsageDetails.
        Number of output tokens.


        :param output_token_count: The output_token_count of this UsageDetails.
        :type: int
        """
        self._output_token_count = output_token_count

    @property
    def input_char_count(self):
        """
        Gets the input_char_count of this UsageDetails.
        Number of input characters.


        :return: The input_char_count of this UsageDetails.
        :rtype: int
        """
        return self._input_char_count

    @input_char_count.setter
    def input_char_count(self, input_char_count):
        """
        Sets the input_char_count of this UsageDetails.
        Number of input characters.


        :param input_char_count: The input_char_count of this UsageDetails.
        :type: int
        """
        self._input_char_count = input_char_count

    @property
    def output_char_count(self):
        """
        Gets the output_char_count of this UsageDetails.
        Number of output characters.


        :return: The output_char_count of this UsageDetails.
        :rtype: int
        """
        return self._output_char_count

    @output_char_count.setter
    def output_char_count(self, output_char_count):
        """
        Sets the output_char_count of this UsageDetails.
        Number of output characters.


        :param output_char_count: The output_char_count of this UsageDetails.
        :type: int
        """
        self._output_char_count = output_char_count

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
