# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228

from .credential_entity_specific_details import CredentialEntitySpecificDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TargetCredentialEntitySpecificDetails(CredentialEntitySpecificDetails):
    """
    Target credential details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TargetCredentialEntitySpecificDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.fleet_apps_management.models.TargetCredentialEntitySpecificDetails.credential_level` attribute
        of this class is ``TARGET`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param credential_level:
            The value to assign to the credential_level property of this TargetCredentialEntitySpecificDetails.
            Allowed values for this property are: "FLEET", "RESOURCE", "TARGET"
        :type credential_level: str

        :param resource_id:
            The value to assign to the resource_id property of this TargetCredentialEntitySpecificDetails.
        :type resource_id: str

        :param target:
            The value to assign to the target property of this TargetCredentialEntitySpecificDetails.
        :type target: str

        """
        self.swagger_types = {
            'credential_level': 'str',
            'resource_id': 'str',
            'target': 'str'
        }
        self.attribute_map = {
            'credential_level': 'credentialLevel',
            'resource_id': 'resourceId',
            'target': 'target'
        }
        self._credential_level = None
        self._resource_id = None
        self._target = None
        self._credential_level = 'TARGET'

    @property
    def resource_id(self):
        """
        **[Required]** Gets the resource_id of this TargetCredentialEntitySpecificDetails.
        OCID of the resource associated with the target for which the credential is created.


        :return: The resource_id of this TargetCredentialEntitySpecificDetails.
        :rtype: str
        """
        return self._resource_id

    @resource_id.setter
    def resource_id(self, resource_id):
        """
        Sets the resource_id of this TargetCredentialEntitySpecificDetails.
        OCID of the resource associated with the target for which the credential is created.


        :param resource_id: The resource_id of this TargetCredentialEntitySpecificDetails.
        :type: str
        """
        self._resource_id = resource_id

    @property
    def target(self):
        """
        **[Required]** Gets the target of this TargetCredentialEntitySpecificDetails.
        Target name for which the credential is provided.


        :return: The target of this TargetCredentialEntitySpecificDetails.
        :rtype: str
        """
        return self._target

    @target.setter
    def target(self, target):
        """
        Sets the target of this TargetCredentialEntitySpecificDetails.
        Target name for which the credential is provided.


        :param target: The target of this TargetCredentialEntitySpecificDetails.
        :type: str
        """
        self._target = target

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
