# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20250228


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComplianceRecordDimension(object):
    """
    Aggregated summary information for ComplianceRecord
    """

    #: A constant which can be used with the compliance_state property of a ComplianceRecordDimension.
    #: This constant has a value of "UNKNOWN"
    COMPLIANCE_STATE_UNKNOWN = "UNKNOWN"

    #: A constant which can be used with the compliance_state property of a ComplianceRecordDimension.
    #: This constant has a value of "COMPLIANT"
    COMPLIANCE_STATE_COMPLIANT = "COMPLIANT"

    #: A constant which can be used with the compliance_state property of a ComplianceRecordDimension.
    #: This constant has a value of "NON_COMPLIANT"
    COMPLIANCE_STATE_NON_COMPLIANT = "NON_COMPLIANT"

    #: A constant which can be used with the compliance_state property of a ComplianceRecordDimension.
    #: This constant has a value of "WARNING"
    COMPLIANCE_STATE_WARNING = "WARNING"

    #: A constant which can be used with the compliance_level property of a ComplianceRecordDimension.
    #: This constant has a value of "FLEET"
    COMPLIANCE_LEVEL_FLEET = "FLEET"

    #: A constant which can be used with the compliance_level property of a ComplianceRecordDimension.
    #: This constant has a value of "TARGET"
    COMPLIANCE_LEVEL_TARGET = "TARGET"

    def __init__(self, **kwargs):
        """
        Initializes a new ComplianceRecordDimension object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compliance_state:
            The value to assign to the compliance_state property of this ComplianceRecordDimension.
            Allowed values for this property are: "UNKNOWN", "COMPLIANT", "NON_COMPLIANT", "WARNING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type compliance_state: str

        :param compliance_level:
            The value to assign to the compliance_level property of this ComplianceRecordDimension.
            Allowed values for this property are: "FLEET", "TARGET", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type compliance_level: str

        """
        self.swagger_types = {
            'compliance_state': 'str',
            'compliance_level': 'str'
        }
        self.attribute_map = {
            'compliance_state': 'complianceState',
            'compliance_level': 'complianceLevel'
        }
        self._compliance_state = None
        self._compliance_level = None

    @property
    def compliance_state(self):
        """
        **[Required]** Gets the compliance_state of this ComplianceRecordDimension.
        Last known compliance state.

        Allowed values for this property are: "UNKNOWN", "COMPLIANT", "NON_COMPLIANT", "WARNING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The compliance_state of this ComplianceRecordDimension.
        :rtype: str
        """
        return self._compliance_state

    @compliance_state.setter
    def compliance_state(self, compliance_state):
        """
        Sets the compliance_state of this ComplianceRecordDimension.
        Last known compliance state.


        :param compliance_state: The compliance_state of this ComplianceRecordDimension.
        :type: str
        """
        allowed_values = ["UNKNOWN", "COMPLIANT", "NON_COMPLIANT", "WARNING"]
        if not value_allowed_none_or_none_sentinel(compliance_state, allowed_values):
            compliance_state = 'UNKNOWN_ENUM_VALUE'
        self._compliance_state = compliance_state

    @property
    def compliance_level(self):
        """
        **[Required]** Gets the compliance_level of this ComplianceRecordDimension.
        Level at which the compliance is calculated.

        Allowed values for this property are: "FLEET", "TARGET", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The compliance_level of this ComplianceRecordDimension.
        :rtype: str
        """
        return self._compliance_level

    @compliance_level.setter
    def compliance_level(self, compliance_level):
        """
        Sets the compliance_level of this ComplianceRecordDimension.
        Level at which the compliance is calculated.


        :param compliance_level: The compliance_level of this ComplianceRecordDimension.
        :type: str
        """
        allowed_values = ["FLEET", "TARGET"]
        if not value_allowed_none_or_none_sentinel(compliance_level, allowed_values):
            compliance_level = 'UNKNOWN_ENUM_VALUE'
        self._compliance_level = compliance_level

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
