# coding: utf-8
# Copyright (c) 2016, 2025, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230801


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ServiceProviderSummary(object):
    """
    Summary of the Service Provider. Service provider offers services to the customer to support the delegated resources.
    """

    #: A constant which can be used with the service_types property of a ServiceProviderSummary.
    #: This constant has a value of "TROUBLESHOOTING"
    SERVICE_TYPES_TROUBLESHOOTING = "TROUBLESHOOTING"

    #: A constant which can be used with the service_types property of a ServiceProviderSummary.
    #: This constant has a value of "ASSISTED_PATCHING"
    SERVICE_TYPES_ASSISTED_PATCHING = "ASSISTED_PATCHING"

    #: A constant which can be used with the supported_resource_types property of a ServiceProviderSummary.
    #: This constant has a value of "VMCLUSTER"
    SUPPORTED_RESOURCE_TYPES_VMCLUSTER = "VMCLUSTER"

    #: A constant which can be used with the supported_resource_types property of a ServiceProviderSummary.
    #: This constant has a value of "CLOUDVMCLUSTER"
    SUPPORTED_RESOURCE_TYPES_CLOUDVMCLUSTER = "CLOUDVMCLUSTER"

    def __init__(self, **kwargs):
        """
        Initializes a new ServiceProviderSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this ServiceProviderSummary.
        :type id: str

        :param compartment_id:
            The value to assign to the compartment_id property of this ServiceProviderSummary.
        :type compartment_id: str

        :param name:
            The value to assign to the name property of this ServiceProviderSummary.
        :type name: str

        :param service_provider_type:
            The value to assign to the service_provider_type property of this ServiceProviderSummary.
        :type service_provider_type: str

        :param service_types:
            The value to assign to the service_types property of this ServiceProviderSummary.
            Allowed values for items in this list are: "TROUBLESHOOTING", "ASSISTED_PATCHING", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type service_types: list[str]

        :param supported_resource_types:
            The value to assign to the supported_resource_types property of this ServiceProviderSummary.
            Allowed values for items in this list are: "VMCLUSTER", "CLOUDVMCLUSTER", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type supported_resource_types: list[str]

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ServiceProviderSummary.
        :type lifecycle_state: str

        :param lifecycle_state_details:
            The value to assign to the lifecycle_state_details property of this ServiceProviderSummary.
        :type lifecycle_state_details: str

        :param time_created:
            The value to assign to the time_created property of this ServiceProviderSummary.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ServiceProviderSummary.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this ServiceProviderSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this ServiceProviderSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this ServiceProviderSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'id': 'str',
            'compartment_id': 'str',
            'name': 'str',
            'service_provider_type': 'str',
            'service_types': 'list[str]',
            'supported_resource_types': 'list[str]',
            'lifecycle_state': 'str',
            'lifecycle_state_details': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }
        self.attribute_map = {
            'id': 'id',
            'compartment_id': 'compartmentId',
            'name': 'name',
            'service_provider_type': 'serviceProviderType',
            'service_types': 'serviceTypes',
            'supported_resource_types': 'supportedResourceTypes',
            'lifecycle_state': 'lifecycleState',
            'lifecycle_state_details': 'lifecycleStateDetails',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }
        self._id = None
        self._compartment_id = None
        self._name = None
        self._service_provider_type = None
        self._service_types = None
        self._supported_resource_types = None
        self._lifecycle_state = None
        self._lifecycle_state_details = None
        self._time_created = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ServiceProviderSummary.
        Unique identifier for the Service Provider.


        :return: The id of this ServiceProviderSummary.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ServiceProviderSummary.
        Unique identifier for the Service Provider.


        :param id: The id of this ServiceProviderSummary.
        :type: str
        """
        self._id = id

    @property
    def compartment_id(self):
        """
        Gets the compartment_id of this ServiceProviderSummary.
        The OCID of the compartment that contains the Delegation Control.


        :return: The compartment_id of this ServiceProviderSummary.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ServiceProviderSummary.
        The OCID of the compartment that contains the Delegation Control.


        :param compartment_id: The compartment_id of this ServiceProviderSummary.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def name(self):
        """
        **[Required]** Gets the name of this ServiceProviderSummary.
        Unique name of the Service Provider.


        :return: The name of this ServiceProviderSummary.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this ServiceProviderSummary.
        Unique name of the Service Provider.


        :param name: The name of this ServiceProviderSummary.
        :type: str
        """
        self._name = name

    @property
    def service_provider_type(self):
        """
        Gets the service_provider_type of this ServiceProviderSummary.
        Service Provider type.


        :return: The service_provider_type of this ServiceProviderSummary.
        :rtype: str
        """
        return self._service_provider_type

    @service_provider_type.setter
    def service_provider_type(self, service_provider_type):
        """
        Sets the service_provider_type of this ServiceProviderSummary.
        Service Provider type.


        :param service_provider_type: The service_provider_type of this ServiceProviderSummary.
        :type: str
        """
        self._service_provider_type = service_provider_type

    @property
    def service_types(self):
        """
        Gets the service_types of this ServiceProviderSummary.
        Types of services offered by this provider.

        Allowed values for items in this list are: "TROUBLESHOOTING", "ASSISTED_PATCHING", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The service_types of this ServiceProviderSummary.
        :rtype: list[str]
        """
        return self._service_types

    @service_types.setter
    def service_types(self, service_types):
        """
        Sets the service_types of this ServiceProviderSummary.
        Types of services offered by this provider.


        :param service_types: The service_types of this ServiceProviderSummary.
        :type: list[str]
        """
        allowed_values = ["TROUBLESHOOTING", "ASSISTED_PATCHING"]
        if service_types:
            service_types[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in service_types]
        self._service_types = service_types

    @property
    def supported_resource_types(self):
        """
        Gets the supported_resource_types of this ServiceProviderSummary.
        Resource types for which this provider will provide service. Default to all if not specified.

        Allowed values for items in this list are: "VMCLUSTER", "CLOUDVMCLUSTER", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The supported_resource_types of this ServiceProviderSummary.
        :rtype: list[str]
        """
        return self._supported_resource_types

    @supported_resource_types.setter
    def supported_resource_types(self, supported_resource_types):
        """
        Sets the supported_resource_types of this ServiceProviderSummary.
        Resource types for which this provider will provide service. Default to all if not specified.


        :param supported_resource_types: The supported_resource_types of this ServiceProviderSummary.
        :type: list[str]
        """
        allowed_values = ["VMCLUSTER", "CLOUDVMCLUSTER"]
        if supported_resource_types:
            supported_resource_types[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in supported_resource_types]
        self._supported_resource_types = supported_resource_types

    @property
    def lifecycle_state(self):
        """
        Gets the lifecycle_state of this ServiceProviderSummary.
        The current lifecycle state of the Service Provider.


        :return: The lifecycle_state of this ServiceProviderSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ServiceProviderSummary.
        The current lifecycle state of the Service Provider.


        :param lifecycle_state: The lifecycle_state of this ServiceProviderSummary.
        :type: str
        """
        self._lifecycle_state = lifecycle_state

    @property
    def lifecycle_state_details(self):
        """
        Gets the lifecycle_state_details of this ServiceProviderSummary.
        Description of the current lifecycle state in more detail.


        :return: The lifecycle_state_details of this ServiceProviderSummary.
        :rtype: str
        """
        return self._lifecycle_state_details

    @lifecycle_state_details.setter
    def lifecycle_state_details(self, lifecycle_state_details):
        """
        Sets the lifecycle_state_details of this ServiceProviderSummary.
        Description of the current lifecycle state in more detail.


        :param lifecycle_state_details: The lifecycle_state_details of this ServiceProviderSummary.
        :type: str
        """
        self._lifecycle_state_details = lifecycle_state_details

    @property
    def time_created(self):
        """
        Gets the time_created of this ServiceProviderSummary.
        Time when the Service Provider was created expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this ServiceProviderSummary.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ServiceProviderSummary.
        Time when the Service Provider was created expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this ServiceProviderSummary.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        Gets the time_updated of this ServiceProviderSummary.
        Time when the Service Provider was last modified expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this ServiceProviderSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ServiceProviderSummary.
        Time when the Service Provider was last modified expressed in `RFC 3339`__ timestamp format, e.g. '2020-05-22T21:10:29.600Z'

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this ServiceProviderSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this ServiceProviderSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The freeform_tags of this ServiceProviderSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this ServiceProviderSummary.
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Department\": \"Finance\"}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param freeform_tags: The freeform_tags of this ServiceProviderSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this ServiceProviderSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :return: The defined_tags of this ServiceProviderSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this ServiceProviderSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        For more information, see `Resource Tags`__.

        Example: `{\"Operations\": {\"CostCenter\": \"42\"}}`

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm


        :param defined_tags: The defined_tags of this ServiceProviderSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this ServiceProviderSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this ServiceProviderSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this ServiceProviderSummary.
        System tags for this resource. Each key is predefined and scoped to a namespace.

        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this ServiceProviderSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
